/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.cedarling.service.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.as.client.OpenIdConfigurationClient;
import io.jans.as.client.OpenIdConfigurationResponse;
import io.jans.as.model.crypto.AuthCryptoProvider;
import io.jans.as.model.crypto.signature.AlgorithmFamily;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.jwt.JwtClaims;
import io.jans.lock.cedarling.model.CedarlingPermission;
import io.jans.lock.cedarling.service.CedarlingAuthorizationService;
import io.jans.lock.cedarling.service.filter.CedarlingProtection;
import io.jans.lock.cedarling.service.security.api.ProtectedCedarlingApi;
import io.jans.lock.model.config.AppConfiguration;
import io.jans.util.StringHelper;
import io.jans.util.exception.InvalidConfigurationException;
import io.jans.util.exception.MissingResourceException;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;

@ApplicationScoped
public class CedarlingProtectionService
implements CedarlingProtection {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private CedarlingAuthorizationService authorizationService;
    private OpenIdConfigurationResponse oidcConfig;
    private ObjectMapper mapper;

    @PostConstruct
    private void init() {
        try {
            this.mapper = new ObjectMapper();
            this.oidcConfig = this.getOpenIdConfiguration();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Response processAuthorization(ContainerRequestContext requestContext, HttpHeaders headers, ResourceInfo resourceInfo) {
        try {
            String token = headers.getHeaderString("Authorization");
            boolean authFound = StringUtils.isNotEmpty((CharSequence)token);
            this.log.info("Authorization header {} found", (Object)(authFound ? "" : "not"));
            if (!authFound) {
                this.log.info("Request is missing authorization header");
                return this.simpleResponse(Response.Status.UNAUTHORIZED, "No authorization header found");
            }
            token = token.replaceFirst("Bearer\\s+", "");
            this.log.debug("Validating token {}", (Object)token);
            List<CedarlingPermission> requestedPermissions = this.getRequestedOperations(resourceInfo);
            this.log.info("Check access to requested opearations: {}", requestedPermissions);
            if (requestedPermissions.size() == 0) {
                return this.simpleResponse(Response.Status.INTERNAL_SERVER_ERROR, "Access to operation is not correct");
            }
            Jwt jwt = this.tokenAsJwt(token);
            if (jwt == null) {
                return this.simpleResponse(Response.Status.FORBIDDEN, "Provided token isn't JWT encoded");
            }
            JwtClaims claims = jwt.getClaims();
            if (!this.oidcConfig.getIssuer().equals(claims.getClaimAsString("iss"))) {
                return this.simpleResponse(Response.Status.FORBIDDEN, "Invalid token issuer");
            }
            int exp = Optional.ofNullable(claims.getClaimAsInteger("exp")).orElse(0);
            if (1000L * (long)exp < System.currentTimeMillis()) {
                return this.simpleResponse(Response.Status.FORBIDDEN, "Expired token");
            }
            AuthCryptoProvider cryptoProvider = new AuthCryptoProvider(null, null, null, true);
            SignatureAlgorithm signatureAlg = jwt.getHeader().getSignatureAlgorithm();
            if (AlgorithmFamily.HMAC.equals((Object)signatureAlg.getFamily())) {
                return this.simpleResponse(Response.Status.INTERNAL_SERVER_ERROR, "HMAC algorithm not allowed for token signature. Please use an algorithm in the EC, ED, or RSA family for signing");
            }
            Map jwks = (Map)this.mapper.readValue(new URL(this.oidcConfig.getJwksUri()), Map.class);
            boolean valid = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), jwt.getHeader().getKeyId(), new JSONObject(jwks), null, signatureAlg);
            if (valid) {
                boolean authorized = true;
                Map<String, String> tokens = this.getCedarlingTokens(token);
                for (CedarlingPermission requestedPermission : requestedPermissions) {
                    if (authorized &= this.authorizationService.authorize(tokens, requestedPermission.getAction(), this.getCedarlingResource(requestedPermission), this.getCedarlingContext())) continue;
                    this.log.error("Insufficient permissions to access '{}'", (Object)requestedPermission);
                    break;
                }
                if (authorized) {
                    return null;
                }
            }
            return this.simpleResponse(Response.Status.FORBIDDEN, "Invalid token signature or insufficient scopes");
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return this.simpleResponse(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    private Jwt tokenAsJwt(String token) {
        Jwt jwt = null;
        try {
            jwt = Jwt.parse((String)token);
            if (this.log.isTraceEnabled()) {
                this.log.trace("This looks like a JWT token");
            }
        }
        catch (InvalidJwtException e) {
            this.log.trace("Not a JWT token");
        }
        return jwt;
    }

    private Map<String, String> getCedarlingTokens(String accessToken) {
        return Map.of("access_token", accessToken);
    }

    private Map<String, Object> getCedarlingResource(CedarlingPermission requestedPermission) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int id = requestedPermission.hashCode();
        id = id > 0 ? id : -id;
        map.putAll(Map.of("cedar_entity_mapping", Map.of("entity_type", requestedPermission.getResource(), "id", requestedPermission.getId())));
        map.putAll(Map.of("url", Map.of("host", "", "path", requestedPermission.getPath(), "protocol", "")));
        map.putAll(Map.of("header", Map.of()));
        return map;
    }

    private Map<String, Object> getCedarlingContext() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        return map;
    }

    private List<CedarlingPermission> getRequestedOperations(ResourceInfo resourceInfo) {
        ArrayList<CedarlingPermission> cedarlingPermissions = new ArrayList<CedarlingPermission>();
        this.addCedarlingPermission(cedarlingPermissions, this.getOperationFromAnnotation(resourceInfo.getResourceClass()));
        this.addCedarlingPermission(cedarlingPermissions, this.getOperationFromAnnotation(resourceInfo.getResourceMethod()));
        Method baseMethod = resourceInfo.getResourceMethod();
        for (Class<?> interfaces : resourceInfo.getResourceClass().getInterfaces()) {
            this.addCedarlingPermission(cedarlingPermissions, this.getOperationFromAnnotation(interfaces));
            Method method = null;
            try {
                method = interfaces.getDeclaredMethod(baseMethod.getName(), baseMethod.getParameterTypes());
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
            if (method == null) continue;
            this.addCedarlingPermission(cedarlingPermissions, this.getOperationFromAnnotation(method));
        }
        return cedarlingPermissions;
    }

    private void addCedarlingPermission(List<CedarlingPermission> cedarlingPermissions, CedarlingPermission permission) {
        if (permission != null) {
            cedarlingPermissions.add(permission);
        }
    }

    private CedarlingPermission getOperationFromAnnotation(AnnotatedElement elem) {
        Optional<ProtectedCedarlingApi> annotation = CedarlingProtectionService.optAnnnotation(elem, ProtectedCedarlingApi.class);
        if (annotation.isPresent()) {
            ProtectedCedarlingApi cedarlingPermission = annotation.get();
            return new CedarlingPermission(cedarlingPermission.action(), cedarlingPermission.resource(), cedarlingPermission.id(), cedarlingPermission.path());
        }
        return null;
    }

    private static <T extends Annotation> Optional<T> optAnnnotation(AnnotatedElement elem, Class<T> cls) {
        return Optional.ofNullable(elem.getAnnotation(cls));
    }

    private OpenIdConfigurationResponse getOpenIdConfiguration() {
        String openIdIssuer = this.appConfiguration.getOpenIdIssuer();
        if (StringHelper.isEmpty((String)openIdIssuer)) {
            throw new InvalidConfigurationException("OpenIdIssuer Url is invalid");
        }
        String openIdIssuerEndpoint = openIdIssuer + "/.well-known/openid-configuration";
        OpenIdConfigurationClient client = new OpenIdConfigurationClient(openIdIssuerEndpoint);
        OpenIdConfigurationResponse openIdConfigurationResponse = client.execOpenIdConfiguration();
        if (openIdConfigurationResponse == null || openIdConfigurationResponse.getStatus() != 200) {
            throw new MissingResourceException("Failed to load OpenID configuration!");
        }
        this.log.info("Successfully loaded OpenID configuration");
        return openIdConfigurationResponse;
    }

    @Override
    public Response simpleResponse(Response.Status status, String detail) {
        return Response.status((Response.Status)status).entity((Object)detail).build();
    }
}

