/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.cedarling.service.app.audit;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.lock.model.app.audit.AuditLogEntry;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.slf4j.Logger;

@ApplicationScoped
public class ApplicationCedarlingAuditLogger {
    @Inject
    private Logger log;
    private ObjectMapper mapper;

    @PostConstruct
    public void init() {
        this.mapper = new ObjectMapper();
        this.mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ"));
        this.mapper.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public void log(AuditLogEntry auditLogEntry, boolean success) {
        if (auditLogEntry != null) {
            auditLogEntry.setSuccess(success);
            this.loggingThroughFile(auditLogEntry);
        }
    }

    private void loggingThroughFile(AuditLogEntry auditLogEntry) {
        try {
            if (this.log.isInfoEnabled()) {
                String entry = this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)auditLogEntry);
                this.log.info(entry);
            }
        }
        catch (IOException e) {
            this.log.error("Can't serialize the application audit log", (Throwable)e);
        }
    }
}

