/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.client.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsonorg.JsonOrgModule;
import io.jans.util.StringHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUtil {
    private static final Logger log = LoggerFactory.getLogger(ClientUtil.class);

    private ClientUtil() {
    }

    public static String toPrettyJson(JSONObject jsonObject) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JsonOrgModule());
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject);
    }

    public static List<String> extractListByKey(JSONObject jsonObject, String key) {
        ArrayList<String> result = new ArrayList<String>();
        if (!jsonObject.has(key)) {
            return result;
        }
        JSONArray arrayOfValues = jsonObject.optJSONArray(key);
        if (arrayOfValues != null) {
            for (int i = 0; i < arrayOfValues.length(); ++i) {
                String v = arrayOfValues.optString(i);
                if (!StringHelper.isNotEmpty((String)v)) continue;
                result.add(v);
            }
            return result;
        }
        String listString = jsonObject.optString(key);
        if (StringHelper.isNotEmpty((String)listString)) {
            String[] arrayOfStringValues;
            for (String c : arrayOfStringValues = listString.split(" ")) {
                if (!StringHelper.isNotEmpty((String)c)) continue;
                result.add(c);
            }
        }
        return result;
    }

    public static List<String> extractListByKeyOptString(JSONObject jsonObject, String key) {
        ArrayList<String> values = new ArrayList<String>();
        if (jsonObject == null || StringHelper.isEmpty((String)key) || !jsonObject.has(key)) {
            return values;
        }
        JSONArray jsonArray = jsonObject.optJSONArray(key);
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                String value = jsonArray.optString(i);
                if (value == null) continue;
                values.add(value);
            }
        } else {
            String value = jsonObject.optString(key);
            if (value != null) {
                values.add(value);
            }
        }
        return values;
    }

    public static Integer integerOrNull(JSONObject jsonObject, String key) {
        return jsonObject.has(key) ? (!Objects.equals(jsonObject.get(key).toString(), "null") ? Integer.valueOf(jsonObject.optInt(key)) : null) : null;
    }

    public static Boolean booleanOrNull(JSONObject jsonObject, String key) {
        return jsonObject.has(key) ? Boolean.valueOf(jsonObject.optBoolean(key)) : null;
    }

    public static Long longOrNull(JSONObject jsonObject, String key) {
        return jsonObject.has(key) ? Long.valueOf(jsonObject.optLong(key)) : null;
    }

    public static String stringOrNull(JSONObject jsonObject, String key) {
        return jsonObject.has(key) ? jsonObject.optString(key) : null;
    }

    public static CloseableHttpClient createHttpClient(String tlsVersion, String[] ciphers) {
        CloseableHttpClient closeableHttpClient;
        SSLContext sslContext = SSLContexts.createDefault();
        SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(sslContext, new String[]{tlsVersion}, ciphers, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Registry registry = RegistryBuilder.create().register("https", (Object)sslConnectionFactory).register("http", (Object)new PlainConnectionSocketFactory()).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(registry);
        try {
            closeableHttpClient = HttpClients.custom().setSSLContext(sslContext).setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).setConnectionManager((HttpClientConnectionManager)cm).build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    cm.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error("Error creating HttpClient with a custom TLS version and custom ciphers", (Throwable)e);
                return null;
            }
        }
        cm.close();
        return closeableHttpClient;
    }
}

