/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.grpc.bridge.generator.protobuf;

import com.github.javaparser.ParseResult;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.AccessSpecifier;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.RecordDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.VoidType;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import com.github.javaparser.resolution.SymbolResolver;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.resolution.types.ResolvedArrayType;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.JavaSymbolSolver;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionTypeParameter;
import com.github.javaparser.symbolsolver.resolution.typesolvers.CombinedTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JarTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JavaParserTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import com.github.javaparser.utils.Log;
import com.github.javaparser.utils.Pair;
import com.github.javaparser.utils.SourceRoot;
import dev.resteasy.grpc.bridge.generator.i18n.Messages;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.core.Response;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;

public class JavaToProtobufGenerator {
    private static final Logger logger = Logger.getLogger(JavaToProtobufGenerator.class);
    private static final String LS = System.lineSeparator();
    private static final String SSE_EVENT_CLASSNAME = "dev_resteasy_grpc_bridge_runtime_sse___SseEvent";
    private static Map<String, String> JAVA_PRIMITIVE_TO_PROTOBUF_MAP = new HashMap<String, String>();
    private static Map<String, String> PROTUBUF_PRIMITIVE_TO_ARRAY_MAP = new HashMap<String, String>();
    private static Map<String, String> JAVA_WRAPPER_TO_WARRAY_MAP = new HashMap<String, String>();
    private static Map<String, String> JAVA_BUILTIN_TO_PROTOBOF_IO = new HashMap<String, String>();
    private static Map<String, String> JAVA_BUILTIN_TO_PROTOBUF_FIELD = new HashMap<String, String>();
    private static Map<String, String> PRIMITIVE_WRAPPER_DEFINITIONS = new HashMap<String, String>();
    private static Map<String, String> JAVA_BUILTIN_TO_PROTOBUF_ARRAYS = new HashMap<String, String>();
    private static Map<String, String> JAVA_COMPONENT_TYPE_TO_ARRAY_PROTO_TYPE = new HashMap<String, String>();
    private static Map<String, String> PRIMITIVE_ARRAY_TYPE = new HashMap<String, String>();
    private static Set<String> ANNOTATIONS = new HashSet<String>();
    private static Set<String> HTTP_VERBS = new HashSet<String>();
    private static String[] args;
    private static String prefix;
    private static boolean needEmpty;
    private static boolean needList;
    private static boolean needSet;
    private static boolean needArrayList;
    private static boolean needHashSet;
    private static boolean needMap;
    private static boolean needHashMap;
    private static boolean needMultiMap;
    private static boolean needMultiHashMap;
    private static Set<ResolvedType> pendingTypes;
    private static Set<String> entityMessageTypes;
    private static Set<String> returnMessageTypes;
    private static Set<String> jars;
    private static Set<String> additionalClasses;
    private static Set<String> nonGenericClasses;
    private static Set<String> visited;
    private static JavaSymbolSolver symbolSolver;
    private static CombinedTypeSolver combinedTypeSolver;
    private static ReferenceTypeImpl objectType;
    private static ClassVisitor classVisitor;
    private static JakartaRESTResourceVisitor jakartaRESTResourceVisitor;
    private static boolean started;
    private static int counter;
    private static boolean isSSE;
    private static SortedSet<String> repeatedTypes;
    private static Map<String, String> normalizer;
    private static Set<String> entityTypesForFile;
    private static AtomicInteger classnameCounter;
    private static Map<String, String> classnames;
    private static Set<String> rpcNames;
    private static Map<String, String> classnameMap;
    private static Map<ResolvedReferenceType, ResolvedReferenceType> objectifiedTypes;
    private static Map<String, RecordDeclaration> recordMap;
    private static ReflectionTypeParameter[] TV;
    private static String arrayDef;
    private static String arrayHolderDef;
    private static String LIST_DEF;
    private static String SET_DEF;
    private static String MAP_DEF;
    private static String MULTIMAP_DEF;
    private static String ARRAYLIST_DEF;
    private static String HASHSET_DEF;
    private static String HASHMAP_DEF;
    private static String MULTIMAP_IMPL_DEF;
    public static ReflectionClassDeclaration rcd;

    public static void main(String[] args) throws IOException {
        for (int i = 0; i < args.length; ++i) {
            logger.debug((Object)("arg[" + i + "]: " + args[i]));
        }
        if (args == null || args.length < 4) {
            logger.info((Object)"need four args");
            logger.info((Object)"  arg[0]: root directory");
            logger.info((Object)"  arg[1]: package to be used in .proto file");
            logger.info((Object)"  arg[2]: java package to be used in .proto file");
            logger.info((Object)"  arg[3]: java outer classname to be generated from .proto file");
            logger.info((Object)"  -Djars: comma separated of jars [optional]");
            logger.info((Object)"  -Dclasses: comma separated of addition classes [optional]");
            return;
        }
        JavaToProtobufGenerator.args = args;
        prefix = args[3];
        logger.debug((Object)"starting JavaToProtobufGenerator");
        String s = System.getProperty("jars", "default");
        jars = "default".equals(s) || "".equals(s) ? new CopyOnWriteArraySet<String>() : new CopyOnWriteArraySet<String>(Arrays.asList(s.split(",")));
        s = System.getProperty("classes", "default");
        additionalClasses = "default".equals(s) || "".equals(s) ? new CopyOnWriteArraySet<String>() : new CopyOnWriteArraySet<String>(Arrays.asList(s.split(",")));
        StringBuilder sb = new StringBuilder();
        JavaToProtobufGenerator.protobufHeader(args, sb);
        new JavaToProtobufGenerator().processClasses(args, sb);
        int i = 0;
        while (!pendingTypes.isEmpty() && i++ < 100) {
            for (ResolvedType r : pendingTypes) {
                if (!r.isReferenceType()) continue;
                classVisitor.visit(JavaToProtobufGenerator.objectify(r.asReferenceType()), sb);
            }
        }
        JavaToProtobufGenerator.finishProto(sb);
        JavaToProtobufGenerator.writeProtoFile(args, sb);
        JavaToProtobufGenerator.createProtobufDirectory(args);
        JavaToProtobufGenerator.writeEntityTypesFile(args);
        JavaToProtobufGenerator.writeNormalizer(args);
    }

    private static void protobufHeader(String[] args, StringBuilder sb) {
        sb.append("syntax = \"proto3\";" + LS);
        sb.append("package " + args[1].replace('-', '.') + ";" + LS);
        sb.append("import \"google/protobuf/any.proto\";" + LS);
        sb.append("import \"google/protobuf/empty.proto\";" + LS);
        sb.append("import \"google/protobuf/timestamp.proto\";" + LS);
        sb.append("import \"dev/resteasy/grpc/arrays/arrays.proto\";" + LS);
        sb.append("option java_package = \"" + args[2] + "\";" + LS);
        sb.append("option java_outer_classname = \"" + args[3] + "_proto\";" + LS);
    }

    private void processClasses(String[] args, StringBuilder sb) throws IOException {
        Log.setAdapter((Log.Adapter)new Log.StandardOutStandardErrorAdapter());
        Path path = Path.of(args[0], "/src/main/java/");
        SourceRoot sourceRoot = new SourceRoot(path);
        ReflectionTypeSolver reflectionTypeSolver = new ReflectionTypeSolver();
        JavaParserTypeSolver javaParserTypeSolver = new JavaParserTypeSolver(path);
        combinedTypeSolver = new CombinedTypeSolver(new TypeSolver[0]);
        combinedTypeSolver.add((TypeSolver)reflectionTypeSolver);
        combinedTypeSolver.add((TypeSolver)javaParserTypeSolver);
        for (String s : jars) {
            combinedTypeSolver.add((TypeSolver)new JarTypeSolver(s));
        }
        objectType = new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)rcd);
        symbolSolver = new JavaSymbolSolver((TypeSolver)combinedTypeSolver);
        sourceRoot.getParserConfiguration().setSymbolResolver((SymbolResolver)symbolSolver);
        sourceRoot.getParserConfiguration().setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_17);
        for (int i = 0; i < 10; ++i) {
            JavaToProtobufGenerator.TV[i] = new ReflectionTypeParameter(Dummy.class.getTypeParameters()[i], false, (TypeSolver)combinedTypeSolver);
        }
        List list = sourceRoot.tryToParse();
        for (ParseResult p : list) {
            jakartaRESTResourceVisitor.visit((CompilationUnit)p.getResult().get(), sb);
        }
        if (started) {
            sb.append("}" + LS);
        }
        JavaToProtobufGenerator.processAdditionalClasses(symbolSolver, sb);
    }

    private static void processAdditionalClasses(JavaSymbolSolver symbolSolver, StringBuilder sb) throws FileNotFoundException {
        StaticJavaParser.getConfiguration().setSymbolResolver((SymbolResolver)symbolSolver);
        StaticJavaParser.getConfiguration().setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_17);
        for (String string : additionalClasses) {
            int n = string.lastIndexOf(":");
            if (n < 0) {
                throw Messages.MESSAGES.badSyntax(string);
            }
            String dir = string.substring(0, n).trim();
            nonGenericClasses.add(string.substring(n + 1));
            String string2 = dir + File.separator + string.substring(n + 1).replace(".", File.separator) + ".java";
            CompilationUnit cu = StaticJavaParser.parse((File)new File(string2));
            classVisitor.visit(cu, sb);
        }
        if (isSSE) {
            sb.append(LS).append("message dev_resteasy_grpc_bridge_runtime_sse___SseEvent {" + LS).append("  string comment = ").append(counter++).append(";").append(LS).append("  string id = ").append(counter++).append(";").append(LS).append("  string name = ").append(counter++).append(";").append(LS).append("  google.protobuf.Any data = ").append(counter++).append(";").append(LS).append("  int64 reconnectDelay = ").append(counter++).append(";").append(LS).append("}").append(LS);
        }
    }

    private static void finishProto(StringBuilder sb) {
        if (needEmpty) {
            sb.append(LS + "message gEmpty {}");
            entityMessageTypes.add("gEmpty");
            returnMessageTypes.add("gEmpty");
        }
        for (String wrapper : PRIMITIVE_WRAPPER_DEFINITIONS.values()) {
            counter = 1;
            sb.append(LS).append(wrapper.replace("$V$", String.valueOf(counter++)));
        }
        entityMessageTypes.add("java_util___List");
        returnMessageTypes.add("java_util___List");
        entityMessageTypes.add("java_util___Set");
        returnMessageTypes.add("java_util___Set");
        entityMessageTypes.add("java_util___ArrayList");
        returnMessageTypes.add("java_util___ArrayList");
        entityMessageTypes.add("java_util___HashSet");
        returnMessageTypes.add("java_util___HashSet");
        JavaToProtobufGenerator.createGeneralEntityMessageType(sb);
        JavaToProtobufGenerator.createGeneralReturnMessageType(sb);
        if (needList) {
            sb.append(String.format(LIST_DEF, new Object[0]));
        }
        if (needSet) {
            sb.append(String.format(SET_DEF, new Object[0]));
        }
        if (needMap) {
            sb.append(String.format(MAP_DEF, new Object[0]));
        }
        if (needMultiMap) {
            sb.append(String.format(MULTIMAP_DEF, new Object[0]));
        }
        if (needArrayList) {
            sb.append(String.format(ARRAYLIST_DEF, new Object[0]));
        }
        if (needHashSet) {
            sb.append(String.format(HASHSET_DEF, new Object[0]));
        }
        if (needHashMap) {
            sb.append(String.format(HASHMAP_DEF, new Object[0]));
        }
        if (needMultiHashMap) {
            sb.append(String.format(MULTIMAP_IMPL_DEF, new Object[0]));
        }
    }

    private static void createGeneralEntityMessageType(StringBuilder sb) {
        counter = 1;
        sb.append(LS + LS + "message gHeader {" + LS).append("   repeated string values = ").append(counter++).append(";" + LS + "}");
        counter = 1;
        sb.append(LS + LS + "message gCookie {" + LS).append("   string name = ").append(counter++).append(";" + LS).append("   string value = ").append(counter++).append(";" + LS).append("   int32  version = ").append(counter++).append(";" + LS).append("   string path = ").append(counter++).append(";" + LS).append("   string domain = ").append(counter++).append(";" + LS).append("}");
        counter = 1;
        sb.append(LS + LS + "message gNewCookie {" + LS).append("   string name = ").append(counter++).append(";" + LS).append("   string value = ").append(counter++).append(";" + LS).append("   int32  version = ").append(counter++).append(";" + LS).append("   string path = ").append(counter++).append(";" + LS).append("   string domain = ").append(counter++).append(";" + LS).append("   string comment = ").append(counter++).append(";" + LS).append("   int32 maxAge = ").append(counter++).append(";" + LS).append("   google.protobuf.Timestamp expiry = ").append(counter++).append(";" + LS).append("   bool secure = ").append(counter++).append(";" + LS).append("   bool httpOnly = ").append(counter++).append(";" + LS + LS).append("   enum SameSite {" + LS).append("      NONE   = 0;" + LS).append("      LAX    = 1;" + LS).append("      STRICT = 2;" + LS).append("   }" + LS + LS).append("   SameSite sameSite = ").append(counter++).append(";" + LS).append("}");
        counter = 1;
        sb.append(LS + LS + "message ServletInfo {" + LS).append("   string characterEncoding = ").append(counter++).append(";" + LS).append("   string clientAddress = ").append(counter++).append(";" + LS).append("   string clientHost = ").append(counter++).append(";" + LS).append("   int32  clientPort = ").append(counter++).append(";" + LS).append("}");
        counter = 1;
        sb.append(LS + LS + "message FormValues {" + LS).append("   repeated string formValues_field = ").append(counter++).append(";" + LS).append("}");
        counter = 1;
        sb.append(LS + LS + "message FormMap {" + LS).append("   map<string, FormValues> formMap_field = ").append(counter++).append(";" + LS).append("}");
        counter = 1;
        sb.append(LS + LS + "message GeneralEntityMessage {" + LS).append("   ServletInfo servletInfo = ").append(counter++).append(";" + LS).append("   string URL = ").append(counter++).append(";" + LS).append("   map<string, gHeader> headers = ").append(counter++).append(";" + LS).append("   repeated gCookie cookies = ").append(counter++).append(";" + LS).append("   string httpMethod = ").append(counter++).append(";" + LS).append("   oneof messageType {" + LS);
        for (String messageType : entityMessageTypes) {
            if ("ANY".equals(messageType)) continue;
            String simpleMessageType = messageType.contains(".") ? messageType.substring(messageType.lastIndexOf(46) + 1) : messageType;
            sb.append("      ").append(messageType).append(" ").append(JavaToProtobufGenerator.namify(simpleMessageType)).append("_field").append(" = ").append(counter++).append(";" + LS);
        }
        sb.append("      dev_resteasy_grpc_arrays___ArrayHolder dev_resteasy_grpc_arrays___ArrayHolder_field = ").append(counter++).append(";" + LS);
        sb.append("      FormMap form_field = ").append(counter++).append(";" + LS);
        sb.append("   }" + LS + "}" + LS);
    }

    private static void createGeneralReturnMessageType(StringBuilder sb) {
        counter = 1;
        sb.append(LS + "message GeneralReturnMessage {" + LS).append("   map<string, gHeader> headers = ").append(counter++).append(";" + LS).append("   repeated gNewCookie cookies = ").append(counter++).append(";" + LS).append("   int32 status = ").append(counter++).append(";" + LS).append("   oneof messageType {" + LS);
        for (String messageType : returnMessageTypes) {
            if ("ANY".equals(messageType)) continue;
            String simpleMessageType = messageType.contains(".") ? messageType.substring(messageType.lastIndexOf(46) + 1) : messageType;
            sb.append("      ").append(messageType).append(" ").append(JavaToProtobufGenerator.namify(simpleMessageType)).append("_field").append(" = ").append(counter++).append(";" + LS);
        }
        sb.append("   }" + LS + "}" + LS);
    }

    private static void writeProtoFile(String[] args, StringBuilder sb) throws IOException {
        Path path = Files.createDirectories(Path.of(args[0], "src", "main", "proto"), new FileAttribute[0]);
        counter = 0;
        JavaToProtobufGenerator.createArrayDefs(args, sb);
        sb.append(LS + "//////////  synthetic names: //////////" + LS);
        for (String s : classnames.keySet()) {
            sb.append("// ").append(classnames.get(s)).append("->");
            if (s.contains("<")) {
                s = s.substring(0, s.indexOf(60));
            }
            sb.append(s).append(LS);
        }
        Files.writeString(path.resolve(args[3] + ".proto"), (CharSequence)sb.toString(), StandardCharsets.UTF_8, new OpenOption[0]);
        logger.debug((Object)"done");
    }

    private static void createProtobufDirectory(String[] args) {
        String path = args[0] + "/target/generatedSources";
        for (String s : args[1].split("\\.")) {
            File dir = new File(path = path + "/" + s);
            if (dir.exists()) continue;
            dir.mkdir();
        }
    }

    private static void createArrayDefs(String[] args, StringBuilder wrapperBuilder) {
        BufferedWriter writer = null;
        try {
            for (String type : repeatedTypes) {
                if ("java.lang.Object".equals(type)) {
                    type = "google.protobuf.Any";
                    continue;
                }
                String component = type.substring(0, type.indexOf("___WArray"));
                if (component.startsWith("dev.resteasy.grpc.arrays.")) continue;
                wrapperBuilder.append(String.format(arrayDef, type, component));
            }
            wrapperBuilder.append(String.format(arrayHolderDef, new Object[0]));
            TreeSet<String> holderTypes = new TreeSet<String>(JAVA_BUILTIN_TO_PROTOBUF_ARRAYS.values());
            for (String rt : repeatedTypes) {
                if (rt.endsWith("java_lang___Object___WArray")) continue;
                holderTypes.add(rt);
            }
            counter = 0;
            wrapperBuilder.append("message dev_resteasy_grpc_arrays___ArrayHolder {" + LS).append("   oneof messageType {" + LS);
            for (String type : holderTypes) {
                if (JAVA_PRIMITIVE_TO_PROTOBUF_MAP.containsKey(type)) continue;
                String typeName = type.contains(".") ? type.substring(type.lastIndexOf(46) + 1) : type;
                wrapperBuilder.append("      ").append(type).append(" ").append(typeName).append("_field = ").append(++counter).append(";" + LS);
            }
            wrapperBuilder.append("      google.protobuf.Any any_field = ").append(++counter).append(";" + LS);
            wrapperBuilder.append("   }" + LS).append("}" + LS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void writeEntityTypesFile(String[] args) throws IOException {
        Path path = Path.of(args[0], "/target");
        Files.createDirectories(path, new FileAttribute[0]);
        File file = new File(path.toString() + "/entityTypes");
        try (FileWriter writer = new FileWriter(file);){
            for (String type : entityTypesForFile) {
                String s1 = type.substring(0, type.indexOf(" "));
                String s2 = type.substring(type.indexOf(" ") + 1);
                writer.write(s1 + " " + s2 + LS);
            }
        }
        catch (Exception e) {
            logger.error((Object)"HMMMMMM");
        }
    }

    private static void writeNormalizer(String[] args) throws IOException {
        Path path = Path.of(args[0], "/target");
        Files.createDirectories(path, new FileAttribute[0]);
        File file = new File(path.toString() + "/normalizer");
        try (FileWriter writer = new FileWriter(file);){
            for (String type : normalizer.keySet()) {
                writer.write(type + "|" + normalizer.get(type) + LS);
            }
        }
        catch (Exception e) {
            logger.error((Object)"HMMMMMM");
        }
    }

    private static ResolvedType objectify(ResolvedReferenceType clazz) {
        if (objectifiedTypes.containsKey(clazz)) {
            return (ResolvedType)objectifiedTypes.get(clazz);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Pair pair : clazz.getTypeParametersMap()) {
            ResolvedType rt;
            if (((ResolvedType)pair.b).isTypeVariable() || ((ResolvedType)pair.b).isWildcard()) {
                if (((ResolvedTypeParameterDeclaration)pair.a).getBounds().size() > 0) {
                    ResolvedTypeParameterDeclaration.Bound bound = (ResolvedTypeParameterDeclaration.Bound)((ResolvedTypeParameterDeclaration)pair.a).getBounds().get(0);
                    if (bound.isExtends()) {
                        list.add(bound.getType());
                        continue;
                    }
                    list.add(objectType);
                    continue;
                }
                list.add(objectType);
                continue;
            }
            if (((ResolvedType)pair.b).isArray()) {
                rt = ((ResolvedType)pair.b).asArrayType().getComponentType();
                if (rt.isTypeVariable()) {
                    list.add(new ResolvedArrayType((ResolvedType)objectType));
                    continue;
                }
                if (rt.isReference()) {
                    ResolvedType ort = JavaToProtobufGenerator.objectify(rt.asReferenceType());
                    list.add(new ResolvedArrayType(ort));
                    if (visited.contains(rt.describe()) || JAVA_BUILTIN_TO_PROTOBUF_FIELD.containsKey(rt.describe()) || "java.lang.Object".equals(rt.describe()) || JavaToProtobufGenerator.isInterface(ort)) continue;
                    pendingTypes.add(rt);
                    continue;
                }
                list.add(((ResolvedType)pair.b).asArrayType());
                continue;
            }
            if (!((ResolvedType)pair.b).isReferenceType()) continue;
            rt = JavaToProtobufGenerator.objectify(((ResolvedType)pair.b).asReferenceType());
            list.add(rt);
            if (visited.contains(rt.describe()) || JAVA_BUILTIN_TO_PROTOBUF_FIELD.containsKey(rt.describe()) || "java.lang.Object".equals(rt.describe()) || JavaToProtobufGenerator.isInterface(rt)) continue;
            pendingTypes.add(rt);
        }
        ReferenceTypeImpl rti = new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)clazz.getTypeDeclaration().get(), list);
        if (!visited.contains(rti.describe())) {
            pendingTypes.add((ResolvedType)rti);
        }
        if (!clazz.describe().equals(rti.describe())) {
            normalizer.put(clazz.describe(), rti.describe());
        }
        objectifiedTypes.put(clazz, (ResolvedReferenceType)rti);
        return rti;
    }

    private static ResolvedArrayType objectify(ResolvedArrayType array) {
        return array;
    }

    private static void visitCollection(ResolvedType resolvedType, Set<String> fieldNames, StringBuilder sb) {
        Pair<ResolvedTypeParameterDeclaration, ResolvedType> pair = JavaToProtobufGenerator.getParameterType(resolvedType);
        ResolvedType rt = (ResolvedType)pair.b;
        String fqn = JavaToProtobufGenerator.fqnifyClass(rt, "___");
        if (!"google.protobuf.Any".equals(fqn)) {
            classnameMap.put(rt.describe(), fqn);
            pendingTypes.add((ResolvedType)rt.asReferenceType());
        }
        sb.append("  //").append(rt.describe()).append(LS).append("  repeated ").append(fqn).append(" data = ").append(counter++).append(";" + LS);
    }

    private static void visitRecord(ResolvedType resolvedType, StringBuilder sb) {
        sb.append(LS).append("// Record: ").append(resolvedType.describe());
        ResolvedReferenceType clazz = resolvedType.asReferenceType();
        RecordDeclaration rd = recordMap.get(((ResolvedReferenceTypeDeclaration)clazz.getTypeDeclaration().get()).getQualifiedName());
        String innerClass = JavaToProtobufGenerator.isInnerClass((ResolvedReferenceTypeDeclaration)resolvedType.asReferenceType().getTypeDeclaration().get());
        String javabufName = JavaToProtobufGenerator.fqnifyClass(resolvedType, innerClass);
        sb.append(LS).append("message ").append(javabufName).append(" {" + LS);
        NodeList nl = rd.getParameters();
        HashSet<String> fieldNames = new HashSet<String>();
        for (Parameter p : nl) {
            JavaToProtobufGenerator.visitField(clazz, p.resolve().getType(), p.getNameAsString(), sb, fieldNames);
        }
        sb.append("}" + LS);
    }

    private static void visitMap(ResolvedType resolvedType, StringBuilder sb) {
        String fqnValue;
        String fqnKey;
        Pair<ResolvedTypeParameterDeclaration, ResolvedType> pairKey = JavaToProtobufGenerator.getParameterType(resolvedType, 0);
        ResolvedType rtKey = (ResolvedType)pairKey.b;
        if (rtKey.isReference()) {
            rtKey = JavaToProtobufGenerator.objectify(rtKey.asReferenceType());
        }
        if (!"google.protobuf.Any".equals(fqnKey = JavaToProtobufGenerator.fqnifyClass(rtKey, "___"))) {
            classnameMap.put(rtKey.describe(), fqnKey);
            pendingTypes.add((ResolvedType)rtKey.asReferenceType());
        }
        Pair<ResolvedTypeParameterDeclaration, ResolvedType> pairValue = JavaToProtobufGenerator.getParameterType(resolvedType, 1);
        ResolvedType rtValue = (ResolvedType)pairValue.b;
        if (rtValue.isReference()) {
            rtValue = JavaToProtobufGenerator.objectify(rtValue.asReferenceType());
        }
        if (!"google.protobuf.Any".equals(fqnValue = JavaToProtobufGenerator.fqnifyClass(rtValue, "___"))) {
            classnameMap.put(rtValue.describe(), fqnValue);
            pendingTypes.add((ResolvedType)rtValue.asReferenceType());
        }
        sb.append("  //").append(rtKey.describe()).append("->").append(rtValue.describe()).append(LS);
        sb.append("  message Pair {" + LS).append("    ").append(fqnKey).append(" key = ").append(counter++).append(";" + LS).append("    ").append(fqnValue).append(" value = ").append(counter++).append(";" + LS).append("  }" + LS).append("  repeated Pair data = ").append(counter++).append(";" + LS);
    }

    private static String visitArray(ResolvedType rt) {
        try {
            ResolvedArrayType rat = (ResolvedArrayType)rt;
            ResolvedType ct = rat.getComponentType();
            String type = null;
            String fqn = null;
            if ("java.lang.Object".equals(ct.describe())) {
                return "repeated google.protobuf.Any";
            }
            if (PRIMITIVE_ARRAY_TYPE.containsKey(ct.describe())) {
                type = PRIMITIVE_ARRAY_TYPE.get(ct.describe());
            } else if (JAVA_WRAPPER_TO_WARRAY_MAP.keySet().contains(ct.describe())) {
                type = JAVA_WRAPPER_TO_WARRAY_MAP.get(ct.describe());
            } else if (ct instanceof ResolvedArrayType) {
                type = "dev_resteasy_grpc_arrays___ArrayHolder___WArray";
                if (ct.isReferenceType()) {
                    pendingTypes.add(JavaToProtobufGenerator.objectify(rat.asReferenceType()));
                    ResolvedType bat = JavaToProtobufGenerator.getBasicArrayType((ResolvedArrayType)ct);
                    fqn = bat.asReferenceType().getQualifiedName();
                    if (!visited.contains(fqn)) {
                        pendingTypes.add(JavaToProtobufGenerator.objectify(bat.asReferenceType()));
                    }
                    if ((bat = bat.asArrayType().getComponentType()).isReference() && !visited.contains(fqn = bat.asReferenceType().getQualifiedName())) {
                        pendingTypes.add(JavaToProtobufGenerator.objectify(bat.asReferenceType()));
                    }
                }
            } else {
                if (rt.isReferenceType()) {
                    pendingTypes.add(JavaToProtobufGenerator.objectify(rt.asReferenceType()));
                } else if (rt.isArray()) {
                    pendingTypes.add((ResolvedType)JavaToProtobufGenerator.objectify(rt.asArrayType()));
                } else {
                    pendingTypes.add(rt);
                }
                if (!ct.isReferenceType()) {
                    return null;
                }
                fqn = JavaToProtobufGenerator.removeTypeVariables(ct.describe());
                if (JAVA_BUILTIN_TO_PROTOBUF_FIELD.containsKey(fqn)) {
                    type = JavaToProtobufGenerator.wrapRepeated(JAVA_BUILTIN_TO_PROTOBUF_FIELD.get(fqn));
                } else if (!visited.contains(fqn)) {
                    pendingTypes.add(JavaToProtobufGenerator.objectify(ct.asReferenceType()));
                }
                type = JavaToProtobufGenerator.wrapRepeated(JavaToProtobufGenerator.fqnifyClass(fqn, JavaToProtobufGenerator.isInnerClass((ResolvedReferenceTypeDeclaration)ct.asReferenceType().getTypeDeclaration().get())));
            }
            return type;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String visitReferenceType(ResolvedType rt) {
        pendingTypes.add(rt);
        List pairs = rt.asReferenceType().getTypeParametersMap();
        ListIterator it = pairs.listIterator();
        while (it.hasNext()) {
            Pair pair = (Pair)it.next();
            if (!((ResolvedType)pair.b).isReferenceType()) continue;
            pendingTypes.add(JavaToProtobufGenerator.objectify(((ResolvedType)pair.b).asReferenceType()));
        }
        String innerClass = JavaToProtobufGenerator.isInnerClass((ResolvedReferenceTypeDeclaration)rt.asReferenceType().getTypeDeclaration().get());
        String fqn = JavaToProtobufGenerator.fqnifyClass(rt, innerClass);
        classnameMap.put(rt.describe(), fqn);
        return fqn;
    }

    private static void visitField(ResolvedReferenceType clazz, ResolvedType rt, String fieldName, StringBuilder sb, Set<String> fieldNames) {
        String type = null;
        if ("$assertionsDisabled".equals(rt.describe())) {
            return;
        }
        if (rt.describe() != null && rt.describe().startsWith("this$")) {
            return;
        }
        if (rt.describe().contains("safe")) {
            return;
        }
        if (JAVA_PRIMITIVE_TO_PROTOBUF_MAP.containsKey(rt.describe())) {
            type = JAVA_PRIMITIVE_TO_PROTOBUF_MAP.get(rt.describe());
        } else if (JAVA_BUILTIN_TO_PROTOBUF_FIELD.containsKey(rt.describe())) {
            type = JAVA_BUILTIN_TO_PROTOBUF_FIELD.get(rt.describe());
        } else if (rt instanceof ResolvedArrayType) {
            type = JavaToProtobufGenerator.visitArray(rt);
            if (type == null) {
                return;
            }
        } else if (rt.isReferenceType()) {
            ResolvedType objectifiedField = JavaToProtobufGenerator.objectify(rt.asReferenceType());
            type = JavaToProtobufGenerator.visitReferenceType(objectifiedField);
            if (JavaToProtobufGenerator.isSetOrList(rt.asReferenceType())) {
                sb.append("  //").append(objectifiedField.describe()).append(LS);
            }
        } else if (rt.isTypeVariable()) {
            Optional opt = clazz.getGenericParameterByName(rt.asTypeVariable().describe());
            if (opt.isPresent()) {
                type = ((ResolvedType)opt.get()).isReferenceType() ? JavaToProtobufGenerator.fqnifyClass((ResolvedType)opt.get(), "___") : (((ResolvedType)opt.get()).isArray() ? JavaToProtobufGenerator.visitArray((ResolvedType)opt.get()) : "google.protobuf.Any");
            } else {
                type = "google.protobuf.Any";
                return;
            }
        }
        if (type != null) {
            sb.append("  ").append(type).append(" ").append(JavaToProtobufGenerator.getFieldName(fieldNames, fieldName)).append(" = ").append(counter++).append(";" + LS);
        }
    }

    private static String getEntityParameter(MethodDeclaration md, String httpMethod) {
        if ("LOCATOR".equals(httpMethod)) {
            return "google.protobuf.Any";
        }
        String protoClass = args[1] + "." + args[3] + "_proto$";
        for (Parameter p : md.getParameters()) {
            if (!JavaToProtobufGenerator.isEntity(p)) continue;
            ResolvedType rt = p.getType().resolve();
            if (rt.isReferenceType()) {
                rt = JavaToProtobufGenerator.objectify(rt.asReferenceType());
            }
            String javaType = rt.describe();
            String rawType = p.getTypeAsString();
            if (JAVA_BUILTIN_TO_PROTOBOF_IO.containsKey(rawType)) {
                entityTypesForFile.add(JavaToProtobufGenerator.despace(javaType) + " " + JavaToProtobufGenerator.despace(protoClass) + JAVA_BUILTIN_TO_PROTOBOF_IO.get(rawType));
                return JAVA_BUILTIN_TO_PROTOBOF_IO.get(rawType);
            }
            if (JAVA_PRIMITIVE_TO_PROTOBUF_MAP.containsKey(rawType)) {
                entityTypesForFile.add(JavaToProtobufGenerator.despace(javaType) + " " + JavaToProtobufGenerator.despace(JAVA_PRIMITIVE_TO_PROTOBUF_MAP.get(rawType)));
                return JAVA_PRIMITIVE_TO_PROTOBUF_MAP.get(rawType);
            }
            if (rt.isArray()) {
                if ("Object".equals(rt.asArrayType().getComponentType().describe()) || "java.lang.Object".equals(rt.asArrayType().getComponentType().describe())) {
                    repeatedTypes.add("dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Any___WArray");
                    entityTypesForFile.add("java.lang.Object[] dev.resteasy.grpc.arrays.Array_proto$dev_resteasy_grpc_arrays___Any___WArray");
                    return "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Any___WArray";
                }
                if (JAVA_BUILTIN_TO_PROTOBUF_ARRAYS.containsKey(rt.asArrayType().getComponentType().describe())) {
                    entityTypesForFile.add(JavaToProtobufGenerator.despace(javaType) + " " + JavaToProtobufGenerator.despace(JAVA_COMPONENT_TYPE_TO_ARRAY_PROTO_TYPE.get(rt.asArrayType().getComponentType().describe())));
                    return JAVA_BUILTIN_TO_PROTOBUF_ARRAYS.get(rt.asArrayType().getComponentType().describe());
                }
                if (rt.asArrayType().getComponentType().arrayLevel() == 0) {
                    Object name = rt.describe().substring(0, rt.describe().indexOf("["));
                    if (JAVA_WRAPPER_TO_WARRAY_MAP.containsKey(name)) {
                        name = JAVA_WRAPPER_TO_WARRAY_MAP.get(name);
                    } else {
                        name = JavaToProtobufGenerator.fqnifyClass((String)name, JavaToProtobufGenerator.isInnerClass((ResolvedReferenceTypeDeclaration)rt.asArrayType().getComponentType().asReferenceType().getTypeDeclaration().get()));
                        name = (String)name + "___WArray";
                    }
                    repeatedTypes.add((String)name);
                    entityTypesForFile.add(JavaToProtobufGenerator.despace(javaType) + " " + protoClass + JavaToProtobufGenerator.despace((String)name));
                    return name;
                }
                entityTypesForFile.add(JavaToProtobufGenerator.despace(javaType) + " " + protoClass + "dev_resteasy_grpc_arrays___ArrayHolder___WArray");
                return "dev_resteasy_grpc_arrays___ArrayHolder___WArray";
            }
            if (JavaToProtobufGenerator.isInterface(rt)) {
                return "google.protobuf.Any";
            }
            pendingTypes.add(rt);
            String s = JavaToProtobufGenerator.fqnifyClass(rt, JavaToProtobufGenerator.isInnerClass((ResolvedReferenceTypeDeclaration)rt.asReferenceType().getTypeDeclaration().get()));
            String javabufType = protoClass + s;
            entityTypesForFile.add(JavaToProtobufGenerator.despace(javaType) + " " + javabufType);
            return s;
        }
        needEmpty = true;
        return "gEmpty";
    }

    private static boolean isInterface(ResolvedType rt) {
        Optional opt = rt.asReferenceType().getTypeDeclaration();
        if (opt.isPresent()) {
            return ((ResolvedReferenceTypeDeclaration)opt.get()).isInterface();
        }
        return false;
    }

    private static boolean isEntity(Parameter p) {
        for (AnnotationExpr ae : p.getAnnotations()) {
            if (!ANNOTATIONS.contains(ae.getNameAsString())) continue;
            return false;
        }
        String name = p.getTypeAsString();
        return !AsyncResponse.class.getName().equals(name) && !AsyncResponse.class.getSimpleName().equals(name);
    }

    private static String getReturnType(MethodDeclaration md, String httpMethod) {
        if (JavaToProtobufGenerator.isSuspended(md) || "LOCATOR".equals(httpMethod)) {
            return "google.protobuf.Any";
        }
        if (JavaToProtobufGenerator.isSSE(md)) {
            return SSE_EVENT_CLASSNAME;
        }
        for (Node node : md.getChildNodes()) {
            if (!(node instanceof Type) || ((Type)node).isTypeParameter()) continue;
            if (node instanceof VoidType) {
                return "google.protobuf.Empty";
            }
            String rawType = ((Type)node).asString();
            int open = rawType.indexOf("<");
            int close = rawType.indexOf(">");
            if (open >= 0 && close > open) {
                String type = rawType.substring(0, open);
                String parameterType = rawType.substring(open + 1, close);
                rawType = CompletionStage.class.getCanonicalName().contentEquals(type) || CompletionStage.class.getSimpleName().contentEquals(type) ? parameterType : type;
            }
            if (JAVA_BUILTIN_TO_PROTOBOF_IO.containsKey(rawType)) {
                return JAVA_BUILTIN_TO_PROTOBOF_IO.get(rawType);
            }
            if (JAVA_PRIMITIVE_TO_PROTOBUF_MAP.containsKey(rawType)) {
                return JAVA_PRIMITIVE_TO_PROTOBUF_MAP.get(rawType);
            }
            if ("jakarta.ws.rs.core.Response".equals(rawType) || "Response".equals(rawType)) {
                return "google.protobuf.Any";
            }
            ResolvedType rt = ((Type)node).resolve();
            if (rt.isArray()) {
                if ("Object".equals(rt.asArrayType().getComponentType().describe()) || "java.lang.Object".equals(rt.asArrayType().getComponentType().describe())) {
                    repeatedTypes.add("dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Any___WArray");
                    entityTypesForFile.add("java.lang.Object[] dev.resteasy.grpc.arrays.Array_proto$dev_resteasy_grpc_arrays___Any___WArray");
                    return "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Any___WArray";
                }
                if (JAVA_BUILTIN_TO_PROTOBUF_ARRAYS.containsKey(rt.asArrayType().getComponentType().describe())) {
                    return JAVA_BUILTIN_TO_PROTOBUF_ARRAYS.get(rt.asArrayType().getComponentType().describe());
                }
                if (rt.asArrayType().getComponentType().arrayLevel() == 0) {
                    Object name = rt.describe().substring(0, rt.describe().indexOf("["));
                    if (JAVA_WRAPPER_TO_WARRAY_MAP.containsKey(name)) {
                        name = JAVA_WRAPPER_TO_WARRAY_MAP.get(name);
                    } else {
                        name = JavaToProtobufGenerator.fqnifyClass((String)name, JavaToProtobufGenerator.isInnerClass((ResolvedReferenceTypeDeclaration)rt.asArrayType().getComponentType().asReferenceType().getTypeDeclaration().get()));
                        name = (String)name + "___WArray";
                    }
                    repeatedTypes.add((String)name);
                    return name;
                }
                return "dev_resteasy_grpc_arrays___ArrayHolder___WArray";
            }
            if (JavaToProtobufGenerator.isInterface(rt)) {
                return "google.protobuf.Any";
            }
            rt = JavaToProtobufGenerator.objectify(rt.asReferenceType());
            pendingTypes.add(rt);
            return JavaToProtobufGenerator.fqnifyClass(rt, JavaToProtobufGenerator.isInnerClass((ResolvedReferenceTypeDeclaration)rt.asReferenceType().getTypeDeclaration().get()));
        }
        needEmpty = true;
        return "gEmpty";
    }

    private static boolean isSuspended(MethodDeclaration md) {
        for (Parameter p : md.getParameters()) {
            for (AnnotationExpr ae : p.getAnnotations()) {
                if (!"Suspended".equals(ae.getNameAsString())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCompletionStage(MethodDeclaration md) {
        for (Node node : md.getChildNodes()) {
            if (!(node instanceof Type)) continue;
            String rawType = ((Type)node).asString();
            int open = rawType.indexOf("<");
            int close = rawType.indexOf(">");
            if (open < 0 || close <= open) continue;
            String type = rawType.substring(0, open);
            if (!CompletionStage.class.getCanonicalName().contentEquals(type) && !CompletionStage.class.getSimpleName().contentEquals(type)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSSE(MethodDeclaration md) {
        Optional opt = md.getAnnotationByName("Produces");
        if (opt.isEmpty()) {
            return false;
        }
        AnnotationExpr ae = (AnnotationExpr)opt.get();
        List list1 = ae.findAll(StringLiteralExpr.class);
        for (StringLiteralExpr sle : list1) {
            if (!"text/event-stream".equals(sle.getValue())) continue;
            isSSE = true;
            return true;
        }
        List list2 = ae.findAll(FieldAccessExpr.class);
        for (FieldAccessExpr fae : list2) {
            List list3 = fae.getChildNodes();
            if (list3.size() < 2 || !(list3.get(0) instanceof NameExpr) || !(list3.get(1) instanceof SimpleName)) continue;
            NameExpr ne = (NameExpr)list3.get(0);
            SimpleName sn = (SimpleName)list3.get(1);
            if (!"MediaType".equals(ne.getName().asString()) || !"SERVER_SENT_EVENTS".equals(sn.asString())) continue;
            isSSE = true;
            return true;
        }
        return false;
    }

    private static boolean isResourceOrLocatorMethod(MethodDeclaration md) {
        for (AnnotationExpr ae : md.getAnnotations()) {
            if (!HTTP_VERBS.contains(ae.getNameAsString().toUpperCase()) && !"Path".equals(ae.getNameAsString())) continue;
            return true;
        }
        return false;
    }

    private static String removeTypeVariables(String classType) {
        int left = classType.indexOf(60);
        if (left < 0) {
            return classType;
        }
        return classType.substring(0, left);
    }

    private static boolean isSetOrList(ResolvedReferenceType clazz) {
        if ("java.util.List".equals(clazz.getQualifiedName()) || "java.util.Set".equals(clazz.getQualifiedName())) {
            return true;
        }
        for (ResolvedReferenceType rrt : clazz.getAllInterfacesAncestors()) {
            if (!"java.util.List".equals(rrt.getQualifiedName()) && !"java.util.Set".equals(rrt.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isSet(ResolvedReferenceType clazz) {
        if ("java.util.Set".equals(clazz.getQualifiedName())) {
            return true;
        }
        for (ResolvedReferenceType rrt : clazz.getAllInterfacesAncestors()) {
            if (!"java.util.Set".equals(rrt.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isList(ResolvedReferenceType clazz) {
        if ("java.util.List".equals(clazz.getQualifiedName())) {
            return true;
        }
        for (ResolvedReferenceType rrt : clazz.getAllInterfacesAncestors()) {
            if (!"java.util.List".equals(rrt.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isMultiMap(ResolvedReferenceType clazz) {
        if ("jakarta.ws.rs.core.MultivaluedMap".equals(clazz.getQualifiedName())) {
            return true;
        }
        for (ResolvedReferenceType rrt : clazz.getAllInterfacesAncestors()) {
            if (!"jakarta.ws.rs.core.MultivaluedMap".equals(rrt.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isMap(ResolvedReferenceType clazz) {
        if ("java.util.Map".equals(clazz.getQualifiedName())) {
            return true;
        }
        for (ResolvedReferenceType rrt : clazz.getAllInterfacesAncestors()) {
            if (!"java.util.Map".equals(rrt.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private static String isInnerClass(ResolvedReferenceTypeDeclaration clazz) {
        try {
            String s = clazz.getQualifiedName().substring(clazz.getPackageName().length() + 1);
            if (!s.contains(".") && !s.contains("$")) {
                return "___";
            }
            if (AccessSpecifier.PUBLIC.equals((Object)clazz.asClass().accessSpecifier())) {
                return "_INNER_";
            }
            return "_HIDDEN_";
        }
        catch (Exception e) {
            return "___";
        }
    }

    private static String fqnifyClass(ResolvedType rt, String separator) {
        if (rt.isTypeVariable() || rt.isWildcard() || "java.lang.Object".equals(rt.describe())) {
            return "google.protobuf.Any";
        }
        if (JAVA_BUILTIN_TO_PROTOBUF_FIELD.containsKey(rt.describe())) {
            return JAVA_BUILTIN_TO_PROTOBUF_FIELD.get(rt.describe());
        }
        if (classnameMap.containsKey(rt.describe())) {
            return classnameMap.get(rt.describe());
        }
        String fqn = JavaToProtobufGenerator.fqnifyClass(JavaToProtobufGenerator.objectify(rt.asReferenceType()).describe(), separator);
        classnameMap.put(rt.describe(), fqn);
        return fqn;
    }

    private static String fqnifyClass(String s, String separator) {
        if ("?".equals(s)) {
            return "google.protobuf.Any";
        }
        int l = (s = JavaToProtobufGenerator.disambiguateClasses(s)).lastIndexOf(".");
        if (l < 0) {
            return s;
        }
        String sPackage = s.substring(0, l).replace(".", "_");
        String className = s.substring(l + 1);
        return sPackage + separator + className;
    }

    private static String disambiguateClasses(String classname) {
        if (classname.contains("<")) {
            if (classnames.containsKey(classname)) {
                return classnames.get(classname);
            }
            String strippedClassName = JavaToProtobufGenerator.stripTypeVariables(classname);
            String newName = strippedClassName + classnameCounter.getAndIncrement();
            classnames.put(classname, newName);
            return newName;
        }
        return classname;
    }

    private static String stripTypeVariables(String classname) {
        if (!classname.contains("<")) {
            return classname;
        }
        return classname.substring(0, classname.indexOf("<"));
    }

    private static String namify(String s) {
        return s.replace(".", "_");
    }

    private static Pair<ResolvedTypeParameterDeclaration, ResolvedType> getParameterType(ResolvedType resolvedType) {
        return JavaToProtobufGenerator.getParameterType(resolvedType, 0);
    }

    private static Pair<ResolvedTypeParameterDeclaration, ResolvedType> getParameterType(ResolvedType resolvedType, int pos) {
        List lt = resolvedType.asReferenceType().getTypeParametersMap();
        if (lt.size() < pos + 1) {
            ResolvedReferenceType rrt;
            Iterator iterator = resolvedType.asReferenceType().getAllAncestors().iterator();
            while (iterator.hasNext() && (lt = (rrt = (ResolvedReferenceType)iterator.next()).asReferenceType().getTypeParametersMap()).size() <= pos) {
            }
        }
        if (lt.size() < pos + 1) {
            return new Pair((Object)TV[pos], (Object)objectType);
        }
        Pair pair = (Pair)lt.get(pos);
        if (((ResolvedType)pair.b).isTypeVariable()) {
            return new Pair((Object)((ResolvedTypeParameterDeclaration)pair.a), (Object)objectType);
        }
        return (Pair)lt.get(pos);
    }

    private static String getHttpMethod(MethodDeclaration md) {
        if (!md.getAnnotationByName("DELETE").isEmpty()) {
            return "DELETE";
        }
        if (!md.getAnnotationByName("GET").isEmpty()) {
            return "GET";
        }
        if (!md.getAnnotationByName("HEAD").isEmpty()) {
            return "HEAD";
        }
        if (!md.getAnnotationByName("OPTIONS").isEmpty()) {
            return "OPTIONS";
        }
        if (!md.getAnnotationByName("PATCH").isEmpty()) {
            return "PATCH";
        }
        if (!md.getAnnotationByName("POST").isEmpty()) {
            return "POST";
        }
        if (!md.getAnnotationByName("PUT").isEmpty()) {
            return "PUT";
        }
        return "LOCATOR";
    }

    private static ResolvedType getBasicArrayType(ResolvedArrayType rat) {
        if (rat.arrayLevel() > 2) {
            return JavaToProtobufGenerator.getBasicArrayType((ResolvedArrayType)rat.getComponentType());
        }
        return rat.getComponentType();
    }

    private static String getRpcName(Set<String> rpcNames, String proposedName) {
        String name = proposedName.substring(0, 1).toLowerCase() + proposedName.substring(1);
        int counter = 1;
        while (rpcNames.contains(name.toLowerCase())) {
            name = proposedName + "___" + counter++;
        }
        rpcNames.add(name.toLowerCase());
        return name;
    }

    private static String getFieldName(Set<String> fieldNames, String proposedName) {
        Object name = proposedName;
        int counter = 1;
        while (fieldNames.contains(((String)name).toLowerCase())) {
            name = proposedName + "___" + counter++;
        }
        fieldNames.add(((String)name).toLowerCase());
        return name;
    }

    private static ResolvedType getSuperClass(ResolvedReferenceType clazz) {
        if (clazz.getAllAncestors().size() == 0) {
            return null;
        }
        return (ResolvedType)clazz.getAllAncestors().get(0);
    }

    private static String wrapRepeated(String type) {
        if (PROTUBUF_PRIMITIVE_TO_ARRAY_MAP.containsKey(type)) {
            type = PROTUBUF_PRIMITIVE_TO_ARRAY_MAP.get(type);
        } else {
            type = (String)type + "___WArray";
            repeatedTypes.add((String)type);
        }
        return type;
    }

    static final boolean hasInterfaceType(FieldDeclaration f) {
        return f.resolve().declaringType().isInterface();
    }

    static final String despace(String s) {
        return s.replace(" ", "");
    }

    static {
        needEmpty = false;
        needList = true;
        needSet = true;
        needArrayList = true;
        needHashSet = true;
        needMap = true;
        needHashMap = true;
        needMultiMap = true;
        needMultiHashMap = true;
        pendingTypes = ConcurrentHashMap.newKeySet();
        entityMessageTypes = new HashSet<String>();
        returnMessageTypes = new HashSet<String>();
        nonGenericClasses = new HashSet<String>();
        visited = new HashSet<String>();
        classVisitor = new ClassVisitor();
        jakartaRESTResourceVisitor = new JakartaRESTResourceVisitor();
        started = false;
        counter = 1;
        repeatedTypes = new TreeSet<String>();
        normalizer = new HashMap<String, String>();
        entityTypesForFile = new HashSet<String>();
        classnameCounter = new AtomicInteger();
        classnames = new ConcurrentHashMap<String, String>();
        rpcNames = new HashSet<String>();
        classnameMap = new ConcurrentHashMap<String, String>();
        objectifiedTypes = new ConcurrentHashMap<ResolvedReferenceType, ResolvedReferenceType>();
        recordMap = new HashMap<String, RecordDeclaration>();
        TV = new ReflectionTypeParameter[10];
        arrayDef = "///////////////%nmessage %1$s {%n   repeated %2$s___wrapper wrapper___field = 1;%n}%n%nmessage %2$s___wrapper {%n   oneof type {%n      dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___NONE none_field = 1;%n      %2$s %2$s_field = 2;%n   }%n}%n%n";
        arrayHolderDef = "///////////////%nmessage dev_resteasy_grpc_arrays___ArrayHolder___wrapper {%n   oneof type {%n      dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___NONE none_field = 1;%n      dev_resteasy_grpc_arrays___ArrayHolder dev_resteasy_grpc_arrays___ArrayHolder_field = 2;%n   }%n}%n%nmessage dev_resteasy_grpc_arrays___ArrayHolder___WArray {%n   string componentType = 1;%n   repeated dev_resteasy_grpc_arrays___ArrayHolder___wrapper wrapper___field = 2;%n}%n%n";
        LIST_DEF = "// List: java.util.List<java.lang.Object>%nmessage java_util___List {%n  string classname = 1;%n  //java.lang.Object%n  repeated google.protobuf.Any data = 2;%n}%n%n";
        SET_DEF = "// Set: java.util.Set<java.lang.Object>%nmessage java_util___Set {%n  string classname = 1;%n  //java.lang.Object%n  repeated google.protobuf.Any data = 2;%n}%n%n";
        MAP_DEF = "// Map: java.util.Map<java.lang.Object, java.lang.Object>%nmessage java_util___Map {%n  string classname = 1;%n  //java.lang.Object->java.lang.Object%n  message Pair {%n    google.protobuf.Any key = 2;%n    google.protobuf.Any value = 3;%n  }%n  repeated Pair data = 4;%n}%n%n";
        MULTIMAP_DEF = "// Multimap: jakarta.ws.rs.core.MultivaluedMap<java.lang.Object, java.lang.Object>%nmessage jakarta_ws_rs_core___MultivaluedMap {%n  string classname = 1;%n  //java.lang.Object->java.lang.Object%n  message Pair {%n    google.protobuf.Any key = 2;%n    google.protobuf.Any value = 3;%n  }%n  repeated Pair data = 4;%n}%n%n";
        ARRAYLIST_DEF = "// List: java.util.ArrayList<java.lang.Object>%nmessage java_util___ArrayList {%n  string classname = 1;%n  //java.lang.Object%n  repeated google.protobuf.Any data = 2;%n}%n%n";
        HASHSET_DEF = "// Set: java.util.HashSet<java.lang.Object>%nmessage java_util___HashSet {%n  string classname = 1;%n  //java.lang.Object%n  repeated google.protobuf.Any data = 2;%n}%n%n";
        HASHMAP_DEF = "// Map: java.util.MashMap<java.lang.Object, java.lang.Object>%nmessage java_util___HashMap {%n  string classname = 1;%n  //java.lang.Object->java.lang.Object%n  message Pair {%n    google.protobuf.Any key = 2;%n    google.protobuf.Any value = 3;%n  }%n  repeated Pair data = 4;%n}%n%n";
        MULTIMAP_IMPL_DEF = "// Multimap: jakarta.ws.rs.core.MultivaluedHashMap<java.lang.Object, java.lang.Object>%nmessage jakarta_ws_rs_core___MultivaluedHashMap {%n  string classname = 1;%n  //java.lang.Object->java.lang.Object%n  message Pair {%n    google.protobuf.Any key = 2;%n    google.protobuf.Any value = 3;%n  }%n  repeated Pair data = 4;%n}%n%n";
        JAVA_PRIMITIVE_TO_PROTOBUF_MAP.put("boolean", "bool");
        JAVA_PRIMITIVE_TO_PROTOBUF_MAP.put("byte", "int32");
        JAVA_PRIMITIVE_TO_PROTOBUF_MAP.put("short", "int32");
        JAVA_PRIMITIVE_TO_PROTOBUF_MAP.put("int", "int32");
        JAVA_PRIMITIVE_TO_PROTOBUF_MAP.put("long", "int64");
        JAVA_PRIMITIVE_TO_PROTOBUF_MAP.put("float", "float");
        JAVA_PRIMITIVE_TO_PROTOBUF_MAP.put("double", "double");
        JAVA_PRIMITIVE_TO_PROTOBUF_MAP.put("char", "string");
        JAVA_PRIMITIVE_TO_PROTOBUF_MAP.put("String", "string");
        JAVA_PRIMITIVE_TO_PROTOBUF_MAP.put("java.lang.String", "string");
        PROTUBUF_PRIMITIVE_TO_ARRAY_MAP.put("bool", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Boolean___Array");
        PROTUBUF_PRIMITIVE_TO_ARRAY_MAP.put("bytes", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Byte___Array");
        PROTUBUF_PRIMITIVE_TO_ARRAY_MAP.put("int32", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Integer___Array");
        PROTUBUF_PRIMITIVE_TO_ARRAY_MAP.put("int64", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Long___Array");
        PROTUBUF_PRIMITIVE_TO_ARRAY_MAP.put("float", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Float___Array");
        PROTUBUF_PRIMITIVE_TO_ARRAY_MAP.put("double", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Double___Array");
        PROTUBUF_PRIMITIVE_TO_ARRAY_MAP.put("char", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Character___Array");
        PROTUBUF_PRIMITIVE_TO_ARRAY_MAP.put("string", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___String___WArray");
        JAVA_WRAPPER_TO_WARRAY_MAP.put("java.lang.Boolean", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Boolean___WArray");
        JAVA_WRAPPER_TO_WARRAY_MAP.put("java.lang.Byte", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Byte___WArray");
        JAVA_WRAPPER_TO_WARRAY_MAP.put("java.lang.Short", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Short___WArray");
        JAVA_WRAPPER_TO_WARRAY_MAP.put("java.lang.Integer", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Integer___WArray");
        JAVA_WRAPPER_TO_WARRAY_MAP.put("java.lang.Long", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Long___WArray");
        JAVA_WRAPPER_TO_WARRAY_MAP.put("java.lang.Float", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Float___WArray");
        JAVA_WRAPPER_TO_WARRAY_MAP.put("java.lang.Double", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Double___WArray");
        JAVA_WRAPPER_TO_WARRAY_MAP.put("java.lang.Character", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Character___WArray");
        JAVA_WRAPPER_TO_WARRAY_MAP.put("java.lang.String", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___String___WArray");
        JAVA_BUILTIN_TO_PROTOBOF_IO.put("boolean", "gBoolean");
        JAVA_BUILTIN_TO_PROTOBOF_IO.put("Boolean", "gBoolean");
        JAVA_BUILTIN_TO_PROTOBOF_IO.put("java.lang.Boolean", "gBoolean");
        JAVA_BUILTIN_TO_PROTOBOF_IO.put("byte", "gByte");
        JAVA_BUILTIN_TO_PROTOBOF_IO.put("Byte", "gByte");
        JAVA_BUILTIN_TO_PROTOBOF_IO.put("java.lang.Byte", "gByte");
        JAVA_BUILTIN_TO_PROTOBOF_IO.put("short", "gShort");
        JAVA_BUILTIN_TO_PROTOBOF_IO.put("Short", "gShort");
        JAVA_BUILTIN_TO_PROTOBOF_IO.put("java.lang.Short", "gShort");
        JAVA_BUILTIN_TO_PROTOBOF_IO.put("int", "gInteger");
        JAVA_BUILTIN_TO_PROTOBOF_IO.put("Integer", "gInteger");
        JAVA_BUILTIN_TO_PROTOBOF_IO.put("java.lang.Integer", "gInteger");
        JAVA_BUILTIN_TO_PROTOBOF_IO.put("long", "gLong");
        JAVA_BUILTIN_TO_PROTOBOF_IO.put("Long", "gLong");
        JAVA_BUILTIN_TO_PROTOBOF_IO.put("java.lang.Long", "gLong");
        JAVA_BUILTIN_TO_PROTOBOF_IO.put("float", "gFloat");
        JAVA_BUILTIN_TO_PROTOBOF_IO.put("Float", "gFloat");
        JAVA_BUILTIN_TO_PROTOBOF_IO.put("java.lang.Float", "gFloat");
        JAVA_BUILTIN_TO_PROTOBOF_IO.put("double", "gDouble");
        JAVA_BUILTIN_TO_PROTOBOF_IO.put("Double", "gDouble");
        JAVA_BUILTIN_TO_PROTOBOF_IO.put("java.lang.Double", "gDouble");
        JAVA_BUILTIN_TO_PROTOBOF_IO.put("char", "gCharacter");
        JAVA_BUILTIN_TO_PROTOBOF_IO.put("Character", "gCharacter");
        JAVA_BUILTIN_TO_PROTOBOF_IO.put("java.lang.Character", "gCharacter");
        JAVA_BUILTIN_TO_PROTOBOF_IO.put("string", "gString");
        JAVA_BUILTIN_TO_PROTOBOF_IO.put("String", "gString");
        JAVA_BUILTIN_TO_PROTOBOF_IO.put("java.lang.String", "gString");
        JAVA_BUILTIN_TO_PROTOBUF_FIELD.put("Boolean", "bool");
        JAVA_BUILTIN_TO_PROTOBUF_FIELD.put("Byte", "int32");
        JAVA_BUILTIN_TO_PROTOBUF_FIELD.put("Short", "int32");
        JAVA_BUILTIN_TO_PROTOBUF_FIELD.put("Integer", "int32");
        JAVA_BUILTIN_TO_PROTOBUF_FIELD.put("Long", "int64");
        JAVA_BUILTIN_TO_PROTOBUF_FIELD.put("Float", "float");
        JAVA_BUILTIN_TO_PROTOBUF_FIELD.put("Double", "double");
        JAVA_BUILTIN_TO_PROTOBUF_FIELD.put("Character", "int32");
        JAVA_BUILTIN_TO_PROTOBUF_FIELD.put("String", "string");
        JAVA_BUILTIN_TO_PROTOBUF_FIELD.put("java.lang.Boolean", "bool");
        JAVA_BUILTIN_TO_PROTOBUF_FIELD.put("java.lang.Byte", "int32");
        JAVA_BUILTIN_TO_PROTOBUF_FIELD.put("java.lang.Short", "int32");
        JAVA_BUILTIN_TO_PROTOBUF_FIELD.put("java.lang.Integer", "int32");
        JAVA_BUILTIN_TO_PROTOBUF_FIELD.put("java.lang.Long", "int64");
        JAVA_BUILTIN_TO_PROTOBUF_FIELD.put("java.lang.Float", "float");
        JAVA_BUILTIN_TO_PROTOBUF_FIELD.put("java.lang.Double", "double");
        JAVA_BUILTIN_TO_PROTOBUF_FIELD.put("java.lang.Character", "int32");
        JAVA_BUILTIN_TO_PROTOBUF_FIELD.put("java.lang.String", "string");
        PRIMITIVE_WRAPPER_DEFINITIONS.put("Boolean", "message gBoolean   {bool   value = $V$;}");
        PRIMITIVE_WRAPPER_DEFINITIONS.put("Byte", "message gByte      {int32  value = $V$;}");
        PRIMITIVE_WRAPPER_DEFINITIONS.put("Short", "message gShort     {int32  value = $V$;}");
        PRIMITIVE_WRAPPER_DEFINITIONS.put("Integer", "message gInteger   {int32  value = $V$;}");
        PRIMITIVE_WRAPPER_DEFINITIONS.put("Long", "message gLong      {int64  value = $V$;}");
        PRIMITIVE_WRAPPER_DEFINITIONS.put("Float", "message gFloat     {float  value = $V$;}");
        PRIMITIVE_WRAPPER_DEFINITIONS.put("Double", "message gDouble    {double value = $V$;}");
        PRIMITIVE_WRAPPER_DEFINITIONS.put("Character", "message gCharacter {string value = $V$;}");
        PRIMITIVE_WRAPPER_DEFINITIONS.put("String", "message gString    {string value = $V$;}");
        JAVA_BUILTIN_TO_PROTOBUF_ARRAYS.put("none", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___NONE");
        JAVA_BUILTIN_TO_PROTOBUF_ARRAYS.put("boolean", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Boolean___Array");
        JAVA_BUILTIN_TO_PROTOBUF_ARRAYS.put("java.lang.Boolean", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Boolean___WArray");
        JAVA_BUILTIN_TO_PROTOBUF_ARRAYS.put("byte", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Byte___Array");
        JAVA_BUILTIN_TO_PROTOBUF_ARRAYS.put("java.lang.Byte", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Byte___WArray");
        JAVA_BUILTIN_TO_PROTOBUF_ARRAYS.put("short", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Short___Array");
        JAVA_BUILTIN_TO_PROTOBUF_ARRAYS.put("java.lang.Short", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Short___WArray");
        JAVA_BUILTIN_TO_PROTOBUF_ARRAYS.put("int", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Integer___Array");
        JAVA_BUILTIN_TO_PROTOBUF_ARRAYS.put("java.lang.Integer", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Integer___WArray");
        JAVA_BUILTIN_TO_PROTOBUF_ARRAYS.put("long", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Long___Array");
        JAVA_BUILTIN_TO_PROTOBUF_ARRAYS.put("java.lang.Long", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Long___WArray");
        JAVA_BUILTIN_TO_PROTOBUF_ARRAYS.put("float", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Float___Array");
        JAVA_BUILTIN_TO_PROTOBUF_ARRAYS.put("java.lang.Float", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Float___WArray");
        JAVA_BUILTIN_TO_PROTOBUF_ARRAYS.put("double", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Double___Array");
        JAVA_BUILTIN_TO_PROTOBUF_ARRAYS.put("java.lang.Double", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Double___WArray");
        JAVA_BUILTIN_TO_PROTOBUF_ARRAYS.put("char", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Character___Array");
        JAVA_BUILTIN_TO_PROTOBUF_ARRAYS.put("java.lang.Character", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Character___WArray");
        JAVA_BUILTIN_TO_PROTOBUF_ARRAYS.put("java.lang.String", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___String___WArray");
        JAVA_BUILTIN_TO_PROTOBUF_ARRAYS.put("arrayHolder", "dev_resteasy_grpc_arrays___ArrayHolder___WArray");
        JAVA_BUILTIN_TO_PROTOBUF_ARRAYS.put("Any", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Any___WArray");
        JAVA_BUILTIN_TO_PROTOBUF_ARRAYS.put("google.protobuf.Any", "dev.resteasy.grpc.arrays.dev_resteasy_grpc_arrays___Any___WArray");
        JAVA_COMPONENT_TYPE_TO_ARRAY_PROTO_TYPE.put("none", "dev.resteasy.grpc.arrays.Array_proto$dev_resteasy_grpc_arrays___NONE");
        JAVA_COMPONENT_TYPE_TO_ARRAY_PROTO_TYPE.put("boolean", "dev.resteasy.grpc.arrays.Array_proto$dev_resteasy_grpc_arrays___Boolean___Array");
        JAVA_COMPONENT_TYPE_TO_ARRAY_PROTO_TYPE.put("java.lang.Boolean", "dev.resteasy.grpc.arrays.Array_proto$dev_resteasy_grpc_arrays___Boolean___WArray");
        JAVA_COMPONENT_TYPE_TO_ARRAY_PROTO_TYPE.put("byte", "dev.resteasy.grpc.arrays.Array_proto$dev_resteasy_grpc_arrays___Byte___Array");
        JAVA_COMPONENT_TYPE_TO_ARRAY_PROTO_TYPE.put("java.lang.Byte", "dev.resteasy.grpc.arrays.Array_proto$dev_resteasy_grpc_arrays___Byte___WArray");
        JAVA_COMPONENT_TYPE_TO_ARRAY_PROTO_TYPE.put("short", "dev.resteasy.grpc.arrays.Array_proto$dev_resteasy_grpc_arrays___Short___Array");
        JAVA_COMPONENT_TYPE_TO_ARRAY_PROTO_TYPE.put("java.lang.Short", "dev.resteasy.grpc.arrays.Array_proto$dev_resteasy_grpc_arrays___Short___WArray");
        JAVA_COMPONENT_TYPE_TO_ARRAY_PROTO_TYPE.put("int", "dev.resteasy.grpc.arrays.Array_proto$dev_resteasy_grpc_arrays___Integer___Array");
        JAVA_COMPONENT_TYPE_TO_ARRAY_PROTO_TYPE.put("java.lang.Integer", "dev.resteasy.grpc.arrays.Array_proto$dev_resteasy_grpc_arrays___Integer___WArray");
        JAVA_COMPONENT_TYPE_TO_ARRAY_PROTO_TYPE.put("long", "dev.resteasy.grpc.arrays.Array_proto$dev_resteasy_grpc_arrays___Long___Array");
        JAVA_COMPONENT_TYPE_TO_ARRAY_PROTO_TYPE.put("java.lang.Long", "dev.resteasy.grpc.arrays.Array_proto$dev_resteasy_grpc_arrays___Long___WArray");
        JAVA_COMPONENT_TYPE_TO_ARRAY_PROTO_TYPE.put("float", "dev.resteasy.grpc.arrays.Array_proto$dev_resteasy_grpc_arrays___Float___Array");
        JAVA_COMPONENT_TYPE_TO_ARRAY_PROTO_TYPE.put("java.lang.Float", "dev.resteasy.grpc.arrays.Array_proto$dev_resteasy_grpc_arrays___Float___WArray");
        JAVA_COMPONENT_TYPE_TO_ARRAY_PROTO_TYPE.put("double", "dev.resteasy.grpc.arrays.Array_proto$dev_resteasy_grpc_arrays___Double___Array");
        JAVA_COMPONENT_TYPE_TO_ARRAY_PROTO_TYPE.put("java.lang.Double", "dev.resteasy.grpc.arrays.Array_proto$dev_resteasy_grpc_arrays___Double___WArray");
        JAVA_COMPONENT_TYPE_TO_ARRAY_PROTO_TYPE.put("char", "dev.resteasy.grpc.arrays.Array_proto$dev_resteasy_grpc_arrays___Character___Array");
        JAVA_COMPONENT_TYPE_TO_ARRAY_PROTO_TYPE.put("java.lang.Character", "dev.resteasy.grpc.arrays.Array_proto$dev_resteasy_grpc_arrays___Character___WArray");
        JAVA_COMPONENT_TYPE_TO_ARRAY_PROTO_TYPE.put("java.lang.String", "dev.resteasy.grpc.arrays.Array_proto$dev_resteasy_grpc_arrays___String___WArray");
        JAVA_COMPONENT_TYPE_TO_ARRAY_PROTO_TYPE.put("arrayHolder", "dev_resteasy_grpc_arrays___ArrayHolder___WArray");
        PRIMITIVE_ARRAY_TYPE.put("boolean", "repeated bool");
        PRIMITIVE_ARRAY_TYPE.put("byte", "bytes");
        PRIMITIVE_ARRAY_TYPE.put("short", "repeated int32");
        PRIMITIVE_ARRAY_TYPE.put("int", "repeated int32");
        PRIMITIVE_ARRAY_TYPE.put("long", "repeated int64");
        PRIMITIVE_ARRAY_TYPE.put("float", "repeated float");
        PRIMITIVE_ARRAY_TYPE.put("double", "repeated double");
        PRIMITIVE_ARRAY_TYPE.put("char", "string");
        ANNOTATIONS.add("Context");
        ANNOTATIONS.add("CookieParam");
        ANNOTATIONS.add("FormParam");
        ANNOTATIONS.add("HeaderParam");
        ANNOTATIONS.add("MatrixParam");
        ANNOTATIONS.add("PathParam");
        ANNOTATIONS.add("QueryParam");
        HTTP_VERBS.add("DELETE");
        HTTP_VERBS.add("HEAD");
        HTTP_VERBS.add("GET");
        HTTP_VERBS.add("OPTIONS");
        HTTP_VERBS.add("PATCH");
        HTTP_VERBS.add("POST");
        HTTP_VERBS.add("PUT");
        rcd = new ReflectionClassDeclaration(Object.class, (TypeSolver)combinedTypeSolver);
    }

    static class ClassVisitor
    extends VoidVisitorAdapter<StringBuilder> {
        ClassVisitor() {
        }

        public void visit(ResolvedType clazz, StringBuilder sb) {
            pendingTypes.remove(clazz);
            if (visited.contains(clazz.describe())) {
                return;
            }
            counter = 1;
            this.doVisit(clazz, sb, true);
            visited.add(clazz.describe());
        }

        public void visit(RecordDeclaration n, StringBuilder sb) {
            if (n.getFullyQualifiedName().isEmpty()) {
                return;
            }
            if (visited.contains(n.getFullyQualifiedName().get())) {
                return;
            }
            ReferenceTypeImpl rti = new ReferenceTypeImpl(n.resolve());
            if (nonGenericClasses.contains(rti.erasure().describe())) {
                JavaToProtobufGenerator.visitRecord(rti.erasure(), sb);
                visited.add(rti.erasure().describe());
            }
            ResolvedType rt = JavaToProtobufGenerator.objectify((ResolvedReferenceType)rti);
            JavaToProtobufGenerator.visitRecord(rt, sb);
            visited.add(rt.describe());
        }

        public void visit(ClassOrInterfaceDeclaration clazz, StringBuilder sb) {
            ResolvedType rt;
            if (clazz.getFullyQualifiedName().isPresent() && visited.contains(clazz.getFullyQualifiedName().get())) {
                return;
            }
            if (clazz.isInterface()) {
                return;
            }
            ResolvedReferenceTypeDeclaration rrtd = clazz.resolve();
            ReferenceTypeImpl rti = new ReferenceTypeImpl(rrtd);
            if (nonGenericClasses.contains(rti.erasure().describe())) {
                this.doVisit(rti.erasure(), sb, true);
                visited.add(rti.erasure().describe());
            }
            if (!(rt = JavaToProtobufGenerator.objectify(rti.asReferenceType())).describe().equals(rti.erasure().describe())) {
                this.doVisit(rt, sb, true);
                visited.add(rt.describe());
            }
        }

        private void doVisit(ResolvedType resolvedType, StringBuilder sb, boolean start) {
            ResolvedReferenceType clazz = resolvedType.asReferenceType();
            if (((ResolvedReferenceTypeDeclaration)clazz.getTypeDeclaration().get()).isRecord()) {
                JavaToProtobufGenerator.visitRecord(resolvedType, sb);
                return;
            }
            if (JAVA_BUILTIN_TO_PROTOBUF_FIELD.containsKey(clazz.describe())) {
                return;
            }
            if (Response.class.getName().equals(clazz.describe())) {
                return;
            }
            boolean isList = JavaToProtobufGenerator.isList(clazz);
            boolean isSet = JavaToProtobufGenerator.isSet(clazz);
            boolean isMultiMap = JavaToProtobufGenerator.isMultiMap(clazz);
            boolean isMap = JavaToProtobufGenerator.isMap(clazz);
            ResolvedType objectified = JavaToProtobufGenerator.objectify(clazz);
            if (isList) {
                sb.append(LS).append("// List: ").append(objectified.describe());
            } else if (isSet) {
                sb.append(LS).append("// Set: ").append(objectified.describe());
            } else if (isMultiMap) {
                sb.append(LS).append("// Multimap: ").append(objectified.describe());
            } else if (isMap) {
                sb.append(LS).append("// Map: ").append(objectified.describe());
            } else if ("java.lang.Object".equals(objectified.describe())) {
                return;
            }
            if (start) {
                String innerClass = JavaToProtobufGenerator.isInnerClass((ResolvedReferenceTypeDeclaration)resolvedType.asReferenceType().getTypeDeclaration().get());
                String javabufName = JavaToProtobufGenerator.fqnifyClass(objectified, innerClass);
                if (!(isList || isSet || isMap)) {
                    sb.append(LS).append("// Type: ").append(objectified.describe());
                }
                sb.append(LS + "message ").append(javabufName).append(" {" + LS);
                if ("java_util___List".equals(javabufName)) {
                    needList = false;
                } else if ("java_util___ArrayList".equals(javabufName)) {
                    needArrayList = false;
                } else if ("java_util___Set".equals(javabufName)) {
                    needSet = false;
                } else if ("java_util___HashSet".equals(javabufName)) {
                    needHashSet = false;
                } else if ("java_util___Map".equals(javabufName)) {
                    needMap = false;
                } else if ("java_util___HashMap".equals(javabufName)) {
                    needHashMap = false;
                } else if ("jakarta_ws_rs_core___MultivaluedMap".equals(javabufName)) {
                    needMultiMap = false;
                } else if ("jakarta_ws_rs_core___MultivaluedHashMap".equals(javabufName)) {
                    needMultiHashMap = false;
                }
            }
            HashSet<String> fieldNames = new HashSet<String>();
            if (isList || isSet) {
                sb.append("  string classname = ").append(counter++).append(";" + LS);
                JavaToProtobufGenerator.visitCollection(objectified, fieldNames, sb);
                if (start) {
                    sb.append("}" + LS);
                }
                return;
            }
            if (isMap) {
                sb.append("  string classname = ").append(counter++).append(";" + LS);
                JavaToProtobufGenerator.visitMap(objectified, sb);
                if (start) {
                    sb.append("}" + LS);
                }
                return;
            }
            if (isMultiMap) {
                sb.append("  string classname = ").append(counter++).append(";" + LS);
                JavaToProtobufGenerator.visitMap(objectified, sb);
                if (start) {
                    sb.append("}" + LS);
                }
                return;
            }
            ResolvedType superClass = JavaToProtobufGenerator.getSuperClass(clazz);
            if (superClass != null && !"java.lang.Object".equals(superClass.describe())) {
                this.doVisit(superClass, sb, false);
            }
            for (ResolvedFieldDeclaration rfd : clazz.getDeclaredFields()) {
                JavaToProtobufGenerator.visitField(clazz, rfd.getType(), rfd.asField().getName(), sb, fieldNames);
            }
            if (start) {
                sb.append("}" + LS);
            }
        }
    }

    class Dummy<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9> {
        Dummy() {
        }
    }

    static class JakartaRESTResourceVisitor
    extends VoidVisitorAdapter<StringBuilder> {
        JakartaRESTResourceVisitor() {
        }

        public void visit(RecordDeclaration n, StringBuilder sb) {
            recordMap.put((String)n.getFullyQualifiedName().get(), n);
        }

        public void visit(ClassOrInterfaceDeclaration subClass, StringBuilder sb) {
            if (subClass.getFullyQualifiedName().orElse("").startsWith("grpc.server")) {
                return;
            }
            Optional opt = subClass.getAnnotationByName("Path");
            SingleMemberAnnotationExpr annotationExpr = opt.isPresent() ? (SingleMemberAnnotationExpr)opt.get() : null;
            String classPath = "";
            if (annotationExpr != null) {
                classPath = annotationExpr.getMemberValue().toString();
                classPath = classPath.substring(1, classPath.length() - 1);
            }
            for (BodyDeclaration bd : subClass.getMembers()) {
                MethodDeclaration md;
                if (!(bd instanceof MethodDeclaration) || !JavaToProtobufGenerator.isResourceOrLocatorMethod(md = (MethodDeclaration)bd)) continue;
                String methodPath = "";
                opt = md.getAnnotationByName("Path");
                SingleMemberAnnotationExpr singleMemberAnnotationExpr = annotationExpr = opt.isPresent() ? (SingleMemberAnnotationExpr)opt.get() : null;
                if (annotationExpr != null) {
                    methodPath = annotationExpr.getMemberValue().toString();
                    methodPath = methodPath.substring(1, methodPath.length() - 1);
                }
                String httpMethod = JavaToProtobufGenerator.getHttpMethod(md);
                if (!started) {
                    sb.append(LS + "service ").append(prefix).append("Service {" + LS);
                    started = true;
                }
                String entityType = JavaToProtobufGenerator.getEntityParameter(md, httpMethod);
                String returnType = JavaToProtobufGenerator.getReturnType(md, httpMethod);
                entityMessageTypes.add(entityType);
                returnMessageTypes.add(returnType);
                String syncType = JavaToProtobufGenerator.isSuspended(md) ? "suspended" : (JavaToProtobufGenerator.isCompletionStage(md) ? "completionStage" : (JavaToProtobufGenerator.isSSE(md) ? "sse" : "sync"));
                sb.append("// ");
                if (!"".equals(classPath)) {
                    sb.append(classPath).append("/");
                }
                if ("".equals(classPath + methodPath)) {
                    methodPath = "\"\"";
                }
                sb.append(methodPath).append(" ").append(entityType).append(" ").append(returnType).append(" ").append(httpMethod).append(" ").append(syncType).append(LS);
                sb.append("  rpc ").append(JavaToProtobufGenerator.getRpcName(rpcNames, md.getNameAsString())).append(" (").append("GeneralEntityMessage").append(") returns (").append("sse".equals(syncType) ? "stream " : "").append("sse".equals(syncType) ? JavaToProtobufGenerator.SSE_EVENT_CLASSNAME : "GeneralReturnMessage").append(");" + LS);
                for (Parameter p : md.getParameters()) {
                    ReferenceTypeImpl rt;
                    ResolvedType objectified;
                    if (!JavaToProtobufGenerator.isEntity(p) || p.getType().resolve().isPrimitive() || p.getType().isArrayType() || visited.contains((objectified = JavaToProtobufGenerator.objectify((ResolvedReferenceType)(rt = (ReferenceTypeImpl)p.getType().resolve()))).describe())) continue;
                    pendingTypes.add(objectified);
                }
            }
        }
    }
}

