/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.grpc.bridge.runtime;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import dev.resteasy.grpc.bridge.runtime.HolderMap;
import dev.resteasy.grpc.bridge.runtime.i18n.Messages;
import dev.resteasy.grpc.bridge.runtime.protobuf.JavabufTranslator;
import jakarta.ws.rs.core.GenericType;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import org.jboss.resteasy.spi.util.Types;

public final class Utility {
    private static final Map<Class<?>, Class<?>> WRAPPER_CLASSES = new HashMap();

    private Utility() {
    }

    public static Message unpack(Any any, JavabufTranslator translator) throws Exception {
        Class clazz = Utility.extractClassFromAny(any, translator);
        return any.unpack(clazz);
    }

    public static Class extractClassFromAny(Any any, JavabufTranslator translator) {
        String s = Utility.extractStringTypeFromAny(any);
        if (s.equals("") || s == null) {
            return null;
        }
        int pos = s.lastIndexOf(46);
        s = s.substring(pos + 1);
        String t = translator.getOuterClassname();
        String classname = t + "$" + s;
        Class<?> c = translator.translatefromJavabufClass(classname);
        if (WRAPPER_CLASSES.containsKey(c)) {
            c = WRAPPER_CLASSES.get(c);
        }
        if (c == null) {
            throw Messages.MESSAGES.unableToProcessAsAny(any);
        }
        return translator.translateToJavabufClass(c);
    }

    public static Class<?> extractTypeFromAny(Any any, ClassLoader cl, String outerClassName) throws ClassNotFoundException {
        Object className = any.getTypeUrl().substring(any.getTypeUrl().indexOf(47) + 1);
        String pkg = ((String)className).substring(0, ((String)className).lastIndexOf(46) + 1);
        String innerClassName = ((String)className).substring(((String)className).lastIndexOf(46) + 1);
        className = pkg + outerClassName + "$" + innerClassName;
        Class<?> clazz = cl.loadClass((String)className);
        return clazz;
    }

    public static String extractStringTypeFromAny(Any any) {
        return any.getTypeUrl().substring(any.getTypeUrl().indexOf(47) + 1);
    }

    public static String getJavaClassname(String classname) {
        String javaClassname = classname.replace("___", ".");
        return javaClassname.replace('_', '.');
    }

    public static String getJavabufClassname(String classname) {
        Object javabufClassname = classname.replace('.', '_');
        int pos = ((String)javabufClassname).lastIndexOf(95);
        if (((String)(javabufClassname = ((String)javabufClassname).substring(0, pos) + "__" + ((String)javabufClassname).substring(pos))).startsWith("[")) {
            javabufClassname = ((String)javabufClassname).substring(2, ((String)javabufClassname).length() - 1) + "___WArray";
        }
        return javabufClassname;
    }

    public static String classnameToGetter(String s) {
        if (s.length() == 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("get");
        boolean upper = true;
        for (int i = 0; i < s.length(); ++i) {
            if ('_' == s.charAt(i)) {
                upper = true;
                continue;
            }
            if (upper) {
                sb.append(s.substring(i, i + 1).toUpperCase());
                upper = false;
                continue;
            }
            sb.append(s.charAt(i));
        }
        sb.append("Field");
        return sb.toString();
    }

    public static String getClassnameFromProto(Descriptors.FieldDescriptor fd) {
        String typeName = fd.toProto().getTypeName();
        int i = typeName.lastIndexOf(".");
        String name = typeName.substring(i + 1);
        name = name.replace("___", ".");
        name = name.replace('_', '.');
        return name;
    }

    public static void setField(Field field, Object object, Object value, JavabufTranslator translator) throws Exception {
        if (object instanceof HolderMap) {
            Utility.setObject(field, (HolderMap)object, value, translator);
            return;
        }
        if (Modifier.isFinal(field.getModifiers())) {
            if (Modifier.isStatic(field.getModifiers())) {
                return;
            }
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(Field.class, MethodHandles.lookup());
            VarHandle MODIFIERS = lookup.findVarHandle(Field.class, "modifiers", Integer.TYPE);
            MODIFIERS.set(field, field.getModifiers() & 0xFFFFFFEF);
            field.setAccessible(true);
        }
        field.setAccessible(true);
        if (value == null) {
            field.set(object, value);
        } else if (value.getClass().isArray()) {
            if (value.getClass().getComponentType().isPrimitive()) {
                field.set(object, value);
            } else {
                field.set(object, Utility.wrapArray(value));
            }
        } else if (Any.class.equals(value.getClass())) {
            Any any = (Any)value;
            if (any.getSerializedSize() == 0) {
                field.set(object, null);
            } else {
                Class clazz = Utility.extractClassFromAny(any, translator);
                Message message = any.unpack(clazz);
                Object javaObj = translator.translateFromJavabuf(message);
                field.set(object, javaObj);
            }
        } else {
            field.setAccessible(true);
            field.set(object, value);
        }
    }

    public static void setObject(Field field, HolderMap map, Object value, JavabufTranslator translator) throws Exception {
        if (value == null) {
            return;
        }
        if (Any.class.equals(value.getClass())) {
            Any any = (Any)value;
            if (any.getSerializedSize() == 0) {
                return;
            }
            Class clazz = Utility.extractClassFromAny(any, translator);
            Message message = any.unpack(clazz);
            map.put(field.getName(), translator.translateFromJavabuf(message));
            return;
        }
        map.put(field.getName(), value);
    }

    public static Class<?> getHiddenClass(Class<?> clazz, String classname) {
        Class<?>[] classes = clazz.getDeclaredClasses();
        for (int i = 0; i < classes.length; ++i) {
            if (!classname.equals(classes[i].getName())) continue;
            return classes[i];
        }
        return null;
    }

    public static Object[] wrapArray(Object o) {
        if (!o.getClass().isArray()) {
            throw Messages.MESSAGES.isNotAnArray(o);
        }
        Class<?> clazz = o.getClass().getComponentType();
        if (!WRAPPER_CLASSES.containsKey(clazz)) {
            return (Object[])o;
        }
        Object array = Array.newInstance(WRAPPER_CLASSES.get(clazz), Array.getLength(o));
        for (int i = 0; i < Array.getLength(array); ++i) {
            Array.set(array, i, Array.get(o, i));
        }
        return (Object[])array;
    }

    public static Field getField(Class<?> clazz, String name) {
        if (name.contains("___")) {
            try {
                name = name.substring(0, name.indexOf("___"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            try {
                Field field = c.getDeclaredField(name);
                return field;
            }
            catch (Exception e) {
                continue;
            }
        }
        return null;
    }

    public static Object getHiddenObject(Class<?> clazz, String hidden) {
        try {
            for (Class<?> c : clazz.getDeclaredClasses()) {
                if (!hidden.equals(c.getSimpleName())) continue;
                return c.newInstance();
            }
            throw Messages.MESSAGES.cantFind(clazz.getName() + "." + hidden);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static GenericType<?> objectify(GenericType<?> genericType) {
        return new GenericType(Utility.objectify(genericType.getType()));
    }

    public static Type objectify(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return type;
        }
        ParameterizedType ptype = (ParameterizedType)type;
        Type[] types = ptype.getActualTypeArguments();
        Type[] newTypes = new Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            newTypes[i] = types[i] instanceof WildcardType ? Utility.getBound((WildcardType)types[i]) : (types[i] instanceof TypeVariable ? Utility.getBound((TypeVariable)types[i]) : (types[i] instanceof ParameterizedType ? Utility.objectify((ParameterizedType)types[i]) : types[i]));
        }
        return new GrpcParameterizedType(newTypes, ptype.getRawType(), ptype.getOwnerType());
    }

    static Class<?> getBound(WildcardType w) {
        if (w.getLowerBounds().length == 0 && w.getUpperBounds().length == 0) {
            return Object.class;
        }
        try {
            if (w.getUpperBounds().length > 0) {
                String s = w.getUpperBounds()[0].getTypeName();
                return Class.forName(s);
            }
            return Object.class;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static Class<?> getBound(TypeVariable<?> t) {
        if (t.getBounds().length == 0) {
            return Object.class;
        }
        try {
            String s = t.getBounds()[0].getTypeName();
            return Class.forName(s);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        WRAPPER_CLASSES.put(Boolean.TYPE, Boolean.class);
        WRAPPER_CLASSES.put(Byte.TYPE, Byte.class);
        WRAPPER_CLASSES.put(Short.TYPE, Short.class);
        WRAPPER_CLASSES.put(Character.TYPE, Character.class);
        WRAPPER_CLASSES.put(Integer.TYPE, Integer.class);
        WRAPPER_CLASSES.put(Long.TYPE, Long.class);
        WRAPPER_CLASSES.put(Float.TYPE, Float.class);
        WRAPPER_CLASSES.put(Double.TYPE, Double.class);
    }

    public static class GrpcParameterizedType
    extends Types.ResteasyParameterizedType {
        public GrpcParameterizedType(Type[] actuals, Type rawType, Type ownerType) {
            super(actuals, rawType, ownerType);
        }

        public String toString() {
            Type[] actuals = this.getActualTypeArguments();
            StringBuilder sb = new StringBuilder();
            if (this.getOwnerType() != null) {
                sb.append(this.getOwnerType()).append(".");
            }
            sb.append(this.getRawType());
            if (actuals != null && actuals.length > 0) {
                sb.append("<");
                boolean first = true;
                for (Type actual : actuals) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(actual.getTypeName());
                }
                sb.append(">");
            }
            return sb.toString();
        }

        public static void toPrimitiveArray2(Descriptors.FieldDescriptor fd, Class componentType, Object array) {
        }

        public static void toPrimitiveArray(GeneratedMessage.Builder builder, Descriptors.FieldDescriptor fd, Class<?> componentType, Object array) {
            if (Byte.TYPE.equals(componentType)) {
                builder.setField(fd, (Object)ByteString.copyFrom((byte[])((byte[])array)));
            } else if (Character.TYPE.equals(componentType)) {
                builder.setField(fd, (Object)GrpcParameterizedType.charsToString(array));
            } else if (Boolean.TYPE.equals(componentType)) {
                for (int i = 0; i < Array.getLength(array); ++i) {
                    builder.addRepeatedField(fd, (Object)((Boolean)Array.get(array, i)));
                }
            } else if (Short.TYPE.equals(componentType)) {
                for (int i = 0; i < Array.getLength(array); ++i) {
                    builder.addRepeatedField(fd, (Object)((Short)Array.get(array, i)));
                }
            } else if (Integer.TYPE.equals(componentType)) {
                for (int i = 0; i < Array.getLength(array); ++i) {
                    builder.addRepeatedField(fd, (Object)((Integer)Array.get(array, i)));
                }
            } else if (Long.TYPE.equals(componentType)) {
                for (int i = 0; i < Array.getLength(array); ++i) {
                    builder.addRepeatedField(fd, (Object)((Long)Array.get(array, i)));
                }
            } else if (Float.TYPE.equals(componentType)) {
                for (int i = 0; i < Array.getLength(array); ++i) {
                    builder.addRepeatedField(fd, (Object)Float.valueOf(((Float)Array.get(array, i)).floatValue()));
                }
            } else if (Double.TYPE.equals(componentType)) {
                for (int i = 0; i < Array.getLength(array); ++i) {
                    builder.addRepeatedField(fd, (Object)((Double)Array.get(array, i)));
                }
            } else {
                throw Messages.MESSAGES.dontRecognizeType(componentType);
            }
        }

        private static String charsToString(Object o) {
            StringBuilder sb = new StringBuilder();
            if (Character.TYPE.equals(o.getClass().getComponentType())) {
                char[] array = (char[])o;
                for (int i = 0; i < array.length; ++i) {
                    sb.append(array[i]);
                }
            } else {
                Character[] array = (Character[])o;
                for (int i = 0; i < array.length; ++i) {
                    sb.append(array[i]);
                }
            }
            return sb.toString();
        }
    }
}

