/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.grpc.bridge.runtime.servlet;

import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import dev.resteasy.grpc.bridge.runtime.i18n.Messages;
import dev.resteasy.grpc.bridge.runtime.servlet.AsyncMockServletOutputStream;
import dev.resteasy.grpc.bridge.runtime.servlet.MockServletOutputStream;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class HttpServletResponseImpl
implements HttpServletResponse {
    public static final String GRPC_ASYNC = "grpc-async";
    private static final String RFC1123_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final SimpleDateFormat SDF = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
    private GeneratedMessage.Builder<?> builder;
    private Descriptors.FieldDescriptor fd;
    private MockServletOutputStream msos;
    private MultivaluedMap<String, String> headers = new MultivaluedHashMap();
    private String contentType;
    private String charset;
    private boolean charsetSet = false;
    private PrintWriter writer;
    private int statusCode;
    private Locale locale;
    private List<Cookie> cookies = new ArrayList<Cookie>();
    private ResponseState responseState = ResponseState.NONE;

    public HttpServletResponseImpl(String retn, String async, ServletContext servletContext, GeneratedMessage.Builder<?> builder, Descriptors.FieldDescriptor fd) {
        ArrayList<String> list;
        if ("com.google.protobuf.Any".equals(retn) || "Any".equals(retn)) {
            list = new ArrayList<String>();
            list.add("true");
            this.headers.put((Object)"ANY", list);
        }
        if ("completionStage".equals(async) || "sse".equals(async) || "suspended".equals(async)) {
            list = new ArrayList();
            list.add("true");
            this.headers.put((Object)GRPC_ASYNC, list);
            this.msos = new AsyncMockServletOutputStream();
        } else {
            this.msos = new MockServletOutputStream();
        }
        if ("ANY".equals(retn)) {
            list = new ArrayList();
            this.headers.put((Object)"ANY", list);
        }
        this.builder = builder;
        this.fd = fd;
    }

    public String getCharacterEncoding() {
        if (this.charset != null) {
            return this.charset;
        }
        return StandardCharsets.ISO_8859_1.name();
    }

    public String getContentType() {
        if (this.contentType != null) {
            if (this.charsetSet) {
                return this.contentType + ";charset=" + this.getCharacterEncoding();
            }
            return this.contentType;
        }
        return null;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.responseState == ResponseState.WRITER) {
            throw Messages.MESSAGES.getWriterAlreadyCalled();
        }
        this.responseState = ResponseState.STREAM;
        return this.msos;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            if (!this.charsetSet) {
                this.setCharacterEncoding(this.getCharacterEncoding());
            }
            if (this.responseState == ResponseState.STREAM) {
                throw Messages.MESSAGES.getOutputStreamAlreadyCalled();
            }
            this.responseState = ResponseState.WRITER;
            this.writer = new PrintWriter((OutputStream)((Object)this.msos));
        }
        return this.writer;
    }

    public void setCharacterEncoding(String charset) {
        this.charsetSet = charset != null;
        this.charset = charset;
        if (this.contentType != null) {
            this.headers.put((Object)"Content-Type", this.toList(this.getContentType()));
        }
    }

    public void setContentLength(int len) {
    }

    public void setContentLengthLong(long len) {
    }

    public void setContentType(String type) {
        if (type == null) {
            return;
        }
        ContentTypeInfo ct = this.parseContentType(type);
        this.contentType = ct.getContentType();
        boolean useCharset = false;
        if (ct.getCharset() != null && this.writer == null && !this.isCommitted()) {
            this.charset = ct.getCharset();
            this.charsetSet = true;
            useCharset = true;
        }
        if (useCharset || !this.charsetSet) {
            this.headers.put((Object)"Content-Type", this.toList(ct.getHeader()));
        } else if (ct.getCharset() == null) {
            this.headers.put((Object)"Content-Type", this.toList(ct.getHeader() + "; charset=" + this.charset));
        } else {
            this.headers.put((Object)"Content-Type", this.toList(ct.getContentType() + "; charset=" + this.charset));
        }
    }

    public void setBufferSize(int size) {
    }

    public int getBufferSize() {
        return 0;
    }

    public void flushBuffer() throws IOException {
    }

    public void resetBuffer() {
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
        this.msos.getDelegate().reset();
        this.writer = null;
        this.headers.clear();
        this.responseState = ResponseState.NONE;
        this.statusCode = Response.Status.OK.getStatusCode();
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
        this.headers.put((Object)"Content-Language", this.toList(loc.getLanguage() + "-" + loc.getCountry()));
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return Locale.getDefault();
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey((Object)name);
    }

    public String encodeURL(String url) {
        throw Messages.MESSAGES.isNotImplemented("encodeURL()");
    }

    public String encodeRedirectURL(String url) {
        throw Messages.MESSAGES.isNotImplemented("encodeRedirectURL()");
    }

    public String encodeUrl(String url) {
        throw Messages.MESSAGES.isNotImplemented("encodeUrl()");
    }

    public String encodeRedirectUrl(String url) {
        throw Messages.MESSAGES.isNotImplemented("encodeRedirectUrl()");
    }

    public void sendError(int sc, String msg) throws IOException {
        this.builder.setField(this.fd, (Object)("error status: " + sc + ": " + msg)).build().writeTo((OutputStream)((Object)this.msos));
    }

    public void sendError(int sc) throws IOException {
        this.builder.setField(this.fd, (Object)("error status: " + sc)).build().writeTo((OutputStream)((Object)this.msos));
    }

    public void sendRedirect(String location) throws IOException {
        throw Messages.MESSAGES.isNotImplemented("sendRedirect()");
    }

    public void setDateHeader(String name, long date) {
        this.setHeader(name, HttpServletResponseImpl.toDateString(new Date(date)));
    }

    public void addDateHeader(String name, long date) {
        this.addHeader(name, HttpServletResponseImpl.toDateString(new Date(date)));
    }

    public void setHeader(String name, String value) {
        if (name == null) {
            throw Messages.MESSAGES.headerNameWasNull();
        }
        this.headers.put((Object)name, this.toList(value));
    }

    public void addHeader(String name, String value) {
        ArrayList<String> list = (ArrayList<String>)this.headers.get((Object)name);
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.add(value);
        this.headers.put((Object)name, list);
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, Integer.toString(value));
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, Integer.toString(value));
    }

    public void setStatus(int sc) {
        this.statusCode = sc;
    }

    public void setStatus(int sc, String sm) {
        this.statusCode = sc;
    }

    public int getStatus() {
        return this.statusCode;
    }

    public String getHeader(String name) {
        List list = (List)this.headers.get((Object)name);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (String)list.get(0);
    }

    public Collection<String> getHeaders(String name) {
        return (Collection)this.headers.get((Object)name);
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public void removeHeader(String name) {
        this.headers.remove((Object)name);
    }

    private List<String> toList(String s) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(s);
        return list;
    }

    private ContentTypeInfo parseContentType(String type) {
        String contentType = type;
        String charset = null;
        int split = type.indexOf(";");
        if (split != -1) {
            char c;
            int i;
            int pos = type.indexOf("charset=");
            if (pos != -1) {
                i = pos + "charset=".length();
                while ((c = type.charAt(i)) != ' ' && c != '\t' && c != ';' && ++i < type.length()) {
                }
                charset = type.substring(pos + "charset=".length(), i);
                if (charset.startsWith("\"") && charset.endsWith("\"") && charset.length() > 1) {
                    charset = charset.substring(1, charset.length() - 1);
                }
                int charsetStart = pos;
                while (type.charAt(--charsetStart) != ';' && charsetStart > 0) {
                }
                StringBuilder contentTypeBuilder = new StringBuilder();
                contentTypeBuilder.append(type.substring(0, charsetStart));
                if (i != type.length()) {
                    contentTypeBuilder.append(type.substring(i));
                }
                contentType = contentTypeBuilder.toString();
            }
            for (i = contentType.length() - 1; i >= 0; --i) {
                c = contentType.charAt(i);
                if (c == ' ' || c == '\t') continue;
                if (c != ';') break;
                contentType = contentType.substring(0, i);
                break;
            }
        }
        ContentTypeInfo ct = null;
        ct = charset == null ? new ContentTypeInfo(contentType, null, contentType) : new ContentTypeInfo(contentType + ";charset=" + charset, charset, contentType);
        return ct;
    }

    public static String toDateString(Date date) {
        SDF.setTimeZone(TimeZone.getTimeZone("GMT"));
        return SDF.format(date);
    }

    public static enum ResponseState {
        NONE,
        STREAM,
        WRITER;

    }

    private class ContentTypeInfo {
        private final String header;
        private final String charset;
        private final String contentType;

        ContentTypeInfo(String header, String charset, String contentType) {
            this.header = header;
            this.charset = charset;
            this.contentType = contentType;
        }

        public String getHeader() {
            return this.header;
        }

        public String getCharset() {
            return this.charset;
        }

        public String getContentType() {
            return this.contentType;
        }
    }
}

