/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service;

import io.jans.as.client.TokenRequest;
import io.jans.as.client.TokenResponse;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.common.ScopeType;
import io.jans.as.model.uma.wrapper.Token;
import io.jans.as.model.util.Util;
import io.jans.lock.model.config.AppConfiguration;
import io.jans.model.net.HttpServiceResponse;
import io.jans.service.EncryptionService;
import io.jans.service.net.BaseHttpService;
import io.jans.util.security.StringEncrypter;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class TokenEndpointService {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String AUTHORIZATION = "Authorization";
    @Inject
    Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private BaseHttpService httpService;
    @Inject
    private EncryptionService encryptionService;

    public Token getAccessToken(String endpoint, boolean allGroupScopes) {
        this.log.info("Request for token  for endpoint:{}, allGroupScopes:{}", (Object)endpoint, (Object)allGroupScopes);
        String tokenUrl = this.appConfiguration.getTokenUrl();
        String clientId = this.appConfiguration.getClientId();
        String clientSecret = this.getDecryptedPassword(this.appConfiguration.getClientPassword());
        String scopes = this.getScopeForToken(endpoint, allGroupScopes);
        this.log.info("Scope  for endpoint:{}, allGroupScopes:{}, scopes:{}", new Object[]{endpoint, allGroupScopes, scopes});
        return this.getToken(tokenUrl, clientId, clientSecret, scopes);
    }

    public Token getToken(String tokenUrl, String clientId, String clientSecret, String scopes) {
        this.log.info("Request for token tokenUrl:{}, clientId:{},scopes:{}", new Object[]{tokenUrl, clientId, scopes});
        Token token = null;
        TokenResponse tokenResponse = this.requestAccessToken(tokenUrl, clientId, clientSecret, scopes);
        if (tokenResponse != null) {
            String accessToken = tokenResponse.getAccessToken();
            Integer expiresIn = tokenResponse.getExpiresIn();
            this.log.trace("accessToken:{}, expiresIn:{}", (Object)accessToken, (Object)expiresIn);
            if (Util.allNotBlank((String[])new String[]{accessToken})) {
                return new Token(null, null, accessToken, ScopeType.OPENID.getValue(), expiresIn);
            }
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenResponse requestAccessToken(String tokenUrl, String clientId, String clientSecret, String scope) {
        this.log.info("Request for access token tokenUrl:{}, clientId:{},scope:{}", new Object[]{tokenUrl, clientId, scope});
        try (Response response = null;){
            TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
            tokenRequest.setScope(scope);
            tokenRequest.setAuthUsername(clientId);
            tokenRequest.setAuthPassword(clientSecret);
            Invocation.Builder request = TokenEndpointService.getClientBuilder(tokenUrl);
            request.header(AUTHORIZATION, (Object)("Basic " + tokenRequest.getEncodedCredentials()));
            request.header(CONTENT_TYPE, (Object)"application/x-www-form-urlencoded");
            MultivaluedHashMap multivaluedHashMap = new MultivaluedHashMap(tokenRequest.getParameters());
            response = request.post(Entity.form((MultivaluedMap)multivaluedHashMap));
            this.log.trace("Response for Access Token -  response:{}", (Object)response);
            if (response.getStatus() == 200) {
                String entity = (String)response.readEntity(String.class);
                TokenResponse tokenResponse = new TokenResponse();
                tokenResponse.setEntity(entity);
                tokenResponse.injectDataFromJson(entity);
                TokenResponse tokenResponse2 = tokenResponse;
                return tokenResponse2;
            }
        }
        return null;
    }

    public HttpServiceResponse postData(String uri, String authType, String token, Map<String, String> headers, ContentType contentType, String postData) {
        this.log.debug("postData - uri:{}, token:{}, data", (Object)uri, (Object)token);
        if (StringUtils.isBlank((CharSequence)authType)) {
            authType = "Bearer ";
        }
        if (contentType == null) {
            contentType = ContentType.APPLICATION_JSON;
        }
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put(CONTENT_TYPE, ContentType.APPLICATION_JSON.toString());
        headers.put(AUTHORIZATION, authType + token);
        HttpServiceResponse response = this.httpService.executePost(uri, token, headers, postData, contentType, authType);
        this.log.debug("response:{}", (Object)response);
        return response;
    }

    public String getResponseEntityString(HttpServiceResponse serviceResponse, Response.Status status) {
        String jsonString = null;
        if (serviceResponse == null) {
            return jsonString;
        }
        if (serviceResponse.getHttpResponse() != null && serviceResponse.getHttpResponse().getStatusLine() != null && serviceResponse.getHttpResponse().getStatusLine().getStatusCode() == status.getStatusCode()) {
            HttpEntity entity = serviceResponse.getHttpResponse().getEntity();
            if (entity == null) {
                return jsonString;
            }
            jsonString = entity.toString();
        }
        return jsonString;
    }

    public String getResponseEntityString(HttpServiceResponse serviceResponse) {
        String jsonString = null;
        if (serviceResponse == null || serviceResponse.getHttpResponse() == null) {
            return jsonString;
        }
        HttpEntity entity = serviceResponse.getHttpResponse().getEntity();
        if (entity == null) {
            return jsonString;
        }
        jsonString = entity.toString();
        try {
            this.log.debug("serviceResponse.getHttpResponse().getEntity():{}", (Object)serviceResponse.getHttpResponse().getEntity());
            String responseMsg = EntityUtils.toString((HttpEntity)serviceResponse.getHttpResponse().getEntity(), (String)"UTF-8");
            this.log.debug("New responseMsg:{}", (Object)responseMsg);
        }
        catch (Exception ex) {
            this.log.error("Error while getting entity using EntityUtils is ", (Throwable)ex);
        }
        return jsonString;
    }

    public Response.Status getResponseStatus(HttpServiceResponse serviceResponse) {
        Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
        if (serviceResponse == null || serviceResponse.getHttpResponse() == null) {
            return status;
        }
        int statusCode = serviceResponse.getHttpResponse().getStatusLine().getStatusCode();
        status = Response.Status.fromStatusCode((int)statusCode);
        if (status == null) {
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return status;
    }

    public String getDecryptedPassword(String clientPassword) {
        String decryptedPassword = null;
        if (clientPassword != null) {
            try {
                decryptedPassword = this.encryptionService.decrypt(clientPassword);
            }
            catch (StringEncrypter.EncryptionException ex) {
                this.log.error("Failed to decrypt password", (Throwable)ex);
            }
        }
        return decryptedPassword;
    }

    public List<String> getScopes(String endpoint) {
        this.log.info("Get scope for endpoint:{} ", (Object)endpoint);
        List scopeList = null;
        Map endpointMap = this.appConfiguration.getEndpointDetails();
        this.log.debug("Get scope for endpoint:{} from endpointMap:{}", (Object)endpoint, (Object)endpointMap);
        if (endpointMap == null || endpointMap.isEmpty()) {
            return scopeList;
        }
        for (Map.Entry entry : endpointMap.entrySet()) {
            this.log.info(" entry.getKey():{}, entry.getValue():{}", entry.getKey(), entry.getValue());
            if (entry.getKey() == null || !((String)entry.getKey()).toLowerCase().endsWith(endpoint)) continue;
            scopeList = (List)entry.getValue();
            break;
        }
        this.log.info("Scope for endpoint:{} scopeList:{} ", (Object)endpoint, scopeList);
        return scopeList;
    }

    private String getEndpointPath(String endpoint) {
        Map endpointMap = this.appConfiguration.getEndpointDetails();
        this.log.debug("Get endpoint URL for endpoint:{} from endpointMap:{}", (Object)endpoint, (Object)endpointMap);
        if (StringUtils.isBlank((CharSequence)endpoint) || endpointMap == null || endpointMap.isEmpty()) {
            return endpoint;
        }
        Set keys = endpointMap.keySet();
        String endpointPath = keys.stream().filter(e -> e != null && e.toLowerCase().endsWith("/" + endpoint.toLowerCase())).findFirst().orElse(null);
        this.log.debug("Final endpoint:{}, keys:{}, endpointPath:{}", new Object[]{endpoint, keys, endpointPath});
        return endpointPath;
    }

    private String getEndpointUrl(String endpoint) {
        if (StringUtils.isBlank((CharSequence)endpoint)) {
            return endpoint;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.appConfiguration.getOpenIdIssuer());
        sb.append("/");
        sb.append(endpoint);
        this.log.debug("endpoint:{} url is  sb:{}", (Object)endpoint, (Object)sb);
        return sb.toString();
    }

    private String getScopeForToken(String endpoint, boolean allGroupScopes) {
        this.log.info("Request for token  for endpoint:{}, allGroupScopes:{}", (Object)endpoint, (Object)allGroupScopes);
        StringBuilder sb = new StringBuilder();
        sb.append(ScopeType.OPENID.getValue());
        List<String> scopeList = null;
        scopeList = allGroupScopes ? this.getAllGroupScope(endpoint) : this.getScopes(endpoint);
        this.log.debug("Scope  for endpoint:{}, allGroupScopes:{}, scopeList:{}", new Object[]{endpoint, allGroupScopes, scopeList});
        if (scopeList == null || scopeList.isEmpty()) {
            return sb.toString();
        }
        HashSet<String> scopeSet = new HashSet<String>(scopeList);
        for (String scope : scopeSet) {
            sb.append(" ").append(scope);
        }
        return sb.toString();
    }

    private List<String> getAllGroupScope(String endpoint) {
        this.log.info(" Get group scopes for String endpoint:{}", (Object)endpoint);
        List<String> scopeList = null;
        String groupName = this.getEndpointGroup(endpoint);
        Map endpointGroups = this.appConfiguration.getEndpointGroups();
        this.log.debug(" groupName for endpoint:{} is {}", (Object)endpoint, (Object)groupName);
        scopeList = this.getScopes(endpoint);
        if (StringUtils.isBlank((CharSequence)groupName)) {
            return scopeList;
        }
        List endpoints = (List)endpointGroups.get(groupName);
        this.log.debug("groupName:{}, endpoints:{}", (Object)groupName, (Object)endpoints);
        if (endpoints == null || endpoints.isEmpty()) {
            return scopeList;
        }
        for (String url : endpoints) {
            scopeList.addAll(this.getScopes(url));
        }
        this.log.info("Scope for groupName:{}, scopeList:{}", (Object)groupName, scopeList);
        return scopeList;
    }

    private String getEndpointGroup(String endpoint) {
        this.log.info("Get groupName for  endpoint:{}", (Object)endpoint);
        String groupName = null;
        if (StringUtils.isBlank((CharSequence)endpoint)) {
            return groupName;
        }
        Map endpointGroups = this.appConfiguration.getEndpointGroups();
        this.log.debug(" endpointGroups:{}", (Object)endpointGroups);
        if (endpointGroups == null || endpointGroups.isEmpty()) {
            return groupName;
        }
        for (Map.Entry entry : endpointGroups.entrySet()) {
            this.log.debug(" entry.getKey():{}, entry.getValue():{}", entry.getKey(), entry.getValue());
            if (entry.getValue() == null || !((List)entry.getValue()).contains(endpoint.toLowerCase())) continue;
            groupName = (String)entry.getKey();
            break;
        }
        this.log.info(" endpoint:{} groupName:{}", (Object)endpoint, groupName);
        return groupName;
    }

    private static Invocation.Builder getClientBuilder(String url) {
        return ClientBuilder.newClient().target(url).request();
    }

    public Response post(String endpoint, String postData, ContentType contentType, String token) {
        this.log.info("postData - endpoint:{}, postData:{}", (Object)endpoint, (Object)postData);
        String endpointPath = this.getEndpointPath(endpoint);
        this.log.debug("Posting data for - endpoint:{}, endpointPath:{},this.getEndpointUrl(endpointPath):{}", new Object[]{endpoint, endpointPath, this.getEndpointUrl(endpointPath)});
        return this.post(this.getEndpointUrl(endpointPath), null, token, null, contentType, postData);
    }

    private Response post(String url, String authType, String token, Map<String, String> headers, ContentType contentType, String postData) {
        this.log.info("postData - url:{}, authType:{}, token:{}, headers:{}, contentType:{}, postData:{}", new Object[]{url, authType, token, headers, contentType, postData});
        if (StringUtils.isBlank((CharSequence)authType)) {
            authType = "Bearer ";
        }
        if (contentType == null) {
            contentType = ContentType.APPLICATION_JSON;
        }
        Invocation.Builder request = TokenEndpointService.getClientBuilder(url);
        request.header(AUTHORIZATION, (Object)(authType + token));
        request.header(CONTENT_TYPE, (Object)contentType);
        if (headers != null) {
            for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
                request.header(headerEntry.getKey(), (Object)headerEntry.getValue());
            }
        }
        this.log.debug(" request:{}}", (Object)request);
        Response response = request.post(Entity.entity((Object)postData, (String)"application/json"));
        this.log.debug(" response:{}", (Object)response);
        return response;
    }
}

