/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service;

import io.jans.lock.model.config.StaticConfiguration;
import io.jans.model.token.TokenEntity;
import io.jans.orm.PersistenceEntryManager;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.slf4j.Logger;

@ApplicationScoped
public class TokenService {
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private StaticConfiguration staticConfiguration;

    public String buildDn(String hashedToken) {
        return String.format("tknCde=%s,", hashedToken) + this.tokenBaseDn();
    }

    private String tokenBaseDn() {
        return this.staticConfiguration.getBaseDn().getTokens();
    }

    public TokenEntity findToken(String tokenCode) {
        String tokenDn = this.buildDn(tokenCode);
        return (TokenEntity)this.persistenceEntryManager.find(TokenEntity.class, (Object)tokenDn);
    }
}

