/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.jans.lock.model.config.AppConfiguration;
import io.jans.service.net.NetworkService;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Path;

@ApplicationScoped
@Path(value="/configuration")
public class ConfigurationService {
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private NetworkService networkService;
    private ObjectMapper objectMapper;

    @PostConstruct
    public void init() {
        this.objectMapper = new ObjectMapper();
    }

    public ObjectNode getLockConfiguration() {
        String baseEndpointUri = this.appConfiguration.getBaseEndpoint();
        ObjectNode response = this.objectMapper.createObjectNode();
        response.put("version", "1.0");
        response.put("issuer", this.networkService.getHost(baseEndpointUri));
        ObjectNode audit = this.objectMapper.createObjectNode();
        response.set("audit", (JsonNode)audit);
        audit.put("health_endpoint", baseEndpointUri + "/audit/health");
        audit.put("log_endpoint", baseEndpointUri + "/audit/log");
        audit.put("telemetry_endpoint", baseEndpointUri + "/audit/telemetry");
        ObjectNode config = this.objectMapper.createObjectNode();
        response.set("config", (JsonNode)config);
        config.put("config_endpoint", baseEndpointUri + "/configuration");
        config.put("issuers_endpoint", baseEndpointUri + "/config/issuers");
        config.put("policy_endpoint", baseEndpointUri + "/config/policy");
        config.put("schema_endpoint", baseEndpointUri + "/config/schema");
        config.put("sse_endpoint", baseEndpointUri + "/sse");
        return response;
    }
}

