/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service.filter;

import io.jans.lock.service.filter.ProtectionService;
import io.jans.service.security.api.ProtectedApi;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.slf4j.Logger;

@ProtectedApi
@Priority(value=1000)
@Dependent
public class AuthorizationProcessingFilter
implements ContainerRequestFilter {
    @Inject
    private Logger log;
    @Inject
    private ProtectionService protectionService;
    @Context
    private HttpHeaders httpHeaders;
    @Context
    private ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String path = requestContext.getUriInfo().getPath();
        this.log.debug("REST call to '{}' intercepted", (Object)path);
        Response authorizationResponse = this.protectionService.processAuthorization(this.httpHeaders, this.resourceInfo);
        if (authorizationResponse == null) {
            this.log.debug("Authorization passed");
        }
        if (authorizationResponse != null) {
            requestContext.abortWith(authorizationResponse);
        }
    }

    private Response unprotectedApiResponse(String name) {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)(name + " API not protected")).build();
    }

    private Response disabledApiResponse(String name) {
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)(name + " API is disabled")).build();
    }
}

