/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service.ws.rs;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.jans.lock.model.core.LockApiError;
import io.jans.lock.service.config.ConfigurationService;
import io.jans.lock.util.ServerUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.inject.Inject;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.IOException;
import java.io.PrintWriter;
import org.slf4j.Logger;

@WebServlet(urlPatterns={"/.well-known/lock-server-configuration"}, loadOnStartup=10)
@Path(value="/.well-known/lock-server-configuration")
public class WellKnownConfiguration
extends HttpServlet {
    private static final long serialVersionUID = -8224898157373678904L;
    @Inject
    private transient Logger log;
    @Inject
    private transient ConfigurationService configurationService;

    protected void processRequest(HttpServletRequest servletRequest, HttpServletResponse httpResponse) throws IOException {
        httpResponse.setContentType("application/json");
        try (PrintWriter out = httpResponse.getWriter();){
            ObjectNode responde = this.configurationService.getLockConfiguration();
            out.println(ServerUtil.toPrettyJson(responde).replace("\\/", "/"));
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Operation(summary="Request .well-known data", description="Request .well-know Lock server configuration", tags={"Lock - Server Configuration"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class, description="ConfigurationFound"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=LockApiError.class, description="InternalServerError"))})})
    @GET
    @Produces(value={"application/json"})
    public void doGet(@Parameter(hidden=true) HttpServletRequest request, @Parameter(hidden=true) HttpServletResponse response) throws IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Lock Well Known Configuration Information";
    }
}

