/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service.ws.rs.base;

import io.jans.lock.model.core.LockApiError;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseResource {
    private static final String MISSING_ATTRIBUTE_CODE = "OCA001";
    private static final String MISSING_ATTRIBUTE_MESSAGE = "A required attribute is missing.";
    @Context
    UriInfo uriInfo;
    @Context
    private HttpServletRequest httpRequest;
    @Context
    private HttpHeaders httpHeaders;
    private static Logger log = LoggerFactory.getLogger(BaseResource.class);

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public HttpServletRequest getHttpRequest() {
        return this.httpRequest;
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public static <T> void checkResourceNotNull(T resource, String objectName) {
        if (resource == null) {
            throw new NotFoundException(BaseResource.getNotFoundError(objectName));
        }
    }

    public static void checkNotNull(String attribute, String attributeName) {
        if (StringUtils.isBlank((CharSequence)attribute)) {
            throw new BadRequestException(BaseResource.getMissingAttributeError(attributeName));
        }
    }

    public static void checkNotNull(String[] attributes, String attributeName) {
        if (attributes == null || attributes.length <= 0) {
            throw new BadRequestException(BaseResource.getMissingAttributeError(attributeName));
        }
    }

    public static void checkNotNull(Map<String, String> attributeMap) {
        if (attributeMap.isEmpty()) {
            return;
        }
        Map<String, String> map = attributeMap.entrySet().stream().filter(k -> k.getValue() == null || StringUtils.isNotEmpty((CharSequence)((CharSequence)k.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        log.debug(" map:{}", map);
        if (!map.isEmpty()) {
            throw new BadRequestException(BaseResource.getMissingAttributeError(map.keySet().toString()));
        }
    }

    public static <T> void checkNotEmpty(List<T> list, String attributeName) {
        if (list == null || list.isEmpty()) {
            throw new BadRequestException(BaseResource.getMissingAttributeError(attributeName));
        }
    }

    public static void checkNotEmpty(String attribute, String attributeName) {
        if (StringUtils.isEmpty((CharSequence)attribute)) {
            throw new BadRequestException(BaseResource.getMissingAttributeError(attributeName));
        }
    }

    public static void throwBadRequestException(String msg) {
        throw new BadRequestException(BaseResource.getBadRequestException(msg));
    }

    public static void throwBadRequestException(String msg, String description) {
        throw new BadRequestException(BaseResource.getBadRequestException(msg, description));
    }

    public static void throwBadRequestException(Object obj) {
        throw new BadRequestException(BaseResource.getBadRequestException(obj));
    }

    public static void throwInternalServerException(String msg) {
        throw new InternalServerErrorException(BaseResource.getInternalServerException(msg));
    }

    public static void throwInternalServerException(String msg, String description) {
        throw new InternalServerErrorException(BaseResource.getInternalServerException(msg, description));
    }

    public static void throwInternalServerException(String msg, Throwable throwable) {
        if ((throwable = BaseResource.findRootError(throwable)) != null) {
            throw new InternalServerErrorException(BaseResource.getInternalServerException(msg, throwable.getMessage()));
        }
    }

    public static void throwInternalServerException(Throwable throwable) {
        if ((throwable = BaseResource.findRootError(throwable)) != null) {
            throw new InternalServerErrorException(BaseResource.getInternalServerException(throwable.getMessage()));
        }
    }

    public static void throwNotFoundException(String msg) {
        throw new NotFoundException(BaseResource.getNotFoundError(msg));
    }

    public static void throwNotFoundException(String msg, String description) {
        throw new NotFoundException(BaseResource.getNotFoundError(msg, description));
    }

    protected static Response getMissingAttributeError(String attributeName) {
        LockApiError error = new LockApiError.ErrorBuilder().withCode(MISSING_ATTRIBUTE_CODE).withMessage(MISSING_ATTRIBUTE_MESSAGE).andDescription("The attribute " + attributeName + " is required for this operation").build();
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build();
    }

    protected static Response getNotFoundError(String objectName) {
        LockApiError error = new LockApiError.ErrorBuilder().withCode(String.valueOf(Response.Status.NOT_FOUND.getStatusCode())).withMessage("The requested " + objectName + " doesn't exist").build();
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).build();
    }

    protected static Response getNotFoundError(String msg, String description) {
        LockApiError error = new LockApiError.ErrorBuilder().withCode(String.valueOf(Response.Status.NOT_FOUND.getStatusCode())).withMessage(msg).andDescription(description).build();
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).build();
    }

    protected static Response getNotAcceptableException(String msg) {
        LockApiError error = new LockApiError.ErrorBuilder().withCode(String.valueOf(Response.Status.NOT_ACCEPTABLE.getStatusCode())).withMessage(msg).build();
        return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)error).build();
    }

    protected static Response getBadRequestException(String msg) {
        LockApiError error = new LockApiError.ErrorBuilder().withCode(String.valueOf(Response.Status.BAD_REQUEST.getStatusCode())).withMessage(msg).build();
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build();
    }

    protected static Response getBadRequestException(String msg, String description) {
        LockApiError error = new LockApiError.ErrorBuilder().withCode(String.valueOf(Response.Status.BAD_REQUEST.getStatusCode())).withMessage(msg).andDescription(description).build();
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build();
    }

    protected static Response getBadRequestException(Object obj) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(obj).build();
    }

    protected static Response getInternalServerException(String msg) {
        LockApiError error = new LockApiError.ErrorBuilder().withCode(String.valueOf(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode())).withMessage(msg).build();
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build();
    }

    protected static Response getInternalServerException(String msg, String description) {
        LockApiError error = new LockApiError.ErrorBuilder().withCode(String.valueOf(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode())).withMessage(msg).andDescription(description).build();
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build();
    }

    public static Throwable findRootError(Throwable throwable) {
        Throwable rootCause;
        if (throwable == null) {
            return throwable;
        }
        for (rootCause = throwable; rootCause.getCause() != null && rootCause.getCause() != rootCause; rootCause = rootCause.getCause()) {
        }
        return rootCause;
    }
}

