/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service.ws.rs.config;

import io.jans.lock.service.ws.rs.config.ConfigRestWebService;
import io.jans.lock.util.ServerUtil;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.slf4j.Logger;

@Dependent
public class ConfigRestWebServiceImpl
implements ConfigRestWebService {
    @Inject
    private Logger log;

    @Override
    public Response processConfigRequest(HttpServletRequest request, HttpServletResponse response, SecurityContext sec) {
        this.log.debug("Processing Config request");
        Response.ResponseBuilder builder = Response.ok();
        builder.cacheControl(ServerUtil.cacheControlWithNoStoreTransformAndPrivate());
        builder.header("Pragma", (Object)"no-cache");
        builder.entity((Object)"{\"res\" : \"ok_config\"}");
        return builder.build();
    }

    @Override
    public Response processIssuersRequest(HttpServletRequest request, HttpServletResponse response, SecurityContext sec) {
        this.log.debug("Processing Issuers request");
        Response.ResponseBuilder builder = Response.ok();
        builder.cacheControl(ServerUtil.cacheControlWithNoStoreTransformAndPrivate());
        builder.header("Pragma", (Object)"no-cache");
        builder.entity((Object)"{\"res\" : \"ok_issuers\"}");
        return builder.build();
    }

    @Override
    public Response processSchemaRequest(HttpServletRequest request, HttpServletResponse response, SecurityContext sec) {
        this.log.debug("Processing Schema request");
        Response.ResponseBuilder builder = Response.ok();
        builder.cacheControl(ServerUtil.cacheControlWithNoStoreTransformAndPrivate());
        builder.header("Pragma", (Object)"no-cache");
        builder.entity((Object)"{\"res\" : \"ok_schema\"}");
        return builder.build();
    }

    @Override
    public Response processPolicyRequest(HttpServletRequest request, HttpServletResponse response, SecurityContext sec) {
        this.log.debug("Processing Policy request");
        Response.ResponseBuilder builder = Response.ok();
        builder.cacheControl(ServerUtil.cacheControlWithNoStoreTransformAndPrivate());
        builder.header("Pragma", (Object)"no-cache");
        builder.entity((Object)"{\"res\" : \"ok_policy\"}");
        return builder.build();
    }
}

