/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service.ws.rs.sse;

import io.jans.as.client.StatusListResponse;
import io.jans.lock.service.TokenStsatusListService;
import io.jans.lock.service.event.TokenStatusListReloadEvent;
import io.jans.service.cdi.async.Asynchronous;
import io.jans.service.cdi.event.Scheduled;
import io.jans.service.timer.event.TimerEvent;
import io.jans.service.timer.schedule.TimerSchedule;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.ws.rs.sse.OutboundSseEvent;
import jakarta.ws.rs.sse.Sse;
import jakarta.ws.rs.sse.SseBroadcaster;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

@ApplicationScoped
public class LockSseBroadcaster {
    private static final int DEFAULT_INTERVAL = 15;
    private static final String STATUS_LIST_MESSAGE = "STATUS_LIST";
    @Inject
    private Logger log;
    @Inject
    private Event<TimerEvent> timerEvent;
    @Inject
    private TokenStsatusListService tokenStsatusListService;
    private SseBroadcaster sseBroadcaster;
    private Sse sse;
    private AtomicBoolean isActive;

    @PostConstruct
    public void init() {
        this.log.info("Initializing Token SSE broadcaster ...");
        this.isActive = new AtomicBoolean(false);
    }

    public void initTimer() {
        this.log.debug("Initializing Token Status List Timer");
        int delay = 30;
        int interval = 15;
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(30, 15), (Object)new TokenStatusListReloadEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
    }

    @Asynchronous
    public void reloadTokenStatusListTimerEvent(@Observes @Scheduled TokenStatusListReloadEvent tokenStatusListReloadEvent) {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.reloadTokenStatusList();
        }
        catch (Throwable ex) {
            this.log.error("Exception happened while reloading token status list", ex);
        }
        finally {
            this.isActive.set(false);
        }
    }

    private void reloadTokenStatusList() {
        StatusListResponse statusListResponse = this.tokenStsatusListService.loadTokenStatusList();
        if (statusListResponse == null) {
            return;
        }
        this.broadcast(STATUS_LIST_MESSAGE, statusListResponse.getEntity());
    }

    public SseBroadcaster getSseBroadcaster() {
        return this.sseBroadcaster;
    }

    public void setSseBroadcaster(SseBroadcaster sseBroadcaster) {
        this.sseBroadcaster = sseBroadcaster;
    }

    public Sse getSse() {
        return this.sse;
    }

    public void setSse(Sse sse) {
        this.sse = sse;
    }

    public void broadcast(String eventName, String data) {
        this.log.info("Broadcast message");
        if (this.sseBroadcaster == null) {
            return;
        }
        OutboundSseEvent event = this.sse.newEventBuilder().name(eventName).data(String.class, (Object)data).build();
        this.sseBroadcaster.broadcast(event);
    }
}

