/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service;

import io.jans.as.client.OpenIdConfigurationClient;
import io.jans.as.client.OpenIdConfigurationResponse;
import io.jans.lock.model.config.AppConfiguration;
import io.jans.util.StringHelper;
import io.jans.util.exception.InvalidConfigurationException;
import io.jans.util.exception.MissingResourceException;
import io.jans.util.init.Initializable;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.Serializable;
import org.slf4j.Logger;

@ApplicationScoped
public class OpenIdService
extends Initializable
implements Serializable {
    private static final long serialVersionUID = 7875838160379126796L;
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    private OpenIdConfigurationResponse openIdConfiguration;

    protected void initInternal() {
        this.loadOpenIdConfiguration();
    }

    private void loadOpenIdConfiguration() {
        String openIdIssuer = this.appConfiguration.getOpenIdIssuer();
        if (StringHelper.isEmpty((String)openIdIssuer)) {
            throw new InvalidConfigurationException("OpenIdIssuer Url is invalid");
        }
        String openIdIssuerEndpoint = openIdIssuer + "/.well-known/openid-configuration";
        OpenIdConfigurationClient client = new OpenIdConfigurationClient(openIdIssuerEndpoint);
        this.openIdConfiguration = client.execOpenIdConfiguration();
        if (this.openIdConfiguration == null || this.openIdConfiguration.getStatus() != 200) {
            throw new MissingResourceException("Failed to load OpenID configuration!");
        }
        this.log.info("Successfully loaded OpenID configuration");
    }

    public OpenIdConfigurationResponse getOpenIdConfiguration() {
        this.init();
        return this.openIdConfiguration;
    }
}

