/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service.config;

import io.jans.exception.ConfigurationException;
import io.jans.lock.model.config.AppConfiguration;
import io.jans.lock.model.config.BaseDnConfiguration;
import io.jans.lock.model.config.Conf;
import io.jans.lock.model.config.Configuration;
import io.jans.lock.model.config.StaticConfiguration;
import io.jans.lock.model.config.cedarling.CedarlingPolicyConfiguration;
import io.jans.lock.model.error.ErrorResponseFactory;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.exception.BasePersistenceException;
import io.jans.orm.model.PersistenceConfiguration;
import io.jans.orm.service.PersistanceFactoryService;
import io.jans.service.ApplicationConfigurationFactory;
import io.jans.service.cdi.async.Asynchronous;
import io.jans.service.cdi.event.BaseConfigurationReload;
import io.jans.service.cdi.event.ConfigurationEvent;
import io.jans.service.cdi.event.ConfigurationUpdate;
import io.jans.service.cdi.event.LdapConfigurationReload;
import io.jans.service.cdi.event.Scheduled;
import io.jans.service.timer.event.TimerEvent;
import io.jans.service.timer.schedule.TimerSchedule;
import io.jans.util.StringHelper;
import io.jans.util.properties.FileConfiguration;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class ConfigurationFactory
extends ApplicationConfigurationFactory {
    public static final String DOCUMENT_STORE_MANAGER_JANS_LOCK_TYPE = "jans-lock";
    @Inject
    private Logger log;
    @Inject
    private Event<TimerEvent> timerEvent;
    @Inject
    private Event<AppConfiguration> configurationUpdateEvent;
    @Inject
    private Event<String> event;
    @Inject
    private Instance<PersistenceEntryManager> persistenceEntryManagerInstance;
    @Inject
    private PersistanceFactoryService persistanceFactoryService;
    @Inject
    private Instance<Configuration> configurationInstance;
    private ErrorResponseFactory errorResponseFactory;
    public static final String PERSISTENCE_CONFIGUARION_RELOAD_EVENT_TYPE = "persistenceConfigurationReloadEvent";
    public static final String BASE_CONFIGUARION_RELOAD_EVENT_TYPE = "baseConfigurationReloadEvent";
    private static final int DEFAULT_INTERVAL = 30;
    private static final String BASE_DIR = System.getProperty("jans.base") != null ? System.getProperty("jans.base") : (System.getProperty("catalina.base") != null && System.getProperty("catalina.base.ignore") == null ? System.getProperty("catalina.base") : (System.getProperty("catalina.home") != null ? System.getProperty("catalina.home") : (System.getProperty("jboss.home.dir") != null ? System.getProperty("jboss.home.dir") : null)));
    private static final String DIR = BASE_DIR + File.separator + "conf" + File.separator;
    private static final String BASE_PROPERTIES_FILE = DIR + "jans.properties";
    private static final String APP_PROPERTIES_FILE = DIR + "jans-lock.properties";
    private final String SALT_FILE_NAME = "salt";
    private String confDir;
    private String saltFilePath;
    private boolean loaded = false;
    private FileConfiguration baseConfiguration;
    private PersistenceConfiguration persistenceConfiguration;
    private AppConfiguration dynamicConf;
    private CedarlingPolicyConfiguration policyConfiguration;
    private StaticConfiguration staticConf;
    private String cryptoConfigurationSalt;
    private AtomicBoolean isActive;
    private AtomicBoolean isInitialized;
    private long baseConfigurationFileLastModifiedTime;
    private long loadedRevision = -1L;
    private boolean loadedFromDB = true;

    @PostConstruct
    public void init() {
        this.log.info("Initializing ConfigurationFactory ...");
        this.isActive = new AtomicBoolean(true);
        this.isInitialized = new AtomicBoolean(false);
        try {
            this.log.info("---------PATH to file configuration: {}", (Object)APP_PROPERTIES_FILE);
            this.persistenceConfiguration = this.persistanceFactoryService.loadPersistenceConfiguration(APP_PROPERTIES_FILE);
            this.loadBaseConfiguration();
            this.confDir = this.confDir();
            String certsDir = this.baseConfiguration.getString("certsDir");
            if (StringHelper.isEmpty((String)certsDir)) {
                certsDir = this.confDir;
            }
            this.saltFilePath = this.confDir + "salt";
            this.loadCryptoConfigurationSalt();
        }
        finally {
            this.isActive.set(false);
        }
    }

    public void initTimer() {
        if (this.isInitialized.compareAndSet(false, true)) {
            this.log.debug("Initializing Configuration Timer");
            int delay = 30;
            int interval = 30;
            this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(30, 30), (Object)new ConfigurationEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
        }
    }

    @Asynchronous
    public void reloadConfigurationTimerEvent(@Observes @Scheduled ConfigurationEvent configurationEvent) {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.reloadConfiguration();
        }
        catch (Throwable ex) {
            this.log.error("Exception happened while reloading application configuration", ex);
        }
        finally {
            this.isActive.set(false);
        }
    }

    private void reloadConfiguration() {
        long lastModified;
        File baseConfiguration;
        PersistenceConfiguration newPersistenceConfiguration = this.persistanceFactoryService.loadPersistenceConfiguration(APP_PROPERTIES_FILE);
        if (!(newPersistenceConfiguration == null || StringHelper.equalsIgnoreCase((String)this.persistenceConfiguration.getFileName(), (String)newPersistenceConfiguration.getFileName()) && newPersistenceConfiguration.getLastModifiedTime() <= this.persistenceConfiguration.getLastModifiedTime())) {
            this.persistenceConfiguration = newPersistenceConfiguration;
            this.event.select(new Annotation[]{LdapConfigurationReload.Literal.INSTANCE}).fire((Object)PERSISTENCE_CONFIGUARION_RELOAD_EVENT_TYPE);
        }
        if ((baseConfiguration = new File(BASE_PROPERTIES_FILE)).exists() && (lastModified = baseConfiguration.lastModified()) > this.baseConfigurationFileLastModifiedTime) {
            this.loadBaseConfiguration();
            this.event.select(new Annotation[]{BaseConfigurationReload.Literal.INSTANCE}).fire((Object)BASE_CONFIGUARION_RELOAD_EVENT_TYPE);
        }
        if (!this.loadedFromDB) {
            return;
        }
        this.reloadConfFromDB();
    }

    private boolean isRevisionIncreased() {
        Conf conf = this.loadConfigurationFromDB("jansRevision");
        if (conf == null) {
            return false;
        }
        this.log.trace("DB revision: " + conf.getRevision() + ", server revision:" + this.loadedRevision);
        return conf.getRevision() > this.loadedRevision;
    }

    private String confDir() {
        String confDir = this.baseConfiguration.getString("confDir", null);
        if (StringUtils.isNotBlank((CharSequence)confDir)) {
            return confDir;
        }
        return DIR;
    }

    public FileConfiguration getBaseConfiguration() {
        return this.baseConfiguration;
    }

    public PersistenceConfiguration getPersistenceConfiguration() {
        return this.persistenceConfiguration;
    }

    @Produces
    @ApplicationScoped
    public AppConfiguration getAppConfiguration() {
        return this.dynamicConf;
    }

    @Produces
    @ApplicationScoped
    public CedarlingPolicyConfiguration getCedarlingPolicy() {
        return this.policyConfiguration;
    }

    @Produces
    @ApplicationScoped
    public StaticConfiguration getStaticConfiguration() {
        return this.staticConf;
    }

    @Produces
    @ApplicationScoped
    public ErrorResponseFactory getFido2ErrorResponseFactory() {
        return this.errorResponseFactory;
    }

    public BaseDnConfiguration getBaseDn() {
        return this.getStaticConfiguration().getBaseDn();
    }

    public String getCryptoConfigurationSalt() {
        return this.cryptoConfigurationSalt;
    }

    public boolean reloadConfFromDB() {
        if (!this.isRevisionIncreased()) {
            return false;
        }
        return this.createFromDB(false);
    }

    protected boolean createFromDB(boolean recoverFromFiles) {
        this.log.info("Loading configuration from '{}' DB...", (Object)this.baseConfiguration.getString("persistence.type"));
        try {
            Conf c = this.loadConfigurationFromDB(new String[0]);
            if (c != null) {
                this.init(c);
                if (this.loaded) {
                    this.destroy(AppConfiguration.class);
                    this.destroy(StaticConfiguration.class);
                    this.destroy(CedarlingPolicyConfiguration.class);
                }
                this.loaded = true;
                this.configurationUpdateEvent.select(new Annotation[]{ConfigurationUpdate.Literal.INSTANCE}).fire((Object)this.dynamicConf);
                return true;
            }
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
        if (recoverFromFiles) {
            this.log.error("Unable to find configuration in DB, load configuration from file system is not implemented... ");
        }
        throw new ConfigurationException("Unable to find configuration in DB... ");
    }

    public void destroy(Class<? extends Configuration> clazz) {
        Instance confInstance = this.configurationInstance.select(clazz, new Annotation[0]);
        this.configurationInstance.destroy((Object)((Configuration)confInstance.get()));
    }

    private Conf loadConfigurationFromDB(String ... returnAttributes) {
        PersistenceEntryManager persistenceEntryManager = (PersistenceEntryManager)this.persistenceEntryManagerInstance.get();
        String dn = this.baseConfiguration.getString("lock_ConfigurationEntryDN");
        try {
            Conf conf = (Conf)persistenceEntryManager.find((Object)dn, Conf.class, returnAttributes);
            return conf;
        }
        catch (BasePersistenceException ex) {
            this.log.error(ex.getMessage());
            return null;
        }
    }

    private void init(Conf conf) {
        this.initConfigurationConf(conf);
        this.loadedRevision = conf.getRevision();
    }

    private void initConfigurationConf(Conf conf) {
        if (conf.getDynamic() != null) {
            this.dynamicConf = conf.getDynamic();
        }
        if (conf.getPolicyConfiguration() != null) {
            this.policyConfiguration = conf.getPolicyConfiguration();
        }
        if (conf.getStatics() != null) {
            this.staticConf = conf.getStatics();
        }
        if (conf.getErrors() != null) {
            this.errorResponseFactory = new ErrorResponseFactory(conf.getErrors(), conf.getDynamic());
        }
    }

    private void loadBaseConfiguration() {
        this.baseConfiguration = this.createFileConfiguration(BASE_PROPERTIES_FILE, true);
        File baseConfiguration = new File(BASE_PROPERTIES_FILE);
        this.baseConfigurationFileLastModifiedTime = baseConfiguration.lastModified();
    }

    public void loadCryptoConfigurationSalt() {
        try {
            FileConfiguration cryptoConfiguration = this.createFileConfiguration(this.saltFilePath, true);
            this.cryptoConfigurationSalt = cryptoConfiguration.getString("encodeSalt");
        }
        catch (Exception ex) {
            this.log.error("Failed to load configuration from {}", (Object)this.saltFilePath, (Object)ex);
            throw new ConfigurationException("Failed to load configuration from " + this.saltFilePath, (Throwable)ex);
        }
    }

    private FileConfiguration createFileConfiguration(String fileName, boolean isMandatory) {
        try {
            FileConfiguration fileConfiguration = new FileConfiguration(fileName);
            return fileConfiguration;
        }
        catch (Exception ex) {
            if (isMandatory) {
                this.log.error("Failed to load configuration from {}", (Object)fileName, (Object)ex);
                throw new ConfigurationException("Failed to load configuration from " + fileName, (Throwable)ex);
            }
            return null;
        }
    }
}

