/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service.stat;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import io.jans.as.model.util.Util;
import io.jans.lock.model.StatEntry;
import io.jans.lock.model.stat.StatResponse;
import io.jans.lock.model.stat.StatResponseItem;
import io.jans.lock.service.stat.StatService;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.search.filter.Filter;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.agkn.hll.HLL;
import org.slf4j.Logger;

@ApplicationScoped
public class StatResponseService {
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager entryManager;
    @Inject
    private StatService statService;
    private final Cache<String, StatResponse> responseCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();

    public StatResponse buildResponse(Set<String> months) {
        String cacheKey = months.toString();
        StatResponse cachedResponse = (StatResponse)this.responseCache.getIfPresent((Object)cacheKey);
        if (cachedResponse != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Get stat response from cache for: {}", (Object)Util.escapeLog((Object)cacheKey));
            }
            return cachedResponse;
        }
        StatResponse response = new StatResponse();
        for (String month : months) {
            StatResponseItem responseItem = this.buildItem(month);
            if (responseItem == null) continue;
            response.getResponse().put(month, responseItem);
        }
        this.responseCache.put((Object)cacheKey, (Object)response);
        return response;
    }

    private StatResponseItem buildItem(String month) {
        try {
            String escapedMonth = Util.escapeLog((Object)month);
            this.log.trace("Trying to fetch stat for month: {}", (Object)escapedMonth);
            List entries = this.entryManager.findEntries(this.statService.getBaseDn(), StatEntry.class, Filter.createEqualityFilter((String)"jansData", (Object)month));
            if (entries == null || entries.isEmpty()) {
                this.log.trace("Can't find stat entries for month: {}", (Object)escapedMonth);
                return null;
            }
            this.log.trace("Fetched stat entries for month {} successfully", (Object)escapedMonth);
            this.checkNotMatchedEntries(month, entries);
            if (entries.isEmpty()) {
                this.log.trace("No stat entries for month: {}", (Object)escapedMonth);
                return null;
            }
            StatResponseItem responseItem = new StatResponseItem();
            responseItem.setMonthlyActiveUsers(this.userCardinality(entries));
            responseItem.setMonthlyActiveClients(this.clientCardinality(entries));
            responseItem.setMonth(month);
            StatResponseService.unionOpearationsMapIntoResponseItem(entries, responseItem);
            return responseItem;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void checkNotMatchedEntries(String month, List<StatEntry> entries) {
        ArrayList notMatched = Lists.newArrayList();
        for (StatEntry entry : entries) {
            if (Objects.equals(month, entry.getMonth())) continue;
            this.log.error("Not matched entry: {}", (Object)entry.getDn());
            notMatched.add(entry);
        }
        entries.removeAll(notMatched);
    }

    private long userCardinality(List<StatEntry> entries) {
        HLL hll = this.decodeUserHll(entries.get(0));
        if (entries.size() > 1) {
            for (int i = 1; i < entries.size(); ++i) {
                hll.union(this.decodeUserHll(entries.get(i)));
            }
        }
        return hll.cardinality();
    }

    private long clientCardinality(List<StatEntry> entries) {
        HLL hll = this.decodeClientHll(entries.get(0));
        if (entries.size() > 1) {
            for (int i = 1; i < entries.size(); ++i) {
                hll.union(this.decodeClientHll(entries.get(i)));
            }
        }
        return hll.cardinality();
    }

    private HLL decodeUserHll(StatEntry entry) {
        try {
            return HLL.fromBytes((byte[])Base64.getDecoder().decode(entry.getUserHllData()));
        }
        catch (Exception e) {
            this.log.error("Failed to decode user HLL data, entry dn: {}, data: {}", (Object)entry.getDn(), (Object)entry.getUserHllData());
            return this.statService.newUserHll();
        }
    }

    private HLL decodeClientHll(StatEntry entry) {
        try {
            return HLL.fromBytes((byte[])Base64.getDecoder().decode(entry.getClientHllData()));
        }
        catch (Exception e) {
            this.log.error("Failed to decode client HLL data, entry dn: {}, data: {}", (Object)entry.getDn(), (Object)entry.getUserHllData());
            return this.statService.newClientHll();
        }
    }

    private static void unionOpearationsMapIntoResponseItem(List<StatEntry> entries, StatResponseItem responseItem) {
        for (StatEntry entry : entries) {
            entry.getStat().getOperationsByType().entrySet().stream().filter(en -> en.getValue() != null).forEach(en -> {
                Map<String, Long> operationMap = responseItem.getOperationsByType().get(en.getKey());
                if (operationMap == null) {
                    responseItem.getOperationsByType().put((String)en.getKey(), (Map)en.getValue());
                    return;
                }
                for (Map.Entry operationEntry : ((Map)en.getValue()).entrySet()) {
                    Long counter = operationMap.get(operationEntry.getKey());
                    if (counter == null) {
                        operationMap.put((String)operationEntry.getKey(), (Long)operationEntry.getValue());
                        continue;
                    }
                    operationMap.put((String)operationEntry.getKey(), counter + (Long)operationEntry.getValue());
                }
            });
        }
    }
}

