/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service.ws.rs.audit;

import io.jans.lock.cedarling.service.security.api.ProtectedCedarlingApi;
import io.jans.lock.model.audit.HealthEntry;
import io.jans.lock.model.audit.LogEntry;
import io.jans.lock.model.audit.TelemetryEntry;
import io.jans.lock.model.core.LockApiError;
import io.jans.service.security.api.ProtectedApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;

@Path(value="/audit")
public interface AuditRestWebService {
    @Operation(summary="Save health data", description="Save health data", tags={"Lock - Audit Health"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/health.write"})})
    @RequestBody(description="Health entry", content={@Content(mediaType="application/json", schema=@Schema(implementation=HealthEntry.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=LockApiError.class, description="BadRequestException"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=LockApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=LockApiError.class, description="InternalServerError"))})})
    @POST
    @Path(value="/health")
    @Produces(value={"application/json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/lock/health.write"})
    @ProtectedCedarlingApi(action="Jans::Action::\"POST\"", resource="Jans::HTTP_Request", id="lock_audit_health_write", path="/audit/health")
    public Response processHealthRequest(@Context HttpServletRequest var1, @Context HttpServletResponse var2, @Context SecurityContext var3);

    @Operation(summary="Bulk save health data", description="Bulk save health data", tags={"Lock - Audit Health"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/health.write"})})
    @RequestBody(description="Bulk health entry", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=HealthEntry.class)))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=LockApiError.class, description="BadRequestException"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=LockApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=LockApiError.class, description="InternalServerError"))})})
    @POST
    @Path(value="/health/bulk")
    @Produces(value={"application/json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/lock/health.write"})
    @ProtectedCedarlingApi(action="Jans::Action::\"POST\"", resource="Jans::HTTP_Request", id="lock_audit_health_write", path="/audit/health")
    public Response processBulkHealthRequest(@Context HttpServletRequest var1, @Context HttpServletResponse var2, @Context SecurityContext var3);

    @Operation(summary="Save log data", description="Save log data", tags={"Lock - Audit Log"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/log.write"})})
    @RequestBody(description="Log entry", content={@Content(mediaType="application/json", schema=@Schema(implementation=LogEntry.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=LockApiError.class, description="BadRequestException"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=LockApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=LockApiError.class, description="InternalServerError"))})})
    @POST
    @Path(value="/log")
    @Produces(value={"application/json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/lock/log.write"})
    @ProtectedCedarlingApi(action="Jans::Action::\"POST\"", resource="Jans::HTTP_Request", id="lock_audit_log_write", path="/audit/log")
    public Response processLogRequest(@Context HttpServletRequest var1, @Context HttpServletResponse var2, @Context SecurityContext var3);

    @Operation(summary="Bulk save log data", description="Bulk save log data", tags={"Lock - Audit Log"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/log.write"})})
    @RequestBody(description="Bulk log entry", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=LogEntry.class)))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=LockApiError.class, description="BadRequestException"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=LockApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=LockApiError.class, description="InternalServerError"))})})
    @POST
    @Path(value="/log/bulk")
    @Produces(value={"application/json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/lock/log.write"})
    @ProtectedCedarlingApi(action="Jans::Action::\"POST\"", resource="Jans::HTTP_Request", id="lock_audit_log_write", path="/audit/log")
    public Response processBulkLogRequest(@Context HttpServletRequest var1, @Context HttpServletResponse var2, @Context SecurityContext var3);

    @Operation(summary="Save telemetry data", description="Save telemetry data", tags={"Lock - Audit Telemetry"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/telemetry.write"})})
    @RequestBody(description="Telemetry entry", content={@Content(mediaType="application/json", schema=@Schema(implementation=TelemetryEntry.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=LockApiError.class, description="BadRequestException"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=LockApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=LockApiError.class, description="InternalServerError"))})})
    @POST
    @Path(value="/telemetry")
    @Produces(value={"application/json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/lock/telemetry.write"})
    @ProtectedCedarlingApi(action="Jans::Action::\"POST\"", resource="Jans::HTTP_Request", id="lock_audit_telemetry_write", path="/audit/telemetry")
    public Response processTelemetryRequest(@Context HttpServletRequest var1, @Context HttpServletResponse var2, @Context SecurityContext var3);

    @Operation(summary="Bulk save telemetry data", description="Bulk save telemetry data", tags={"Lock - Audit Telemetry"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/telemetry.write"})})
    @RequestBody(description="Bulk telemetry entry", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=TelemetryEntry.class)))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=LockApiError.class, description="BadRequestException"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=LockApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=LockApiError.class, description="InternalServerError"))})})
    @POST
    @Path(value="/telemetry/bulk")
    @Produces(value={"application/json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/lock/telemetry.write"})
    @ProtectedCedarlingApi(action="Jans::Action::\"POST\"", resource="Jans::HTTP_Request", id="lock_audit_telemetry_write", path="/audit/telemetry")
    public Response processBulkTelemetryRequest(@Context HttpServletRequest var1, @Context HttpServletResponse var2, @Context SecurityContext var3);
}

