/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service.ws.rs.policy;

import io.jans.lock.cedarling.service.policy.PolicyDownloadService;
import io.jans.lock.model.error.CommonErrorResponseType;
import io.jans.lock.model.error.ErrorResponseFactory;
import io.jans.lock.service.ws.rs.base.BaseResource;
import io.jans.lock.service.ws.rs.policy.PolicyRestWebService;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;

@Dependent
public class PolicyRestWebServiceImpl
extends BaseResource
implements PolicyRestWebService {
    @Inject
    private Logger log;
    @Inject
    private PolicyDownloadService policyDownloadService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;

    @Override
    public Response getPoliciesUriList() {
        Map policies;
        ArrayList uris;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Request policies URI list");
        }
        if ((uris = new ArrayList((policies = this.policyDownloadService.getLoadedPolicies()).keySet())).size() == 0) {
            throw this.errorResponseFactory.notFoundException(CommonErrorResponseType.NOT_FOUND_ERROR, "There is no policies loaded.");
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Policies URIs: {}", uris);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sending policies list");
        }
        return Response.ok().entity(uris).build();
    }

    @Override
    public Response getPolicyByUri(@NotNull String uri) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Request policy by URI: {}", (Object)uri);
        }
        if (StringHelper.isEmpty((String)uri)) {
            throw this.errorResponseFactory.badRequestException(CommonErrorResponseType.INVALID_REQUEST, "URI is not specified");
        }
        Map policies = this.policyDownloadService.getLoadedPolicies();
        if (!policies.containsKey(uri)) {
            throw this.errorResponseFactory.notFoundException(CommonErrorResponseType.NOT_FOUND_ERROR, String.format("There is no policy: %s.", uri));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sending policy response for URI: {}", (Object)uri);
        }
        return Response.ok().entity((Object)((PolicyDownloadService.LoadedPolicySource)policies.get(uri)).getPolicyJson()).build();
    }
}

