/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.ws.rs.core.CacheControl;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerUtil {
    private static final Logger log = LoggerFactory.getLogger(ServerUtil.class);
    public static final String PRAGMA = "Pragma";
    public static final String NO_CACHE = "no-cache";

    public static CacheControl cacheControl(boolean noStore) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoStore(noStore);
        return cacheControl;
    }

    public static CacheControl cacheControl(boolean noStore, boolean noTransform) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoStore(noStore);
        cacheControl.setNoTransform(noTransform);
        return cacheControl;
    }

    public static CacheControl cacheControlWithNoStoreTransformAndPrivate() {
        CacheControl cacheControl = ServerUtil.cacheControl(true, false);
        cacheControl.setPrivate(true);
        return cacheControl;
    }

    public static String asPrettyJson(Object obj) throws IOException {
        ObjectMapper mapper = ServerUtil.createJsonMapper().configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
    }

    public static String asJson(Object obj) throws IOException {
        ObjectMapper mapper = ServerUtil.createJsonMapper().configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        return mapper.writeValueAsString(obj);
    }

    public static ObjectMapper createJsonMapper() {
        JacksonAnnotationIntrospector jackson = new JacksonAnnotationIntrospector();
        ObjectMapper mapper = new ObjectMapper();
        mapper.getDeserializationConfig().with((AnnotationIntrospector)jackson);
        mapper.getSerializationConfig().with((AnnotationIntrospector)jackson);
        return mapper;
    }

    public static ObjectMapper jsonMapperWithWrapRoot() {
        return ServerUtil.createJsonMapper().configure(SerializationFeature.WRAP_ROOT_VALUE, true);
    }

    public static ObjectMapper jsonMapperWithUnwrapRoot() {
        return ServerUtil.createJsonMapper().configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true);
    }

    public static String toPrettyJson(ObjectNode jsonObject) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject);
    }

    public static String urlDecode(String str) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            try {
                return URLDecoder.decode(str, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.trace(e.getMessage(), (Throwable)e);
            }
        }
        return str;
    }
}

