/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service;

import io.jans.lock.model.audit.HealthEntry;
import io.jans.lock.model.audit.LogEntry;
import io.jans.lock.model.audit.TelemetryEntry;
import io.jans.lock.model.config.StaticConfiguration;
import io.jans.orm.PersistenceEntryManager;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.UUID;

@ApplicationScoped
public class AuditService {
    private static final String DN_LOG_FORMAT = "inum=%s,ou=log,%s";
    private static final String DN_TELEMETRY_FORMAT = "inum=%s,ou=telemetry,%s";
    private static final String DN_HEALTH_FORMAT = "inum=%s,ou=health,%s";
    private static final int MAX_IDGEN_TRY_COUNT = 10;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;

    public void addLogEntry(LogEntry logEntry) {
        if (logEntry == null) {
            return;
        }
        String inum = this.generateInumForEntry(DN_LOG_FORMAT, LogEntry.class);
        logEntry.setInum(inum);
        logEntry.setDn(this.getDnForLogEntry(inum));
        this.persistenceEntryManager.persist((Object)logEntry);
    }

    public void addTelemetryEntry(TelemetryEntry telemetryEntry) {
        if (telemetryEntry == null) {
            return;
        }
        String inum = this.generateInumForEntry(DN_TELEMETRY_FORMAT, TelemetryEntry.class);
        telemetryEntry.setInum(inum);
        telemetryEntry.setDn(this.getDnForTelemetryEntry(inum));
        this.persistenceEntryManager.persist((Object)telemetryEntry);
    }

    public void addHealthEntry(HealthEntry healthEntry) {
        if (healthEntry == null) {
            return;
        }
        String inum = this.generateInumForEntry(DN_HEALTH_FORMAT, HealthEntry.class);
        healthEntry.setInum(inum);
        healthEntry.setDn(this.getDnForHealthEntry(inum));
        this.persistenceEntryManager.persist((Object)healthEntry);
    }

    public String getDnForLogEntry(String inum) {
        return String.format(DN_LOG_FORMAT, inum, this.staticConfiguration.getBaseDn().getAudit());
    }

    public String getDnForTelemetryEntry(String inum) {
        return String.format(DN_TELEMETRY_FORMAT, inum, this.staticConfiguration.getBaseDn().getAudit());
    }

    public String getDnForHealthEntry(String inum) {
        return String.format(DN_HEALTH_FORMAT, inum, this.staticConfiguration.getBaseDn().getAudit());
    }

    public String generateInumForEntry(String dnFormat, Class classObj) {
        String baseDn = this.staticConfiguration.getBaseDn().getAudit();
        String newInum = null;
        String newDn = null;
        int try\u0421ount = 0;
        do {
            newInum = this.generateId();
            newDn = String.format(dnFormat, newInum, baseDn);
            boolean found = this.persistenceEntryManager.contains(newDn, classObj);
            if (found) continue;
            return newInum;
        } while (++try\u0421ount < 10);
        return newInum;
    }

    private String generateId() {
        return UUID.randomUUID().toString();
    }
}

