/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service.audit;

import io.jans.as.model.uma.wrapper.Token;
import io.jans.lock.model.AuditEndpointType;
import io.jans.lock.model.config.AppConfiguration;
import io.jans.lock.service.TokenEndpointService;
import io.jans.model.net.HttpServiceResponse;
import io.jans.service.net.BaseHttpService;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class AuditForwarderService {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String AUTHORIZATION = "Authorization";
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private TokenEndpointService tokenEndpointService;
    @Inject
    private BaseHttpService httpService;
    private ExpiringMap<AuditEndpointType, Token> issuedTokens;

    @PostConstruct
    public void init() {
        this.issuedTokens = ExpiringMap.builder().expirationPolicy(ExpirationPolicy.CREATED).variableExpiration().build();
    }

    public String post(Response.ResponseBuilder responseBuilder, AuditEndpointType requestType, String postData, ContentType contentType) {
        this.log.debug("postData - requestType: {}, postData: {}, contentType: {}", new Object[]{requestType, postData, contentType});
        Token token = (Token)this.issuedTokens.get((Object)requestType);
        if (token == null || token.getAccessToken() == null) {
            this.log.info("Generating new token for endpoint {}", (Object)requestType);
            token = this.getTokenForEndpoint(requestType);
            if (token == null || token.getAccessToken() == null) {
                this.log.error("Failed to get token for endpoint {}", (Object)requestType);
                return null;
            }
            this.log.debug("Obtained access token for requestType: {}", (Object)requestType);
            this.issuedTokens.put((Object)requestType, (Object)token, ExpirationPolicy.CREATED, (long)token.getExpiresIn().intValue(), TimeUnit.SECONDS);
        }
        this.log.debug("Sending data to config-api endpoint: {}, data: {}", (Object)requestType, (Object)postData);
        return this.post(responseBuilder, requestType, postData, contentType, token.getAccessToken());
    }

    private Token getTokenForEndpoint(AuditEndpointType requestType) {
        this.log.debug("Attempting to get token for requestType: {}", (Object)requestType);
        Token token = this.tokenEndpointService.getAccessToken(requestType);
        this.log.debug("Get token for requestType: {}, token: {}", (Object)requestType, (Object)token);
        return token;
    }

    public String post(Response.ResponseBuilder responseBuilder, AuditEndpointType requestType, String postData, ContentType contentType, String token) {
        this.log.debug("postData - requestType: {}, postData: {}", (Object)requestType, (Object)postData);
        String endpointUrl = this.getEndpointUrl(requestType);
        this.log.debug("Posting data for - requestType: {}, endpointPath: {},this.getEndpointUrl(endpointPath): {}", new Object[]{requestType, requestType.getPath(), endpointUrl});
        return this.postData(responseBuilder, endpointUrl, null, token, null, contentType, postData);
    }

    private String postData(Response.ResponseBuilder responseBuilder, String url, String authType, String token, Map<String, String> headers, ContentType contentType, String postData) {
        this.log.debug("postData - url: {}, authType: {}, token: {}, headers: {}, contentType: {}, postData: {}", new Object[]{url, authType, token, headers, contentType, postData});
        if (StringUtils.isBlank((CharSequence)authType)) {
            authType = "Bearer ";
        }
        if (contentType == null) {
            contentType = ContentType.APPLICATION_JSON;
        }
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put(CONTENT_TYPE, contentType.toString());
        headers.put(AUTHORIZATION, authType + token);
        HttpServiceResponse response = this.httpService.executePost(url, token, headers, postData, contentType, authType);
        if (response == null || response.getHttpResponse() == null) {
            this.log.error("Get invalid response from config-api URI {}", (Object)url);
            responseBuilder.status(Response.Status.BAD_REQUEST);
            return null;
        }
        this.log.debug("response:{}", (Object)response);
        HttpEntity entity = response.getHttpResponse().getEntity();
        if (response.getHttpResponse() == null || response.getHttpResponse().getEntity() == null) {
            this.log.error("Get invalid response from config-api URI {}", (Object)url);
            responseBuilder.status(Response.Status.BAD_REQUEST);
            return null;
        }
        StatusLine statusLine = response.getHttpResponse().getStatusLine();
        this.log.debug("Get response with statusLine {} from {}", (Object)statusLine, (Object)url);
        if (statusLine.getStatusCode() != 200) {
            this.log.error("Response from {} with status code {} in invalid!", (Object)url, (Object)statusLine.getStatusCode());
            responseBuilder.status(Response.Status.BAD_REQUEST);
            return null;
        }
        String responseStr = null;
        try {
            responseStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (Exception ex) {
            this.log.error("Failed to read response from config-api URI {}", (Object)url, (Object)ex);
            responseBuilder.status(Response.Status.BAD_REQUEST);
        }
        return responseStr;
    }

    private String getEndpointUrl(AuditEndpointType requestType) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.appConfiguration.getOpenIdIssuer());
        sb.append("/");
        sb.append(requestType.getConfigPath());
        this.log.debug("Endpoint: {} configApi endpoint: {}", (Object)requestType, (Object)sb);
        return sb.toString();
    }
}

