/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service.filter;

import io.jans.lock.model.app.audit.AuditActionType;
import io.jans.lock.model.app.audit.AuditLogEntry;
import io.jans.lock.model.config.AppConfiguration;
import io.jans.lock.model.config.LockProtectionMode;
import io.jans.lock.service.app.audit.ApplicationAuditLogger;
import io.jans.lock.service.filter.OpenIdProtection;
import io.jans.net.InetAddressUtility;
import io.jans.service.security.api.ProtectedApi;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.slf4j.Logger;

@ProtectedApi
@Priority(value=1000)
@Dependent
public class AuthorizationProcessingFilter
implements ContainerRequestFilter {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private OpenIdProtection protectionService;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Context
    private HttpHeaders httpHeaders;
    @Context
    private ResourceInfo resourceInfo;
    @Context
    private HttpServletRequest httpRequest;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String path = requestContext.getUriInfo().getPath();
        this.log.debug("REST call to '{}' intercepted", (Object)path);
        if (LockProtectionMode.OAUTH.equals((Object)this.appConfiguration.getProtectionMode()) || this.appConfiguration.getProtectionMode() == null) {
            Response authorizationResponse = this.protectionService.processAuthorization(this.httpHeaders, this.resourceInfo);
            boolean success = authorizationResponse == null;
            AuditLogEntry auditLogEntry = new AuditLogEntry(InetAddressUtility.getIpAddress((HttpServletRequest)this.httpRequest), AuditActionType.OPENID_AUTHZ_FILTER);
            this.applicationAuditLogger.log(auditLogEntry, success);
            if (success) {
                this.log.debug("Authorization passed");
            } else {
                requestContext.abortWith(authorizationResponse);
            }
        }
    }

    private Response unprotectedApiResponse(String name) {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)(name + " API not protected")).build();
    }

    private Response disabledApiResponse(String name) {
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)(name + " API is disabled")).build();
    }
}

