/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service.stat;

import io.jans.lock.model.Stat;
import io.jans.lock.model.StatEntry;
import io.jans.lock.model.config.AppConfiguration;
import io.jans.lock.model.config.StaticConfiguration;
import io.jans.net.InetAddressUtility;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.exception.EntryPersistenceException;
import io.jans.orm.model.base.SimpleBranch;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import net.agkn.hll.HLL;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class StatService {
    private static final String RESULT_ALLOW = "allow";
    private static final String RESULT_DENY = "deny";
    private static final int REGWIDTH = 5;
    private static final int LOG_2_M = 15;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager entryManager;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private AppConfiguration appConfiguration;
    private String nodeId;
    private String monthlyDn;
    private StatEntry currentEntry;
    private HLL userHll;
    private HLL clientHll;
    private ConcurrentMap<String, Map<String, Long>> opearationCounters;
    private final SimpleDateFormat periodDateFormat = new SimpleDateFormat("yyyyMM");
    private boolean initialized = false;
    private final ReentrantLock setupCurrentEntryLock = new ReentrantLock();

    @PostConstruct
    public void create() {
        this.initialized = false;
    }

    public boolean init() {
        try {
            if (!this.appConfiguration.isStatEnabled()) {
                this.log.trace("Stat service is not enabled");
                return false;
            }
            this.log.info("Initializing Stat Service");
            Date now = new Date();
            this.initNodeId(now);
            if (StringUtils.isBlank((CharSequence)this.nodeId)) {
                this.log.error("Failed to initialize stat service. statNodeId is not set in configuration");
                return false;
            }
            if (StringUtils.isBlank((CharSequence)this.getBaseDn())) {
                this.log.error("Failed to initialize stat service. 'stat' base dn is not set in configuration");
                return false;
            }
            this.prepareMonthlyBranch(now);
            this.log.trace("Monthly branch created: {}", (Object)this.monthlyDn);
            this.setupCurrentEntry(now);
            this.log.info("Initialized Stat Service");
            this.initialized = true;
            return true;
        }
        catch (Exception ex) {
            this.log.error("Failed to initialize Stat Service", (Throwable)ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStat() {
        if (!this.initialized) {
            return;
        }
        this.log.trace("Started updateStat ...");
        Date now = new Date();
        this.prepareMonthlyBranch(now);
        this.setupCurrentEntry(now);
        Stat stat = this.currentEntry.getStat();
        stat.setOperationsByType(this.opearationCounters);
        stat.setLastUpdatedAt(now.getTime());
        HLL hLL = this.userHll;
        synchronized (hLL) {
            this.currentEntry.setUserHllData(Base64.getEncoder().encodeToString(this.userHll.toBytes()));
        }
        hLL = this.clientHll;
        synchronized (hLL) {
            this.currentEntry.setClientHllData(Base64.getEncoder().encodeToString(this.clientHll.toBytes()));
        }
        this.entryManager.merge((Object)this.currentEntry);
        this.log.trace("Finished updateStat");
    }

    private void setupCurrentEntry() {
        this.setupCurrentEntry(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupCurrentEntry(Date now) {
        String dn = String.format("jansId=%s,%s", this.nodeId, this.monthlyDn);
        String month = this.monthString(now);
        this.initNodeId(now);
        if (this.currentEntry != null && month.equals(this.currentEntry.getStat().getMonth())) {
            return;
        }
        this.setupCurrentEntryLock.lock();
        try {
            if (this.currentEntry != null && month.equals(this.currentEntry.getStat().getMonth())) {
                return;
            }
            StatEntry entryFromPersistence = (StatEntry)((Object)this.entryManager.find(StatEntry.class, (Object)dn));
            if (entryFromPersistence != null && month.equals(entryFromPersistence.getStat().getMonth())) {
                this.userHll = HLL.fromBytes((byte[])Base64.getDecoder().decode(entryFromPersistence.getUserHllData()));
                this.clientHll = HLL.fromBytes((byte[])Base64.getDecoder().decode(entryFromPersistence.getClientHllData()));
                this.opearationCounters = new ConcurrentHashMap<String, Map<String, Long>>(entryFromPersistence.getStat().getOperationsByType());
                this.currentEntry = entryFromPersistence;
                this.log.trace("Stat entry loaded");
                if (StringUtils.isBlank((CharSequence)this.currentEntry.getMonth()) && this.currentEntry.getStat() != null) {
                    this.currentEntry.setMonth(this.currentEntry.getStat().getMonth());
                }
                return;
            }
        }
        catch (EntryPersistenceException e) {
            this.log.trace("Stat entry is not found in persistence");
        }
        finally {
            this.setupCurrentEntryLock.unlock();
        }
        this.log.trace("Creating stat entry ...");
        this.userHll = this.newUserHll();
        this.clientHll = this.newClientHll();
        this.opearationCounters = new ConcurrentHashMap<String, Map<String, Long>>();
        String monthString = this.periodDateFormat.format(new Date());
        this.currentEntry = new StatEntry();
        this.currentEntry.setId(this.nodeId);
        this.currentEntry.setDn(dn);
        this.currentEntry.setUserHllData(Base64.getEncoder().encodeToString(this.userHll.toBytes()));
        this.currentEntry.setClientHllData(Base64.getEncoder().encodeToString(this.clientHll.toBytes()));
        this.currentEntry.getStat().setMonth(monthString);
        this.currentEntry.setMonth(monthString);
        this.entryManager.persist((Object)this.currentEntry);
        this.log.trace("Created stat entry");
    }

    protected HLL newUserHll() {
        return new HLL(15, 5);
    }

    protected HLL newClientHll() {
        return new HLL(15, 5);
    }

    private void initNodeId(Date now) {
        if (StringUtils.isNotBlank((CharSequence)this.nodeId)) {
            return;
        }
        try {
            this.nodeId = InetAddressUtility.getMACAddressOrNull() + "_" + this.monthString(now);
            if (StringUtils.isNotBlank((CharSequence)this.nodeId)) {
                return;
            }
            this.nodeId = UUID.randomUUID().toString() + "_" + this.monthString(now);
        }
        catch (Exception e) {
            this.log.error("Failed to identify nodeId.", (Throwable)e);
            this.nodeId = UUID.randomUUID().toString() + "_" + this.monthString(now);
        }
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String monthString(Date now) {
        return this.periodDateFormat.format(now);
    }

    private void prepareMonthlyBranch(Date now) {
        String baseDn = this.getBaseDn();
        String month = this.monthString(now);
        this.monthlyDn = String.format("ou=%s,%s", month, baseDn);
        if (!this.entryManager.hasBranchesSupport(baseDn)) {
            return;
        }
        try {
            if (!this.entryManager.contains(this.monthlyDn, SimpleBranch.class)) {
                this.createBranch(this.monthlyDn, month);
            }
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Failed to prepare monthly branch: " + this.monthlyDn, (Throwable)e);
            }
            throw e;
        }
    }

    public String getBaseDn() {
        return this.staticConfiguration.getBaseDn().getStat();
    }

    public void createBranch(String branchDn, String ou) {
        block2: {
            try {
                SimpleBranch branch = new SimpleBranch();
                branch.setOrganizationalUnitName(ou);
                branch.setDn(branchDn);
                this.entryManager.persist((Object)branch);
            }
            catch (EntryPersistenceException ex) {
                if (this.entryManager.contains(branchDn, SimpleBranch.class)) break block2;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportActiveUser(String id) {
        if (!this.initialized) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        int hashCode = id.hashCode();
        try {
            this.setupCurrentEntry();
            HLL hLL = this.userHll;
            synchronized (hLL) {
                this.userHll.addRaw((long)hashCode);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to report active user, id: " + id + ", hash: " + hashCode, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportActiveClient(String id) {
        if (!this.initialized) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        int hashCode = id.hashCode();
        try {
            this.setupCurrentEntry();
            HLL hLL = this.clientHll;
            synchronized (hLL) {
                this.clientHll.addRaw((long)hashCode);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to report active client, id: " + id + ", hash: " + hashCode, (Throwable)e);
        }
    }

    public void reportAllow(String operationGroup) {
        this.reportOpearation(operationGroup, RESULT_ALLOW);
    }

    public void reportDeny(String operationGroup) {
        this.reportOpearation(operationGroup, RESULT_DENY);
    }

    public void reportOpearation(String operationGroup, String operationType) {
        if (!this.initialized) {
            return;
        }
        if (operationGroup == null || operationType == null) {
            return;
        }
        if (this.opearationCounters == null) {
            this.log.error("Stat service is not initialized");
            return;
        }
        Map operationMap = this.opearationCounters.computeIfAbsent(operationGroup, v -> new ConcurrentHashMap());
        Long counter = (Long)operationMap.get(operationType);
        if (counter == null) {
            counter = 1L;
        } else {
            Long l = counter;
            counter = counter + 1L;
        }
        operationMap.put(operationType, counter);
    }
}

