/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service.stat;

import io.jans.lock.model.config.AppConfiguration;
import io.jans.lock.service.event.StatEvent;
import io.jans.lock.service.stat.StatService;
import io.jans.service.cdi.async.Asynchronous;
import io.jans.service.cdi.event.Scheduled;
import io.jans.service.timer.event.TimerEvent;
import io.jans.service.timer.schedule.TimerSchedule;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

@ApplicationScoped
public class StatTimer {
    private static final int TIMER_TICK_INTERVAL_IN_SECONDS = 60;
    private static final int TIMER_INTERVAL_IN_SECONDS = 900;
    @Inject
    private Logger log;
    @Inject
    private Event<TimerEvent> timerEvent;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private StatService statService;
    private AtomicBoolean isActive;
    private long lastFinishedTime;

    @Asynchronous
    public void initTimer() {
        this.log.info("Initializing Stat Service Timer");
        this.isActive = new AtomicBoolean(false);
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(60, 60), (Object)new StatEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
        this.lastFinishedTime = System.currentTimeMillis();
        this.log.info("Initialized Stat Service Timer");
    }

    @Asynchronous
    public void process(@Observes @Scheduled StatEvent event) {
        if (!this.appConfiguration.isStatEnabled()) {
            return;
        }
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            if (!this.allowToRun()) {
                return;
            }
            this.statService.updateStat();
            this.lastFinishedTime = System.currentTimeMillis();
        }
        catch (Exception ex) {
            this.log.error("Exception happened while updating stat", (Throwable)ex);
        }
        finally {
            this.isActive.set(false);
        }
    }

    private boolean allowToRun() {
        int interval = this.appConfiguration.getStatTimerIntervalInSeconds();
        if (interval < 0) {
            this.log.info("Stat Timer is disabled.");
            this.log.warn("Stat Timer Interval (statTimerIntervalInSeconds in server configuration) is negative which turns OFF statistic on the server. Please set it to positive value if you wish it to run.");
            return false;
        }
        if (interval == 0) {
            interval = 900;
        }
        long timerInterval = (long)interval * 1000L;
        long timeDiff = System.currentTimeMillis() - this.lastFinishedTime;
        return timeDiff >= timerInterval;
    }
}

