/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service.ws.rs.audit;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import io.jans.lock.model.AuditEndpointType;
import io.jans.lock.model.app.audit.AuditActionType;
import io.jans.lock.model.app.audit.AuditLogEntry;
import io.jans.lock.model.audit.HealthEntry;
import io.jans.lock.model.audit.LogEntry;
import io.jans.lock.model.audit.TelemetryEntry;
import io.jans.lock.model.config.AppConfiguration;
import io.jans.lock.model.config.AuditPersistenceMode;
import io.jans.lock.service.AuditService;
import io.jans.lock.service.DataMapperService;
import io.jans.lock.service.app.audit.ApplicationAuditLogger;
import io.jans.lock.service.audit.AuditForwarderService;
import io.jans.lock.service.stat.StatService;
import io.jans.lock.service.ws.rs.audit.AuditRestWebService;
import io.jans.lock.service.ws.rs.base.BaseResource;
import io.jans.lock.util.ServerUtil;
import io.jans.net.InetAddressUtility;
import io.jans.service.JsonService;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;

@Dependent
public class AuditRestWebServiceImpl
extends BaseResource
implements AuditRestWebService {
    private static final String LOG_PRINCIPAL_ID = "principalId";
    private static final String LOG_CLIENT_ID = "clientId";
    private static final String LOG_DECISION_RESULT = "decisionResult";
    private static final String LOG_ACTION = "action";
    private static final String LOG_DECISION_RESULT_ALLOW = "allow";
    private static final String LOG_DECISION_RESULT_DENY = "deny";
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private DataMapperService dataMapperService;
    @Inject
    private JsonService jsonService;
    @Inject
    private AuditForwarderService auditForwarderService;
    @Inject
    private AuditService auditService;
    @Inject
    private StatService statService;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response processHealthRequest(HttpServletRequest request, SecurityContext sec) {
        this.log.info("Processing Health request - request: {}", (Object)request);
        AuditLogEntry auditLogEntry = new AuditLogEntry(InetAddressUtility.getIpAddress((HttpServletRequest)request), AuditActionType.AUDIT_HEALTH_WRITE);
        Response response = null;
        try {
            response = this.processAuditRequest(request, AuditEndpointType.HEALTH);
        }
        finally {
            this.applicationAuditLogger.log(auditLogEntry, this.getResponseResult(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response processBulkHealthRequest(HttpServletRequest request, SecurityContext sec) {
        this.log.info("Processing Bulk Health request - request: {}", (Object)request);
        AuditLogEntry auditLogEntry = new AuditLogEntry(InetAddressUtility.getIpAddress((HttpServletRequest)request), AuditActionType.AUDIT_HEALTH_BULK_WRITE);
        Response response = null;
        try {
            response = this.processAuditRequest(request, AuditEndpointType.HEALTH_BULK);
        }
        finally {
            this.applicationAuditLogger.log(auditLogEntry, this.getResponseResult(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response processLogRequest(HttpServletRequest request, SecurityContext sec) {
        this.log.info("Processing Log request - request: {}", (Object)request);
        AuditLogEntry auditLogEntry = new AuditLogEntry(InetAddressUtility.getIpAddress((HttpServletRequest)request), AuditActionType.AUDIT_LOG_WRITE);
        Response response = null;
        try {
            response = this.processAuditRequest(request, AuditEndpointType.LOG, true, false);
        }
        finally {
            this.applicationAuditLogger.log(auditLogEntry, this.getResponseResult(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response processBulkLogRequest(HttpServletRequest request, SecurityContext sec) {
        this.log.info("Processing Bulk Log request - request: {}", (Object)request);
        AuditLogEntry auditLogEntry = new AuditLogEntry(InetAddressUtility.getIpAddress((HttpServletRequest)request), AuditActionType.AUDIT_LOG_BULK_WRITE);
        Response response = null;
        try {
            response = this.processAuditRequest(request, AuditEndpointType.LOG_BULK, true, true);
        }
        finally {
            this.applicationAuditLogger.log(auditLogEntry, this.getResponseResult(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response processTelemetryRequest(HttpServletRequest request, SecurityContext sec) {
        this.log.info("Processing Telemetry request - request: {}", (Object)request);
        AuditLogEntry auditLogEntry = new AuditLogEntry(InetAddressUtility.getIpAddress((HttpServletRequest)request), AuditActionType.AUDIT_TELEMETRY_WRITE);
        Response response = null;
        try {
            response = this.processAuditRequest(request, AuditEndpointType.TELEMETRY);
        }
        finally {
            this.applicationAuditLogger.log(auditLogEntry, this.getResponseResult(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response processBulkTelemetryRequest(HttpServletRequest request, SecurityContext sec) {
        this.log.info("Processing Bulk Telemetry request - request: {}", (Object)request);
        AuditLogEntry auditLogEntry = new AuditLogEntry(InetAddressUtility.getIpAddress((HttpServletRequest)request), AuditActionType.AUDIT_TELEMETRY_BULK_WRITE);
        Response response = null;
        try {
            response = this.processAuditRequest(request, AuditEndpointType.TELEMETRY_BULK);
        }
        finally {
            this.applicationAuditLogger.log(auditLogEntry, this.getResponseResult(response));
        }
        return response;
    }

    private Response processAuditRequest(HttpServletRequest request, AuditEndpointType requestType) {
        return this.processAuditRequest(request, requestType, false, false);
    }

    private Response processAuditRequest(HttpServletRequest request, AuditEndpointType requestType, boolean reportStat, boolean bulkData) {
        this.log.info("Processing request - request: {}, requestType: {}", (Object)request, (Object)requestType);
        JsonNode json = this.getJsonNode(request);
        if (json == null) {
            AuditRestWebServiceImpl.throwBadRequestException("Failed to parse request");
        }
        if (reportStat) {
            if (bulkData) {
                this.reportBulkStat(json);
            } else {
                this.reportStat(json);
            }
        }
        Response.ResponseBuilder builder = Response.ok();
        String response = AuditPersistenceMode.CONFIG_API.equals((Object)this.appConfiguration.getAuditPersistenceMode()) ? this.auditForwarderService.post(builder, requestType, json.toString(), ContentType.APPLICATION_JSON) : this.persistetAuditData(builder, requestType, json.toString());
        builder.cacheControl(ServerUtil.cacheControlWithNoStoreTransformAndPrivate());
        builder.header("Pragma", (Object)"no-cache");
        builder.entity((Object)response);
        this.log.debug("Response entity: {}", (Object)response);
        return builder.build();
    }

    private JsonNode getJsonNode(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        JsonNode jsonBody = null;
        try {
            jsonBody = this.dataMapperService.readTree((InputStream)request.getInputStream());
            this.log.debug("Parsed request body data: {}", (Object)jsonBody);
        }
        catch (Exception ex) {
            this.log.error("Failed to parse request", (Throwable)ex);
        }
        return jsonBody;
    }

    private void reportStat(JsonNode json) {
        boolean hasAction;
        boolean has\u0412ecisionResult;
        boolean hasPrincipalId;
        boolean hasClientId = json.hasNonNull(LOG_CLIENT_ID);
        if (hasClientId) {
            this.statService.reportActiveClient(json.get(LOG_CLIENT_ID).asText());
        }
        if (hasPrincipalId = json.hasNonNull(LOG_PRINCIPAL_ID)) {
            this.statService.reportActiveUser(json.get(LOG_PRINCIPAL_ID).asText());
        }
        if (has\u0412ecisionResult = json.hasNonNull(LOG_DECISION_RESULT)) {
            String decisionResult = json.get(LOG_DECISION_RESULT).asText();
            if (LOG_DECISION_RESULT_ALLOW.equals(decisionResult)) {
                this.statService.reportAllow(LOG_DECISION_RESULT);
            } else if (LOG_DECISION_RESULT_DENY.equals(decisionResult)) {
                this.statService.reportDeny(LOG_DECISION_RESULT);
            }
        }
        if (hasAction = json.hasNonNull(LOG_ACTION)) {
            this.statService.reportOpearation(LOG_ACTION, json.get(LOG_ACTION).asText());
        }
    }

    private void reportBulkStat(JsonNode json) {
        if (!json.isArray()) {
            this.log.error("Failed to calculate stat for bulk log entry: {}", (Object)json);
        }
        for (JsonNode jsonItem : json) {
            this.reportStat(jsonItem);
        }
    }

    private String persistetAuditData(Response.ResponseBuilder builder, AuditEndpointType requestType, String json) {
        try {
            switch (requestType) {
                case LOG: {
                    LogEntry logEntry = (LogEntry)this.jsonService.jsonToObject(json, LogEntry.class);
                    this.auditService.addLogEntry(logEntry);
                    break;
                }
                case LOG_BULK: {
                    List logEntries = (List)this.jsonService.jsonToObject(json, (JavaType)this.jsonService.getTypeFactory().constructCollectionType(List.class, LogEntry.class));
                    for (LogEntry entry : logEntries) {
                        this.auditService.addLogEntry(entry);
                    }
                    break;
                }
                case HEALTH: {
                    HealthEntry healthEntry = (HealthEntry)this.jsonService.jsonToObject(json, HealthEntry.class);
                    this.auditService.addHealthEntry(healthEntry);
                    break;
                }
                case HEALTH_BULK: {
                    List healthEntries = (List)this.jsonService.jsonToObject(json, (JavaType)this.jsonService.getTypeFactory().constructCollectionType(List.class, HealthEntry.class));
                    for (HealthEntry entry : healthEntries) {
                        this.auditService.addHealthEntry(entry);
                    }
                    break;
                }
                case TELEMETRY: {
                    TelemetryEntry telemetryEntry = (TelemetryEntry)this.jsonService.jsonToObject(json, TelemetryEntry.class);
                    this.auditService.addTelemetryEntry(telemetryEntry);
                    break;
                }
                case TELEMETRY_BULK: {
                    List telemetryEntries = (List)this.jsonService.jsonToObject(json, (JavaType)this.jsonService.getTypeFactory().constructCollectionType(List.class, TelemetryEntry.class));
                    for (TelemetryEntry entry : telemetryEntries) {
                        this.auditService.addTelemetryEntry(entry);
                    }
                    break;
                }
            }
        }
        catch (IOException ex) {
            builder.status(Response.Status.BAD_REQUEST);
            this.log.warn("Failed to parse data", (Throwable)ex);
            return "Failed to parse data";
        }
        catch (Exception ex) {
            builder.status(Response.Status.INTERNAL_SERVER_ERROR);
            this.log.error("Failed to persist audit data", (Throwable)ex);
            return "Failed to persist data";
        }
        return "";
    }
}

