/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service.ws.rs.policy;

import io.jans.lock.cedarling.service.security.api.ProtectedCedarlingApi;
import io.jans.lock.model.core.LockApiError;
import io.jans.service.security.api.ProtectedApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.enterprise.context.Dependent;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Dependent
@Path(value="/policy")
public interface PolicyRestWebService {
    @Operation(summary="Request policies URI list", description="Request policies URI list", tags={"Lock - Policy"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/policy.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class, description="PolicyFound"))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=LockApiError.class, description="BadRequestException"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=LockApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=LockApiError.class, description="InternalServerError"))})})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/lock/policy.readonly"})
    @ProtectedCedarlingApi(action="Jans::Action::\"GET\"", resource="Jans::HTTP_Request", id="lock_policy_list", path="/policy")
    @Produces(value={"application/json"})
    public Response getPoliciesUriList();

    @Operation(summary="Request policy data", description="Request policy data", tags={"Lock - Policy"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/policy.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class, description="PolicyFound"))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=LockApiError.class, description="BadRequestException"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=LockApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=LockApiError.class, description="InternalServerError"))})})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/lock/policy.readonly"})
    @ProtectedCedarlingApi(action="Jans::Action::\"GET\"", resource="Jans::HTTP_Request", id="lock_policy_get_by_id", path="/policy")
    @Produces(value={"application/json"})
    @Path(value="{uri}")
    public Response getPolicyByUri(@Parameter(description="Policy URI") @PathParam(value="uri") @NotNull String var1);
}

