/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service.ws.rs.policy;

import io.jans.lock.cedarling.service.policy.PolicyDownloadService;
import io.jans.lock.model.app.audit.AuditActionType;
import io.jans.lock.model.app.audit.AuditLogEntry;
import io.jans.lock.model.error.CommonErrorResponseType;
import io.jans.lock.model.error.ErrorResponseFactory;
import io.jans.lock.service.app.audit.ApplicationAuditLogger;
import io.jans.lock.service.ws.rs.base.BaseResource;
import io.jans.lock.service.ws.rs.policy.PolicyRestWebService;
import io.jans.net.InetAddressUtility;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;

@Dependent
public class PolicyRestWebServiceImpl
extends BaseResource
implements PolicyRestWebService {
    @Inject
    private Logger log;
    @Inject
    private PolicyDownloadService policyDownloadService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response getPoliciesUriList() {
        AuditLogEntry auditLogEntry = new AuditLogEntry(InetAddressUtility.getIpAddress((HttpServletRequest)this.getHttpRequest()), AuditActionType.POLICIES_URI_LIST_READ);
        Response response = null;
        try {
            Map policies;
            ArrayList uris;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Request policies URI list");
            }
            if ((uris = new ArrayList((policies = this.policyDownloadService.getLoadedPolicies()).keySet())).size() == 0) {
                throw this.errorResponseFactory.notFoundException(CommonErrorResponseType.NOT_FOUND_ERROR, "There is no policies loaded.");
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Policies URIs: {}", uris);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sending policies list");
            }
            Response response2 = response = Response.ok().entity(uris).build();
            this.applicationAuditLogger.log(auditLogEntry, this.getResponseResult(response));
            return response2;
        }
        catch (Throwable throwable) {
            this.applicationAuditLogger.log(auditLogEntry, this.getResponseResult(response));
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response getPolicyByUri(@NotNull String uri) {
        AuditLogEntry auditLogEntry = new AuditLogEntry(InetAddressUtility.getIpAddress((HttpServletRequest)this.getHttpRequest()), AuditActionType.POLICY_BY_URI_READ);
        Response response = null;
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Request policy by URI: {}", (Object)uri);
            }
            if (StringHelper.isEmpty((String)uri)) {
                throw this.errorResponseFactory.badRequestException(CommonErrorResponseType.INVALID_REQUEST, "URI is not specified");
            }
            Map policies = this.policyDownloadService.getLoadedPolicies();
            if (!policies.containsKey(uri)) {
                throw this.errorResponseFactory.notFoundException(CommonErrorResponseType.NOT_FOUND_ERROR, String.format("There is no policy: %s.", uri));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sending policy response for URI: {}", (Object)uri);
            }
            Response response2 = response = Response.ok().entity((Object)((PolicyDownloadService.LoadedPolicySource)policies.get(uri)).getPolicyJson()).build();
            this.applicationAuditLogger.log(auditLogEntry, this.getResponseResult(response));
            return response2;
        }
        catch (Throwable throwable) {
            this.applicationAuditLogger.log(auditLogEntry, this.getResponseResult(response));
            throw throwable;
        }
    }
}

