/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service.ws.rs.stat;

import io.jans.as.model.util.Util;
import io.jans.lock.model.app.audit.AuditActionType;
import io.jans.lock.model.app.audit.AuditLogEntry;
import io.jans.lock.model.config.AppConfiguration;
import io.jans.lock.model.error.ErrorResponseFactory;
import io.jans.lock.model.error.StatErrorResponseType;
import io.jans.lock.model.stat.FlatStatResponse;
import io.jans.lock.model.stat.Months;
import io.jans.lock.model.stat.StatResponse;
import io.jans.lock.model.stat.StatResponseItem;
import io.jans.lock.service.app.audit.ApplicationAuditLogger;
import io.jans.lock.service.stat.StatResponseService;
import io.jans.lock.service.ws.rs.base.BaseResource;
import io.jans.lock.service.ws.rs.stat.StatRestWebService;
import io.jans.lock.util.ServerUtil;
import io.jans.net.InetAddressUtility;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.exporter.common.TextFormat;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

@Dependent
public class StatRestWebServiceImpl
extends BaseResource
implements StatRestWebService {
    @Inject
    private Logger log;
    @Inject
    private StatResponseService statResponseService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response statGet(@Context HttpServletRequest request, @QueryParam(value="month") String months, @QueryParam(value="start-month") String startMonth, @QueryParam(value="end-month") String endMonth, @QueryParam(value="format") String format) {
        AuditLogEntry auditLogEntry = new AuditLogEntry(InetAddressUtility.getIpAddress((HttpServletRequest)request), AuditActionType.SSA_READ);
        Response response = null;
        try {
            response = this.stat(months, startMonth, endMonth, format);
        }
        finally {
            this.applicationAuditLogger.log(auditLogEntry, this.getResponseResult(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response statPost(@Context HttpServletRequest request, @FormParam(value="month") String months, @FormParam(value="start-month") String startMonth, @FormParam(value="end-month") String endMonth, @FormParam(value="format") String format) {
        AuditLogEntry auditLogEntry = new AuditLogEntry(InetAddressUtility.getIpAddress((HttpServletRequest)request), AuditActionType.SSA_READ);
        Response response = null;
        try {
            response = this.stat(months, startMonth, endMonth, format);
        }
        finally {
            this.applicationAuditLogger.log(auditLogEntry, this.getResponseResult(response));
        }
        return response;
    }

    public static String createOpenMetricsResponse(StatResponse statResponse) throws IOException {
        StringWriter writer = new StringWriter();
        CollectorRegistry registry = new CollectorRegistry();
        Counter usersCounter = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("monthly_active_users")).labelNames(new String[]{"month"})).help("Monthly active users")).register(registry);
        Counter clientsCounter = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("monthly_active_clients")).labelNames(new String[]{"month"})).help("Monthly active clients")).register(registry);
        HashMap<String, Counter> counterMap = new HashMap<String, Counter>();
        for (Map.Entry<String, StatResponseItem> entry : statResponse.getResponse().entrySet()) {
            String month = entry.getKey();
            StatResponseItem item = entry.getValue();
            ((Counter.Child)usersCounter.labels(new String[]{month})).inc((double)item.getMonthlyActiveUsers());
            ((Counter.Child)clientsCounter.labels(new String[]{month})).inc((double)item.getMonthlyActiveClients());
            for (Map.Entry<String, Map<String, Long>> operationTypeEntry : item.getOperationsByType().entrySet()) {
                String operationType = operationTypeEntry.getKey();
                Map<String, Long> operationTypeMap = operationTypeEntry.getValue();
                for (Map.Entry<String, Long> operationEntry : operationTypeMap.entrySet()) {
                    Counter operationCounter;
                    String operation = operationEntry.getKey();
                    if (counterMap.containsKey(operationType)) {
                        operationCounter = (Counter)counterMap.get(operationType);
                    } else {
                        operationCounter = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name(operationType)).labelNames(new String[]{"month", "decision"})).help(operationType)).register(registry);
                        counterMap.put(operationType, operationCounter);
                    }
                    ((Counter.Child)operationCounter.labels(new String[]{month, operation})).inc((double)StatRestWebServiceImpl.getOperationCount(operationTypeMap, operation));
                }
            }
        }
        TextFormat.write004((Writer)writer, (Enumeration)registry.metricFamilySamples());
        return ((Object)writer).toString();
    }

    private static long getOperationCount(Map<String, Long> map, String key) {
        Long v = map.get(key);
        return v != null ? v : 0L;
    }

    public Response stat(String monthsParam, String startMonth, String endMonth, String format) {
        if (!this.appConfiguration.isStatEnabled()) {
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.FORBIDDEN, StatErrorResponseType.ACCESS_DENIED, "Future stat is disabled on server.");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Attempting to request stat, month: {}, startMonth: {}, endMonth: {}, format: {}", new Object[]{Util.escapeLog((Object)monthsParam), Util.escapeLog((Object)startMonth), Util.escapeLog((Object)endMonth), Util.escapeLog((Object)format)});
        }
        Set<String> months = this.validateMonths(monthsParam, startMonth, endMonth);
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Recognized months: {}", (Object)Util.escapeLog(months));
            }
            StatResponse statResponse = this.statResponseService.buildResponse(months);
            String responseAsStr = "openmetrics".equalsIgnoreCase(format) ? StatRestWebServiceImpl.createOpenMetricsResponse(statResponse) : ("jsonmonth".equalsIgnoreCase(format) ? ServerUtil.asJson(statResponse) : ServerUtil.asJson(new FlatStatResponse(new ArrayList<StatResponseItem>(statResponse.getResponse().values()))));
            if (this.log.isTraceEnabled()) {
                this.log.trace("Stat: {}", (Object)responseAsStr);
            }
            return Response.ok().entity((Object)responseAsStr).build();
        }
        catch (WebApplicationException e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, StatErrorResponseType.ACCESS_DENIED, "Server server.");
        }
    }

    private Set<String> validateMonths(String months, String startMonth, String endMonth) {
        if (!Months.isValid(months, startMonth, endMonth)) {
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, StatErrorResponseType.INVALID_REQUEST, "`month` or `start-month`/`end-month` parameter(s) can't be blank and should be in format yyyyMM (e.g. 202012)");
        }
        Set<String> monthList = Months.getMonths(months = ServerUtil.urlDecode(months), startMonth, endMonth);
        if (monthList.isEmpty()) {
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, StatErrorResponseType.INVALID_REQUEST, "Unable to identify months. Check `month` or `start-month`/`end-month` parameter(s). It can't be blank and should be in format yyyyMM (e.g. 202012). start-month must be before end-month");
        }
        return monthList;
    }
}

