/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service.ws.rs;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.jans.lock.model.app.audit.AuditActionType;
import io.jans.lock.model.app.audit.AuditLogEntry;
import io.jans.lock.model.core.LockApiError;
import io.jans.lock.service.app.audit.ApplicationAuditLogger;
import io.jans.lock.service.config.ConfigurationService;
import io.jans.lock.service.ws.rs.base.BaseResource;
import io.jans.net.InetAddressUtility;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@Dependent
@Path(value="/configuration")
public class ConfigurationRestWebService
extends BaseResource {
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Request .well-known data", description="Request .well-know Lock server configuration", tags={"Lock - Server Configuration"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class, description="ConfigurationFound"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=LockApiError.class, description="InternalServerError"))})})
    @GET
    @Produces(value={"application/json"})
    public Response getConfiguration(@Context HttpServletRequest request) {
        AuditLogEntry auditLogEntry = new AuditLogEntry(InetAddressUtility.getIpAddress((HttpServletRequest)request), AuditActionType.CONFIGURATION_READ);
        boolean success = false;
        try {
            ObjectNode response = this.configurationService.getLockConfiguration();
            Response.ResponseBuilder builder = Response.ok().entity((Object)response.toString());
            success = true;
            Response response2 = builder.build();
            return response2;
        }
        finally {
            this.applicationAuditLogger.log(auditLogEntry, success);
        }
    }
}

