/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.slf4j.Logger;

@ApplicationScoped
public class DataMapperService {
    @Inject
    private Logger log;
    private ObjectMapper objectMapper;
    private ObjectMapper jaxbObjectMapper;
    private ObjectMapper cborObjectMapper;

    @PostConstruct
    public void init() {
        this.objectMapper = new ObjectMapper();
        this.jaxbObjectMapper = this.jsonMapperWithWrapRoot();
    }

    public JsonNode readTree(byte[] content) throws IOException {
        return this.objectMapper.readTree(content);
    }

    public JsonNode readTree(String content) throws IOException {
        return this.objectMapper.readTree(content);
    }

    public JsonNode readTree(InputStream in) throws IOException {
        return this.objectMapper.readTree(in);
    }

    public JsonNode readTree(BufferedReader reader) throws IOException {
        return this.objectMapper.readTree((Reader)reader);
    }

    public <T> T readValue(String content, Class<T> clazz) throws IOException {
        return (T)this.jaxbObjectMapper.readValue(content, clazz);
    }

    public ObjectNode createObjectNode() {
        return this.objectMapper.createObjectNode();
    }

    public ArrayNode createArrayNode() {
        return this.objectMapper.createArrayNode();
    }

    public JsonNode cborReadTree(byte[] content) throws IOException {
        return this.cborObjectMapper.readTree(content);
    }

    public byte[] cborWriteAsBytes(JsonNode jsonNode) throws IOException {
        return this.cborObjectMapper.writeValueAsBytes((Object)jsonNode);
    }

    public <T> T convertValue(Object fromValue, Class<T> toValueType) {
        return (T)this.objectMapper.convertValue(fromValue, toValueType);
    }

    public String writeValueAsString(Object value) throws JsonProcessingException {
        return this.objectMapper.writeValueAsString(value);
    }

    public <T> T readValueString(String content, Class<T> clazz) throws JsonProcessingException {
        return (T)this.objectMapper.readValue(content, clazz);
    }

    private ObjectMapper createJsonMapperWithJaxb() {
        ObjectMapper mapper = new ObjectMapper();
        return mapper;
    }

    private ObjectMapper jsonMapperWithWrapRoot() {
        return this.createJsonMapperWithJaxb().configure(SerializationFeature.WRAP_ROOT_VALUE, true);
    }
}

