/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service;

import io.jans.as.client.TokenClient;
import io.jans.as.client.TokenResponse;
import io.jans.as.model.common.ScopeType;
import io.jans.as.model.uma.wrapper.Token;
import io.jans.as.model.util.Util;
import io.jans.lock.model.AuditEndpointType;
import io.jans.lock.model.config.AppConfiguration;
import io.jans.lock.service.OpenIdService;
import io.jans.model.net.HttpServiceResponse;
import io.jans.service.EncryptionService;
import io.jans.util.security.StringEncrypter;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;

@ApplicationScoped
public class TokenEndpointService {
    @Inject
    Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private OpenIdService openIdService;
    @Inject
    private EncryptionService encryptionService;

    public Token getAccessToken(AuditEndpointType requestType) {
        this.log.debug("Request for token for requestType: {}", (Object)requestType);
        String clientId = this.appConfiguration.getClientId();
        String clientSecret = this.getDecryptedPassword(this.appConfiguration.getClientPassword());
        String scopes = this.getScopesForToken(requestType);
        this.log.debug("Scopes for requestType: {}, scopes:{}", (Object)requestType, (Object)scopes);
        return this.getToken(this.openIdService.getOpenIdConfiguration().getTokenEndpoint(), clientId, clientSecret, scopes);
    }

    public Token getToken(String tokenUrl, String clientId, String clientSecret, String scopes) {
        this.log.debug("Request for token tokenUrl:{}, clientId:{},scopes:{}", new Object[]{tokenUrl, clientId, scopes});
        Token token = null;
        TokenResponse tokenResponse = this.requestAccessToken(tokenUrl, clientId, clientSecret, scopes);
        if (tokenResponse != null) {
            String accessToken = tokenResponse.getAccessToken();
            Integer expiresIn = tokenResponse.getExpiresIn();
            this.log.trace("accessToken:{}, expiresIn:{}", (Object)accessToken, (Object)expiresIn);
            if (Util.allNotBlank((String[])new String[]{accessToken})) {
                return new Token(null, null, accessToken, ScopeType.OPENID.getValue(), expiresIn);
            }
        }
        return token;
    }

    public TokenResponse requestAccessToken(String tokenUrl, String clientId, String clientSecret, String scope) {
        this.log.debug("Request for access token tokenUrl:{}, clientId:{},scope:{}", new Object[]{tokenUrl, clientId, scope});
        TokenClient tokenClient = new TokenClient(tokenUrl);
        TokenResponse tokenResponse = tokenClient.execClientCredentialsGrant(scope, clientId, clientSecret);
        this.log.trace("Response for Access Token -  tokenResponse: {}", (Object)tokenResponse);
        if (tokenResponse == null || tokenResponse.getStatus() != 200) {
            this.log.error("Failed to get access token with scopes: {}", (Object)scope);
            return null;
        }
        return tokenResponse;
    }

    public Response.Status getResponseStatus(HttpServiceResponse serviceResponse) {
        Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
        if (serviceResponse == null || serviceResponse.getHttpResponse() == null) {
            return status;
        }
        int statusCode = serviceResponse.getHttpResponse().getStatusLine().getStatusCode();
        status = Response.Status.fromStatusCode((int)statusCode);
        if (status == null) {
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return status;
    }

    public String getDecryptedPassword(String clientPassword) {
        String decryptedPassword = null;
        if (clientPassword != null) {
            try {
                decryptedPassword = this.encryptionService.decrypt(clientPassword);
            }
            catch (StringEncrypter.EncryptionException ex) {
                this.log.error("Failed to decrypt password", (Throwable)ex);
            }
        }
        return decryptedPassword;
    }

    private String getScopesForToken(AuditEndpointType requestType) {
        this.log.debug("Build scopes for requestType: {}", (Object)requestType);
        StringBuilder sb = new StringBuilder();
        sb.append(ScopeType.OPENID.getValue());
        for (String scope : requestType.getScopes()) {
            sb.append(" ").append(scope);
        }
        return sb.toString();
    }
}

