/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service;

import io.jans.as.client.JwkClient;
import io.jans.as.client.OpenIdConfigurationResponse;
import io.jans.as.client.StatusListClient;
import io.jans.as.client.StatusListRequest;
import io.jans.as.client.StatusListResponse;
import io.jans.as.model.crypto.signature.AlgorithmFamily;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.jws.ECDSASigner;
import io.jans.as.model.jws.RSASigner;
import io.jans.as.model.jwt.Jwt;
import io.jans.lock.service.OpenIdService;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.slf4j.Logger;

@ApplicationScoped
public class TokenStatusListService {
    public static final String CONTENT_TYPE_STATUSLIST_JSON = "application/statuslist+json";
    public static final String CONTENT_TYPE_STATUSLIST_JWT = "application/statuslist+jwt";
    @Inject
    private Logger log;
    @Inject
    private OpenIdService openIdService;

    public StatusListResponse loadTokenStatusList() {
        RSASigner jwtSigner;
        OpenIdConfigurationResponse openIdConfiguration = this.openIdService.getOpenIdConfiguration();
        this.log.debug("Loaded OpenIdConfiguration: {}", (Object)openIdConfiguration);
        StatusListResponse statusListResponse = this.requestTokenStatusList(openIdConfiguration.getStatusListEndpoint());
        if (statusListResponse == null) {
            return null;
        }
        Jwt jwt = statusListResponse.getJwt();
        SignatureAlgorithm signatureAlg = jwt.getHeader().getSignatureAlgorithm();
        AlgorithmFamily algFamily = signatureAlg.getFamily();
        if (AlgorithmFamily.RSA == algFamily) {
            jwtSigner = new RSASigner(signatureAlg, JwkClient.getRSAPublicKey((String)openIdConfiguration.getJwksUri(), (String)jwt.getHeader().getClaimAsString("kid")));
        } else if (AlgorithmFamily.EC == algFamily) {
            jwtSigner = new ECDSASigner(signatureAlg, JwkClient.getECDSAPublicKey((String)openIdConfiguration.getJwksUri(), (String)jwt.getHeader().getClaimAsString("kid")));
        } else {
            this.log.error("Unsupported signature algorithm family: '{}'", (Object)algFamily);
            return null;
        }
        boolean isValid = jwtSigner.validate(jwt);
        if (!isValid) {
            this.log.error("Token status list JWT signature is invalid");
            return null;
        }
        return statusListResponse;
    }

    private StatusListResponse requestTokenStatusList(String statusListEndpoint) {
        StatusListClient statusListClient = new StatusListClient(statusListEndpoint);
        StatusListRequest statusListRequest = new StatusListRequest();
        StatusListResponse statusListResponse = statusListClient.exec(statusListRequest);
        if (statusListResponse.getStatus() != 200) {
            this.log.debug("Faield to load token status list");
            return null;
        }
        return statusListResponse;
    }
}

