/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.model.error;

import io.jans.as.model.configuration.Configuration;
import io.jans.as.model.error.DefaultErrorResponse;
import io.jans.as.model.error.IErrorType;
import io.jans.lock.model.config.AppConfiguration;
import io.jans.lock.model.config.ErrorMessages;
import io.jans.lock.model.error.CommonErrorResponseType;
import io.jans.lock.model.error.StatErrorResponseType;
import io.jans.model.error.ErrorMessage;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorResponseFactory
implements Configuration {
    private static final Logger log = LoggerFactory.getLogger(ErrorResponseFactory.class);
    private ErrorMessages messages;
    private AppConfiguration appConfiguration;

    public ErrorResponseFactory() {
    }

    public ErrorResponseFactory(ErrorMessages messages, AppConfiguration appConfiguration) {
        this.messages = messages;
        this.appConfiguration = appConfiguration;
    }

    public WebApplicationException createWebApplicationException(Response.Status status, IErrorType type, String reason) {
        return this.createWebApplicationException(status, type, reason, null);
    }

    private WebApplicationException createWebApplicationException(Response.Status status, IErrorType type, String reason, Throwable e) {
        WebApplicationException error = new WebApplicationException(Response.status((Response.Status)status).entity((Object)this.errorAsJson(type, reason)).type(MediaType.APPLICATION_JSON_TYPE).build());
        if (log.isErrorEnabled()) {
            log.error("Exception Handle, status: {}, body: {}", new Object[]{this.formatStatus(error.getResponse().getStatusInfo()), error.getResponse().getEntity(), e});
        }
        return error;
    }

    public WebApplicationException badRequestException(IErrorType type, String reason) {
        return this.createWebApplicationException(Response.Status.BAD_REQUEST, type, reason);
    }

    public WebApplicationException badRequestException(IErrorType type, String reason, Throwable e) {
        return this.createWebApplicationException(Response.Status.BAD_REQUEST, type, reason, e);
    }

    public WebApplicationException notFoundException(IErrorType type, String reason) {
        return this.createWebApplicationException(Response.Status.NOT_FOUND, type, reason);
    }

    public WebApplicationException forbiddenException() {
        WebApplicationException error = new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"").build());
        if (log.isErrorEnabled()) {
            log.error("Exception Handle, status: {}", (Object)this.formatStatus(error.getResponse().getStatusInfo()));
        }
        return error;
    }

    public WebApplicationException invalidRequest(String reason) {
        return this.createWebApplicationException(Response.Status.BAD_REQUEST, CommonErrorResponseType.INVALID_REQUEST, reason);
    }

    public WebApplicationException invalidRequest(String reason, Throwable e) {
        return this.createWebApplicationException(Response.Status.BAD_REQUEST, CommonErrorResponseType.INVALID_REQUEST, reason, e);
    }

    public WebApplicationException unknownError(String reason) {
        throw this.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, CommonErrorResponseType.UNKNOWN_ERROR, reason);
    }

    private String errorAsJson(IErrorType type, String reason) {
        DefaultErrorResponse error = this.getErrorResponse(type);
        error.setReason(BooleanUtils.isTrue((Boolean)this.appConfiguration.getErrorReasonEnabled()) ? reason : "");
        return error.toJSonString();
    }

    private DefaultErrorResponse getErrorResponse(IErrorType type) {
        DefaultErrorResponse response = new DefaultErrorResponse();
        response.setType(type);
        if (type != null && this.messages != null) {
            List list = null;
            if (type instanceof CommonErrorResponseType) {
                list = this.messages.getCommon();
            } else if (type instanceof StatErrorResponseType) {
                list = this.messages.getStat();
            }
            if (list != null) {
                ErrorMessage m = this.getError(list, type);
                String description = Optional.ofNullable(ThreadContext.get((String)"X-Correlation-Id")).map(id -> m.getDescription().concat(" CorrelationId: " + id)).orElse(m.getDescription());
                response.setErrorDescription(description);
                response.setErrorUri(m.getUri());
            }
        }
        return response;
    }

    private ErrorMessage getError(List<ErrorMessage> list, IErrorType type) {
        log.debug("Looking for the error with id: {}", (Object)type);
        if (list != null) {
            Predicate<ErrorMessage> equalsErrorMessageId = s -> s.getId().equals(type.getParameter());
            Optional<ErrorMessage> errorMessage = list.stream().filter(equalsErrorMessageId).findFirst();
            if (errorMessage.isPresent()) {
                log.debug("Found error, id: {}", (Object)type);
                return errorMessage.get();
            }
        }
        log.error("Error not found, id: {}", (Object)type);
        return new ErrorMessage(type.getParameter(), type.getParameter(), null);
    }

    private String formatStatus(Response.StatusType status) {
        return String.format("%s %s", status.getStatusCode(), status);
    }
}

