/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service.audit;

import io.jans.as.model.uma.wrapper.Token;
import io.jans.lock.service.TokenEndpointService;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import java.util.concurrent.TimeUnit;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;

@ApplicationScoped
public class AuditForwarderService {
    public static final String AUDIT_TELEMETRY = "telemetry";
    public static final String AUDIT_TELEMETRY_BULK = "telemetry/bulk";
    public static final String AUDIT_LOG = "log";
    public static final String AUDIT_LOG_BULK = "log/bulk";
    public static final String AUDIT_HEALTH = "health";
    public static final String AUDIT_HEALTH_BULK = "health/bulk";
    @Inject
    private Logger log;
    @Inject
    private TokenEndpointService tokenEndpointService;
    private ExpiringMap<String, Token> issuedTokens;

    @PostConstruct
    public void init() {
        this.issuedTokens = ExpiringMap.builder().expirationPolicy(ExpirationPolicy.CREATED).variableExpiration().build();
    }

    public Response post(String endpoint, String postData, ContentType contentType) {
        this.log.info("postData - endpoint:{}, postData:{}, contentType:{}", new Object[]{endpoint, postData, contentType});
        Token token = (Token)this.issuedTokens.get((Object)endpoint);
        if (token == null || token.getAccessToken() == null) {
            this.log.info("Generating new token for endpoint '{}'", (Object)endpoint);
            token = this.getTokenForEndpoint(endpoint);
            if (token == null || token.getAccessToken() == null) {
                this.log.error("Failed to get token for endpoint '{}'", (Object)endpoint);
                return null;
            }
            this.log.debug("Get access token for endpoint: {}, access_token: {}", (Object)endpoint, (Object)token.getAccessToken());
            this.issuedTokens.put((Object)endpoint, (Object)token, ExpirationPolicy.CREATED, (long)token.getExpiresIn().intValue(), TimeUnit.SECONDS);
        }
        this.log.debug("Sending data to config-api endpoint: {}, data: {}", (Object)endpoint, (Object)postData);
        return this.tokenEndpointService.post(endpoint, postData, contentType, token.getAccessToken());
    }

    private Token getTokenForEndpoint(String endpoint) {
        this.log.info("Attempting to get token for endpoint: {}", (Object)endpoint);
        Token token = this.tokenEndpointService.getAccessToken(endpoint, true);
        this.log.debug("Get token for endpoint: {}, token: {}", (Object)endpoint, (Object)token);
        return token;
    }
}

