/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service.consumer.message;

import io.jans.lock.model.config.AppConfiguration;
import io.jans.lock.service.consumer.message.generic.NullMessageConsumer;
import io.jans.service.cdi.async.Asynchronous;
import io.jans.service.cdi.event.ApplicationInitialized;
import io.jans.service.cdi.event.ConfigurationUpdate;
import io.jans.service.cdi.qualifier.Implementation;
import io.jans.service.message.consumer.MessageConsumer;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;

@ApplicationScoped
public class MessageConsumerFactory {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    @Implementation
    private Instance<MessageConsumer> messageConsumerProviderInstances;
    private boolean appStarted = false;

    public void init(@Observes @ApplicationInitialized(value=ApplicationScoped.class) Object init) {
        this.appStarted = true;
    }

    private MessageConsumer getMessageConsumer(String messageConsumerType) {
        for (MessageConsumer messageConsumer : this.messageConsumerProviderInstances) {
            String serviceMessageConsumerType = messageConsumer.getMessageConsumerType();
            if (!StringHelper.equalsIgnoreCase((String)serviceMessageConsumerType, (String)messageConsumerType)) continue;
            return messageConsumer;
        }
        this.log.error("Failed to find message consumer with type '{}'. Using null message consumer", (Object)messageConsumerType);
        return (MessageConsumer)this.messageConsumerProviderInstances.select(NullMessageConsumer.class, new Annotation[0]).get();
    }

    @Asynchronous
    public void configurationUpdateEvent(@Observes @ConfigurationUpdate AppConfiguration appConfiguration) {
        if (!this.appStarted) {
            return;
        }
        this.recreateMessageConsumer();
    }

    private void recreateMessageConsumer() {
        for (MessageConsumer messageConsumer : this.messageConsumerProviderInstances) {
            this.messageConsumerProviderInstances.destroy((Object)messageConsumer);
            messageConsumer.destroy();
            this.log.info("Destroyed messageConsumer instance '{}'", (Object)System.identityHashCode(messageConsumer));
        }
        this.produceMessageConsumer();
    }

    @Produces
    @ApplicationScoped
    public MessageConsumer produceMessageConsumer() {
        String messageConsumerType = this.appConfiguration.getMessageConsumerType();
        MessageConsumer messageConsumer = this.getMessageConsumer(messageConsumerType);
        return messageConsumer;
    }
}

