/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service.consumer.message.generic;

import com.fasterxml.jackson.databind.JsonNode;
import io.jans.service.cdi.async.Asynchronous;
import io.jans.service.cdi.qualifier.Implementation;
import io.jans.service.message.consumer.MessageConsumer;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.slf4j.Logger;

@Implementation
@ApplicationScoped
public class NullMessageConsumer
extends MessageConsumer {
    public static String MESSAGE_CONSUMER_TYPE = "DISABLED";
    @Inject
    private Logger log;

    @Asynchronous
    public void onMessage(String channel, String message) {
        this.log.info("onMessage {} : {} : {}", (Object)channel, (Object)message);
    }

    public void onSubscribe(String channel, int subscribedChannels) {
        this.log.debug("onSubscribe {} : {}", (Object)channel, (Object)subscribedChannels);
    }

    public void onUnsubscribe(String channel, int subscribedChannels) {
        this.log.debug("onUnsubscribe {} : {}", (Object)channel, (Object)subscribedChannels);
    }

    public String getMessageConsumerType() {
        return MESSAGE_CONSUMER_TYPE;
    }

    public void destroy() {
        this.log.debug("Destroy Messages");
    }

    public boolean putData(String message, JsonNode messageNode) {
        return false;
    }
}

