/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service.consumer.policy;

import io.jans.lock.model.config.AppConfiguration;
import io.jans.lock.service.consumer.policy.PolicyConsumer;
import io.jans.lock.service.consumer.policy.generic.NullPolicyConsumer;
import io.jans.service.cdi.async.Asynchronous;
import io.jans.service.cdi.event.ApplicationInitialized;
import io.jans.service.cdi.event.ConfigurationUpdate;
import io.jans.service.cdi.qualifier.Implementation;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;

@ApplicationScoped
public class PolicyConsumerFactory {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    @Implementation
    private Instance<PolicyConsumer> policyConsumerProviderInstances;
    private boolean appStarted = false;

    public void init(@Observes @ApplicationInitialized(value=ApplicationScoped.class) Object init) {
        this.appStarted = true;
    }

    @Asynchronous
    public void configurationUpdateEvent(@Observes @ConfigurationUpdate AppConfiguration appConfiguration) {
        if (!this.appStarted) {
            return;
        }
        this.recreatePolicyConsumer();
    }

    private void recreatePolicyConsumer() {
        for (PolicyConsumer policyConsumer : this.policyConsumerProviderInstances) {
            this.policyConsumerProviderInstances.destroy((Object)policyConsumer);
            policyConsumer.destroy();
            this.log.info("Destroyed policyConsumer instance '{}'", (Object)System.identityHashCode(policyConsumer));
        }
        this.producePolicyConsumer();
    }

    @Produces
    @ApplicationScoped
    public PolicyConsumer producePolicyConsumer() {
        String policyConsumerType = this.appConfiguration.getPolicyConsumerType();
        PolicyConsumer policyConsumer = this.buildPolicyConsumer(policyConsumerType);
        return policyConsumer;
    }

    private PolicyConsumer buildPolicyConsumer(String policyConsumerType) {
        for (PolicyConsumer policyConsumer : this.policyConsumerProviderInstances) {
            String serviceMessageConsumerType = policyConsumer.getPolicyConsumerType();
            if (!StringHelper.equalsIgnoreCase((String)serviceMessageConsumerType, (String)policyConsumerType)) continue;
            return policyConsumer;
        }
        this.log.error("Failed to find policy consumer with type '{}'. Using null policy consumer", (Object)policyConsumerType);
        return (PolicyConsumer)this.policyConsumerProviderInstances.select(NullPolicyConsumer.class, new Annotation[0]).get();
    }
}

