/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service.external;

import com.fasterxml.jackson.databind.JsonNode;
import io.jans.lock.service.external.context.ExternalLockContext;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.lock.LockExtensionType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Iterator;
import java.util.List;

@ApplicationScoped
public class ExternalLockService
extends ExternalScriptService {
    public ExternalLockService() {
        super(CustomScriptType.LOCK_EXTENSION);
    }

    public ExternalLockContext beforeDataPut(JsonNode messageNode, JsonNode dataNode, ExternalLockContext context) {
        CustomScriptConfiguration script;
        Iterator iterator = this.customScriptConfigurations.iterator();
        while (iterator.hasNext() && this.beforeDataPut(messageNode, dataNode, script = (CustomScriptConfiguration)iterator.next(), context)) {
        }
        this.log.debug("Executed (beforeDataPut) from external lock script");
        return context;
    }

    public ExternalLockContext beforeDataRemoval(JsonNode messageNode, ExternalLockContext context) {
        CustomScriptConfiguration script;
        Iterator iterator = this.customScriptConfigurations.iterator();
        while (iterator.hasNext() && this.beforeDataRemoval(messageNode, script = (CustomScriptConfiguration)iterator.next(), context)) {
        }
        this.log.debug("Executed (beforeDataRemoval) from external lock script");
        return context;
    }

    public ExternalLockContext beforePolicyPut(String sourceUri, List<String> policies, ExternalLockContext context) {
        CustomScriptConfiguration script;
        Iterator iterator = this.customScriptConfigurations.iterator();
        while (iterator.hasNext() && this.beforePolicyPut(sourceUri, policies, script = (CustomScriptConfiguration)iterator.next(), context)) {
        }
        this.log.debug("Executed (beforePolicyPut) from external lock script");
        return context;
    }

    public ExternalLockContext beforePolicyRemoval(String sourceUri, ExternalLockContext context) {
        CustomScriptConfiguration script;
        Iterator iterator = this.customScriptConfigurations.iterator();
        while (iterator.hasNext() && this.beforePolicyRemoval(sourceUri, script = (CustomScriptConfiguration)iterator.next(), context)) {
        }
        this.log.debug("Executed (beforePolicyRemoval) from external lock script");
        return context;
    }

    private boolean beforeDataPut(JsonNode messageNode, JsonNode dataNode, CustomScriptConfiguration scriptConfiguration, ExternalLockContext context) {
        try {
            this.log.trace("Executing external 'beforeDataPut' method, script name: {}, context: {}", (Object)scriptConfiguration.getName(), (Object)context);
            LockExtensionType script = (LockExtensionType)scriptConfiguration.getExternalType();
            context.setScript(scriptConfiguration);
            script.beforeDataPut((Object)messageNode, (Object)dataNode, (Object)context);
            return context.isCancelNextScriptOperation();
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(scriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }

    private boolean beforeDataRemoval(JsonNode messageNode, CustomScriptConfiguration scriptConfiguration, ExternalLockContext context) {
        try {
            this.log.trace("Executing external 'beforeDataRemoval' method, script name: {}, context: {}", (Object)scriptConfiguration.getName(), (Object)context);
            LockExtensionType script = (LockExtensionType)scriptConfiguration.getExternalType();
            context.setScript(scriptConfiguration);
            script.beforeDataRemoval((Object)messageNode, (Object)context);
            return context.isCancelNextScriptOperation();
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(scriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }

    private boolean beforePolicyPut(String sourceUri, List<String> policies, CustomScriptConfiguration scriptConfiguration, ExternalLockContext context) {
        try {
            this.log.trace("Executing external 'beforePolicyPut' method, script name: {}, context: {}", (Object)scriptConfiguration.getName(), (Object)context);
            LockExtensionType script = (LockExtensionType)scriptConfiguration.getExternalType();
            context.setScript(scriptConfiguration);
            script.beforePolicyPut(sourceUri, policies, (Object)context);
            return context.isCancelNextScriptOperation();
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(scriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }

    private boolean beforePolicyRemoval(String sourceUri, CustomScriptConfiguration scriptConfiguration, ExternalLockContext context) {
        try {
            this.log.trace("Executing external 'beforePolicyRemoval' method, script name: {}, context: {}", (Object)scriptConfiguration.getName(), (Object)context);
            LockExtensionType script = (LockExtensionType)scriptConfiguration.getExternalType();
            context.setScript(scriptConfiguration);
            script.beforePolicyRemoval(sourceUri, (Object)context);
            return context.isCancelNextScriptOperation();
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(scriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }
}

