/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service.policy;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.lock.model.config.AppConfiguration;
import io.jans.lock.service.consumer.policy.PolicyConsumer;
import io.jans.lock.service.event.PolicyDownloadEvent;
import io.jans.service.EncryptionService;
import io.jans.service.cdi.async.Asynchronous;
import io.jans.service.cdi.event.Scheduled;
import io.jans.service.net.BaseHttpService;
import io.jans.service.timer.event.TimerEvent;
import io.jans.service.timer.schedule.TimerSchedule;
import io.jans.util.StringHelper;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class PolicyDownloadService {
    private static final int DEFAULT_INTERVAL = 30;
    @Inject
    private Logger log;
    @Inject
    private Event<TimerEvent> timerEvent;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private BaseHttpService httpService;
    @Inject
    private PolicyConsumer policyConsumer;
    @Inject
    private EncryptionService encryptionService;
    private ObjectMapper objectMapper;
    private List<String> loadedPoliciesJsonUris;
    private List<String> loadedPoliciesZipUris;
    private AtomicBoolean isActive;

    @PostConstruct
    public void init() {
        this.log.info("Initializing Policy Download Service ...");
        this.isActive = new AtomicBoolean(false);
        this.objectMapper = new ObjectMapper();
        this.loadedPoliciesJsonUris = new ArrayList<String>();
        this.loadedPoliciesZipUris = new ArrayList<String>();
    }

    public void initTimer() {
        this.log.debug("Initializing Policy Download Service Timer");
        int delay = 30;
        int interval = 30;
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(30, 30), (Object)new PolicyDownloadEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
    }

    @Asynchronous
    public void reloadPoliciesTimerEvent(@Observes @Scheduled PolicyDownloadEvent policyDownloadEvent) {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.reloadPolicies();
        }
        catch (Throwable ex) {
            this.log.error("Exception happened while reloading policies", ex);
        }
        finally {
            this.isActive.set(false);
        }
    }

    private void reloadPolicies() {
        this.reloadUrisPolicies();
        this.reloadZipPolicies();
    }

    private void reloadUrisPolicies() {
        this.log.debug("Starting URIs policies reload");
        String policiesJsonUrisAuthorizationToken = this.encryptionService.decrypt(this.appConfiguration.getPoliciesJsonUrisAuthorizationToken(), true);
        List policiesJsonUris = this.appConfiguration.getPoliciesJsonUris();
        if (policiesJsonUris == null) {
            return;
        }
        ArrayList<String> newPoliciesJsonUris = new ArrayList<String>();
        for (String policiesJsonUri : policiesJsonUris) {
            if (StringHelper.isEmpty((String)policiesJsonUri)) continue;
            ArrayList<String> downloadedPolicies = new ArrayList<String>();
            HttpGet request = new HttpGet(policiesJsonUri);
            if (StringHelper.isNotEmpty((String)policiesJsonUrisAuthorizationToken)) {
                request.setHeader("Authorization", "Bearer " + policiesJsonUrisAuthorizationToken);
            }
            try {
                CloseableHttpClient httpClient = this.httpService.getHttpsClient();
                CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)request);
                boolean result = this.httpService.isResponseStastusCodeOk((HttpResponse)httpResponse);
                if (result) {
                    String policiesJson = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
                    JsonNode policiesArray = this.objectMapper.readTree(policiesJson);
                    if (!policiesArray.isArray()) {
                        this.log.error(String.format("Policies URI should provides json array. Skipping it...", policiesJsonUri));
                        continue;
                    }
                    for (JsonNode policyUri : policiesArray) {
                        String downloadedPolicy = this.downloadPolicy(policyUri.asText(), policiesJsonUrisAuthorizationToken);
                        if (!StringHelper.isNotEmpty((String)downloadedPolicy)) continue;
                        downloadedPolicies.add(downloadedPolicy);
                    }
                } else {
                    this.log.error("Get invalid response from URI {}", (Object)policiesJsonUri);
                }
            }
            catch (IOException ex) {
                this.log.error("Failed to execute load policies list from URI {}", (Object)policiesJsonUri, (Object)ex);
            }
            this.policyConsumer.putPolicies(policiesJsonUri, downloadedPolicies);
            newPoliciesJsonUris.add(policiesJsonUri);
        }
        this.loadedPoliciesJsonUris.removeAll(newPoliciesJsonUris);
        for (String policiesJsonUri : this.loadedPoliciesJsonUris) {
            this.policyConsumer.removePolicies(policiesJsonUri);
        }
        this.loadedPoliciesJsonUris = newPoliciesJsonUris;
        this.log.debug("End URIs policies reload");
    }

    private void reloadZipPolicies() {
        this.log.debug("Starting Zip policies reload");
        String policiesZipUrisAuthorizationToken = this.encryptionService.decrypt(this.appConfiguration.getPoliciesZipUrisAuthorizationToken(), true);
        List policiesZipUris = this.appConfiguration.getPoliciesZipUris();
        if (policiesZipUris == null) {
            return;
        }
        ArrayList<String> newPoliciesZipUris = new ArrayList<String>();
        for (String policiesZipUri : policiesZipUris) {
            ArrayList<String> zipPolicies;
            block13: {
                if (StringHelper.isEmpty((String)policiesZipUri)) continue;
                zipPolicies = new ArrayList<String>();
                HttpGet request = new HttpGet(policiesZipUri);
                if (StringHelper.isNotEmpty((String)policiesZipUrisAuthorizationToken)) {
                    request.setHeader("Authorization", "Bearer " + policiesZipUrisAuthorizationToken);
                }
                try {
                    CloseableHttpClient httpClient = this.httpService.getHttpsClient();
                    CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)request);
                    boolean result = this.httpService.isResponseStastusCodeOk((HttpResponse)httpResponse);
                    if (result) {
                        try (ZipInputStream zis = new ZipInputStream(httpResponse.getEntity().getContent());){
                            ZipEntry ze;
                            while ((ze = zis.getNextEntry()) != null) {
                                String fileName = ze.getName();
                                if (ze.isDirectory() || !fileName.endsWith(".rego")) continue;
                                byte[] fileBytes = IOUtils.toByteArray((InputStream)zis);
                                String zipFilePolicy = new String(fileBytes, StandardCharsets.UTF_8);
                                zis.closeEntry();
                                if (!StringHelper.isNotEmpty((String)zipFilePolicy)) continue;
                                zipPolicies.add(zipFilePolicy);
                            }
                            break block13;
                        }
                    }
                    this.log.error("Get invalid response from URI {}", (Object)policiesZipUri);
                }
                catch (IOException ex) {
                    this.log.error("Failed to execute load policies list from Zip {}", (Object)policiesZipUri, (Object)ex);
                }
            }
            this.policyConsumer.putPolicies(policiesZipUri, zipPolicies);
            newPoliciesZipUris.add(policiesZipUri);
        }
        this.loadedPoliciesZipUris.removeAll(newPoliciesZipUris);
        for (String policiesRegoUri : this.loadedPoliciesZipUris) {
            this.policyConsumer.removePolicies(policiesRegoUri);
        }
        this.loadedPoliciesZipUris = newPoliciesZipUris;
        this.log.debug("End Zip policies reload");
    }

    private String downloadPolicy(String policyUri, String authorizationToken) {
        HttpGet request = new HttpGet(policyUri);
        if (StringHelper.isNotEmpty((String)authorizationToken)) {
            request.setHeader("Authorization", "Bearer " + authorizationToken);
        }
        try {
            CloseableHttpClient httpClient = this.httpService.getHttpsClient();
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)request);
            boolean result = this.httpService.isResponseStastusCodeOk((HttpResponse)httpResponse);
            if (!result) {
                this.log.error("Get invalid response from policy URI {}", (Object)policyUri);
                return null;
            }
            String policy = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
            return policy;
        }
        catch (IOException ex) {
            this.log.error("Failed to load policy from URI {}", (Object)policyUri, (Object)ex);
            return null;
        }
    }
}

