/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service.ws.rs;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.jans.lock.model.core.LockApiError;
import io.jans.lock.service.config.ConfigurationService;
import io.jans.lock.service.ws.rs.base.BaseResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Dependent
@Path(value="/configuration")
public class ConfigurationRestWebService
extends BaseResource {
    @Inject
    private ConfigurationService configurationService;

    @Operation(summary="Request .well-known data", description="Request .well-know Lock server configuration", tags={"Lock - Server Configuration"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class, description="ConfigurationFound"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=LockApiError.class, description="InternalServerError"))})})
    @GET
    @Produces(value={"application/json"})
    public Response getConfiguration() {
        ObjectNode response = this.configurationService.getLockConfiguration();
        Response.ResponseBuilder builder = Response.ok().entity((Object)response.toString());
        return builder.build();
    }
}

