/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service.ws.rs.app;

import io.jans.lock.service.filter.AuthorizationProcessingFilter;
import io.jans.lock.service.ws.rs.ConfigurationRestWebService;
import io.jans.lock.service.ws.rs.audit.AuditRestWebServiceImpl;
import io.jans.lock.service.ws.rs.config.ConfigRestWebServiceImpl;
import io.jans.lock.service.ws.rs.sse.SseRestWebServiceImpl;
import io.jans.lock.service.ws.rs.stat.StatRestWebServiceImpl;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.info.Contact;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.info.License;
import io.swagger.v3.oas.annotations.security.OAuthFlow;
import io.swagger.v3.oas.annotations.security.OAuthFlows;
import io.swagger.v3.oas.annotations.security.OAuthScope;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.core.Application;
import java.util.HashSet;
import java.util.Set;

@ApplicationPath(value="/api/v1")
@OpenAPIDefinition(info=@Info(title="Jans Lock API", contact=@Contact(name="Contact", url="https://github.com/JanssenProject/jans/discussions"), license=@License(name="License", url="https://github.com/JanssenProject/jans/blob/main/LICENSE"), version="OAS Version"), tags={@Tag(name="Lock - Server Configuration"), @Tag(name="Lock - Stat"), @Tag(name="Lock - Audit Health"), @Tag(name="Lock - Audit Log"), @Tag(name="Lock - Audit Telemetry"), @Tag(name="Lock - SSE")}, servers={@Server(url="https://jans.local.io", description="The Jans server")})
@SecurityScheme(name="oauth2", type=SecuritySchemeType.OAUTH2, flows=@OAuthFlows(clientCredentials=@OAuthFlow(tokenUrl="https://{op-hostname}/.../token", scopes={@OAuthScope(name="https://jans.io/oauth/lock-config.readonly", description="View configuration related information"), @OAuthScope(name="https://jans.io/lock-server/issuers.readonly", description="View issuers related information"), @OAuthScope(name="https://jans.io/lock-server/schema.readonly", description="View schema related information"), @OAuthScope(name="https://jans.io/lock-server/policy.readonly", description="View policy related information"), @OAuthScope(name="https://jans.io/oauth/lock/health.write", description="Write audit health entries"), @OAuthScope(name="https://jans.io/oauth/lock/log.write", description="Write audit log entries"), @OAuthScope(name="https://jans.io/oauth/lock/telemetry.write", description="Write telemetry health entries"), @OAuthScope(name="https://jans.io/oauth/lock/sse.readonly", description="Subscribe to SSE events"), @OAuthScope(name="jans_stat", description="View stat related information")})))
public class ResteasyInitializer
extends Application {
    public Set<Class<?>> getClasses() {
        HashSet classes = new HashSet();
        classes.add(ConfigurationRestWebService.class);
        classes.add(AuditRestWebServiceImpl.class);
        classes.add(ConfigRestWebServiceImpl.class);
        classes.add(StatRestWebServiceImpl.class);
        classes.add(SseRestWebServiceImpl.class);
        classes.add(AuthorizationProcessingFilter.class);
        return classes;
    }
}

