/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.service.ws.rs.audit;

import com.fasterxml.jackson.databind.JsonNode;
import io.jans.lock.service.DataMapperService;
import io.jans.lock.service.audit.AuditForwarderService;
import io.jans.lock.service.stat.StatService;
import io.jans.lock.service.ws.rs.audit.AuditRestWebService;
import io.jans.lock.service.ws.rs.base.BaseResource;
import io.jans.lock.util.ServerUtil;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.io.InputStream;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;

@Dependent
public class AuditRestWebServiceImpl
extends BaseResource
implements AuditRestWebService {
    private static final String LOG_PRINCIPAL_ID = "principalId";
    private static final String LOG_CLIENT_ID = "clientId";
    private static final String LOG_DECISION_RESULT = "decisionResult";
    private static final String LOG_ACTION = "action";
    private static final String LOG_DECISION_RESULT_ALLOW = "allow";
    private static final String LOG_DECISION_RESULT_DENY = "deny";
    @Inject
    private Logger log;
    @Inject
    private DataMapperService dataMapperService;
    @Inject
    private AuditForwarderService auditForwarderService;
    @Inject
    private StatService statService;

    @Override
    public Response processHealthRequest(HttpServletRequest request, HttpServletResponse response, SecurityContext sec) {
        this.log.info("Processing Health request - request: {}", (Object)request);
        return this.processAuditRequest(request, "health");
    }

    @Override
    public Response processBulkHealthRequest(HttpServletRequest request, HttpServletResponse response, SecurityContext sec) {
        this.log.info("Processing Bulk Health request - request: {}", (Object)request);
        return this.processAuditRequest(request, "health/bulk");
    }

    @Override
    public Response processLogRequest(HttpServletRequest request, HttpServletResponse response, SecurityContext sec) {
        this.log.info("Processing Log request - request: {}", (Object)request);
        return this.processAuditRequest(request, "log", true, false);
    }

    @Override
    public Response processBulkLogRequest(HttpServletRequest request, HttpServletResponse response, SecurityContext sec) {
        this.log.info("Processing Bulk Log request - request: {}", (Object)request);
        return this.processAuditRequest(request, "log/bulk", true, true);
    }

    @Override
    public Response processTelemetryRequest(HttpServletRequest request, HttpServletResponse response, SecurityContext sec) {
        this.log.info("Processing Telemetry request - request: {}", (Object)request);
        return this.processAuditRequest(request, "telemetry");
    }

    @Override
    public Response processBulkTelemetryRequest(HttpServletRequest request, HttpServletResponse response, SecurityContext sec) {
        this.log.info("Processing Bulk Telemetry request - request: {}", (Object)request);
        return this.processAuditRequest(request, "telemetry/bulk");
    }

    private Response processAuditRequest(HttpServletRequest request, String requestType) {
        return this.processAuditRequest(request, requestType, false, false);
    }

    private Response processAuditRequest(HttpServletRequest request, String requestType, boolean reportStat, boolean bulkData) {
        Response response;
        this.log.info("Processing request - request: {}, requestType: {}", (Object)request, (Object)requestType);
        JsonNode json = this.getJsonNode(request);
        if (json == null) {
            AuditRestWebServiceImpl.throwBadRequestException("Failed to parse request");
        }
        if (reportStat) {
            if (bulkData) {
                this.reportBulkStat(json);
            } else {
                this.reportStat(json);
            }
        }
        if ((response = this.auditForwarderService.post(requestType, json.toString(), ContentType.APPLICATION_JSON)) == null) {
            AuditRestWebServiceImpl.throwNotFoundException("Failed to forward request to config-api");
        }
        this.log.debug("Get response with status: {}, statusInfo: {}, entityClass: {}", new Object[]{response.getStatus(), response.getStatusInfo(), response.getEntity().getClass()});
        Response.ResponseBuilder builder = Response.ok();
        builder.cacheControl(ServerUtil.cacheControlWithNoStoreTransformAndPrivate());
        builder.header("Pragma", (Object)"no-cache");
        String entity = (String)response.readEntity(String.class);
        builder.entity((Object)entity);
        this.log.debug("Response entity: {}", (Object)entity);
        if (response.getStatusInfo().equals(Response.Status.OK)) {
            this.log.debug(" Status: {}, entity: {}", (Object)response.getStatus(), (Object)entity);
        } else {
            this.log.error("Error while saving audit data, statusInfo: {}, entity: {}", (Object)response.getStatusInfo(), (Object)entity);
            builder.status(response.getStatusInfo());
        }
        return builder.build();
    }

    private JsonNode getJsonNode(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        JsonNode jsonBody = null;
        try {
            jsonBody = this.dataMapperService.readTree((InputStream)request.getInputStream());
            this.log.debug("Parsed request body data: {}", (Object)jsonBody);
        }
        catch (Exception ex) {
            this.log.error("Failed to parse request", (Throwable)ex);
        }
        return jsonBody;
    }

    private void reportStat(JsonNode json) {
        boolean hasAction;
        boolean has\u0412ecisionResult;
        boolean hasPrincipalId;
        boolean hasClientId = json.hasNonNull(LOG_CLIENT_ID);
        if (hasClientId) {
            this.statService.reportActiveClient(json.get(LOG_CLIENT_ID).asText());
        }
        if (hasPrincipalId = json.hasNonNull(LOG_PRINCIPAL_ID)) {
            this.statService.reportActiveUser(json.get(LOG_PRINCIPAL_ID).asText());
        }
        if (has\u0412ecisionResult = json.hasNonNull(LOG_DECISION_RESULT)) {
            String decisionResult = json.get(LOG_DECISION_RESULT).asText();
            if (LOG_DECISION_RESULT_ALLOW.equals(decisionResult)) {
                this.statService.reportAllow(LOG_DECISION_RESULT);
            } else if (LOG_DECISION_RESULT_DENY.equals(decisionResult)) {
                this.statService.reportDeny(LOG_DECISION_RESULT);
            }
        }
        if (hasAction = json.hasNonNull(LOG_ACTION)) {
            this.statService.reportOpearation(LOG_ACTION, json.get(LOG_ACTION).asText());
        }
    }

    private void reportBulkStat(JsonNode json) {
        if (!json.isArray()) {
            this.log.error("Failed to calculate stat for bulk log entry: {}", (Object)json);
        }
        for (JsonNode jsonItem : json) {
            this.reportStat(jsonItem);
        }
    }
}

