/*
 * Decompiled with CFR 0.152.
 */
package io.jans.notify.client;

import io.jans.notify.client.NotifyClientService;
import io.jans.notify.client.NotifyMetadataClientService;
import io.jans.notify.model.NotifyMetadata;
import jakarta.ws.rs.core.UriBuilder;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient43Engine;

public class NotifyClientFactory {
    private static final NotifyClientFactory instance = new NotifyClientFactory();
    private ApacheHttpClient43Engine engine = this.createEngine();

    private NotifyClientFactory() {
    }

    public static NotifyClientFactory instance() {
        return instance;
    }

    public NotifyMetadataClientService createMetaDataConfigurationService(String issuer) {
        ResteasyClient client = ((ResteasyClientBuilder)ResteasyClientBuilder.newBuilder()).httpEngine((ClientHttpEngine)this.engine).build();
        ResteasyWebTarget target = client.target(UriBuilder.fromPath((String)(issuer + "/.well-known/notify-configuration")));
        return (NotifyMetadataClientService)target.proxy(NotifyMetadataClientService.class);
    }

    public NotifyClientService createNotifyService(NotifyMetadata notifyMetadata) {
        ResteasyClient client = ((ResteasyClientBuilder)ResteasyClientBuilder.newBuilder()).httpEngine((ClientHttpEngine)this.engine).build();
        ResteasyWebTarget target = client.target(UriBuilder.fromPath((String)notifyMetadata.getNotifyEndpoint()));
        return (NotifyClientService)target.proxy(NotifyClientService.class);
    }

    public static String getAuthorization(String accessKeyId, String secretAccessKey) {
        String credentials = accessKeyId + ":" + secretAccessKey;
        String authorization = "Basic " + Base64.encodeBase64String((byte[])credentials.getBytes());
        return authorization;
    }

    private ApacheHttpClient43Engine createEngine() {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).setConnectionManager((HttpClientConnectionManager)cm).build();
        cm.setMaxTotal(200);
        cm.setDefaultMaxPerRoute(20);
        ApacheHttpClient43Engine engine = new ApacheHttpClient43Engine((HttpClient)httpClient);
        engine.setFollowRedirects(false);
        return engine;
    }
}

