/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.model;

import io.jans.orm.model.SortOrder;

public class Sort {
    private final String name;
    private SortOrder sortOrder;

    public Sort(String name) {
        this.name = name;
    }

    public Sort(String name, SortOrder sortOrder) {
        this.name = name;
        this.sortOrder = sortOrder;
    }

    public final String getName() {
        return this.name;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public static Sort desc(String name) {
        return new Sort(name, SortOrder.DESCENDING);
    }

    public static Sort asc(String name) {
        return new Sort(name, SortOrder.ASCENDING);
    }

    public static Sort def(String name) {
        return new Sort(name, SortOrder.DEFAULT);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.sortOrder == null ? 0 : this.sortOrder.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sort other = (Sort)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.sortOrder == other.sortOrder;
    }

    public String toString() {
        return "Sort [name=" + this.name + ", sortOrder=" + this.sortOrder + "]";
    }
}

