/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.reflect.property;

import io.jans.orm.exception.BasePersistenceException;
import io.jans.orm.exception.PropertyAccessException;
import io.jans.orm.exception.PropertyNotFoundException;
import io.jans.orm.reflect.property.Getter;
import io.jans.orm.reflect.property.PropertyAccessor;
import io.jans.orm.reflect.property.Setter;
import io.jans.orm.reflect.util.ReflectHelper;
import java.beans.Introspector;
import java.beans.Transient;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicPropertyAccessor
implements PropertyAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(BasicPropertyAccessor.class);

    @Override
    public Setter getSetter(Class<?> theClass, String propertyName) throws PropertyNotFoundException {
        return BasicPropertyAccessor.createSetter(theClass, propertyName);
    }

    private static Setter createSetter(Class<?> theClass, String propertyName) throws PropertyNotFoundException {
        BasicSetter result = BasicPropertyAccessor.getSetterOrNull(theClass, propertyName);
        if (result == null) {
            throw new PropertyNotFoundException("Could not find a setter for property " + propertyName + " in class " + theClass.getName());
        }
        return result;
    }

    private static BasicSetter getSetterOrNull(Class<?> theClass, String propertyName) {
        if (theClass == Object.class || theClass == null) {
            return null;
        }
        Method method = BasicPropertyAccessor.setterMethod(theClass, propertyName);
        if (method != null) {
            if (!ReflectHelper.isPublic(theClass, method)) {
                method.setAccessible(true);
            }
            return new BasicSetter(theClass, method, propertyName);
        }
        BasicSetter setter = BasicPropertyAccessor.getSetterOrNull(theClass.getSuperclass(), propertyName);
        if (setter == null) {
            Class<?>[] interfaces = theClass.getInterfaces();
            for (int i = 0; setter == null && i < interfaces.length; ++i) {
                setter = BasicPropertyAccessor.getSetterOrNull(interfaces[i], propertyName);
            }
        }
        return setter;
    }

    private static Method setterMethod(Class<?> theClass, String propertyName) {
        BasicGetter getter = BasicPropertyAccessor.getGetterOrNull(theClass, propertyName);
        Class<?> returnType = getter == null ? null : getter.getReturnType();
        Method[] methods = theClass.getDeclaredMethods();
        Method potentialSetter = null;
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            boolean isTransient = BasicPropertyAccessor.isTransient(method);
            if (isTransient) continue;
            String methodName = method.getName();
            if (method.getParameterTypes().length != 1 || !methodName.startsWith("set")) continue;
            String testStdMethod = Introspector.decapitalize(methodName.substring(3));
            String testOldMethod = methodName.substring(3);
            if (!testStdMethod.equals(propertyName) && !testOldMethod.equals(propertyName)) continue;
            potentialSetter = method;
            if (returnType != null && !method.getParameterTypes()[0].equals(returnType)) continue;
            return potentialSetter;
        }
        return potentialSetter;
    }

    @Override
    public Getter getGetter(Class<?> theClass, String propertyName) throws PropertyNotFoundException {
        return BasicPropertyAccessor.createGetter(theClass, propertyName);
    }

    public static Getter createGetter(Class<?> theClass, String propertyName) throws PropertyNotFoundException {
        BasicGetter result = BasicPropertyAccessor.getGetterOrNull(theClass, propertyName);
        if (result == null) {
            throw new PropertyNotFoundException("Could not find a getter for " + propertyName + " in class " + theClass.getName());
        }
        return result;
    }

    private static BasicGetter getGetterOrNull(Class<?> theClass, String propertyName) {
        Annotation[] methodAnnotations;
        if (theClass == Object.class || theClass == null) {
            return null;
        }
        Method method = BasicPropertyAccessor.getterMethod(theClass, propertyName);
        if (method != null && (methodAnnotations = method.getAnnotations()) != null) {
            for (Annotation methodAnnotation : methodAnnotations) {
                if (!methodAnnotation.annotationType().equals(Transient.class)) continue;
                method = null;
            }
        }
        if (method != null) {
            if (!ReflectHelper.isPublic(theClass, method)) {
                method.setAccessible(true);
            }
            return new BasicGetter(theClass, method, propertyName);
        }
        BasicGetter getter = BasicPropertyAccessor.getGetterOrNull(theClass.getSuperclass(), propertyName);
        if (getter == null) {
            Class<?>[] interfaces = theClass.getInterfaces();
            for (int i = 0; getter == null && i < interfaces.length; ++i) {
                getter = BasicPropertyAccessor.getGetterOrNull(interfaces[i], propertyName);
            }
        }
        return getter;
    }

    private static Method getterMethod(Class<?> theClass, String propertyName) {
        Method[] methods = theClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            String testOldMethod;
            String testStdMethod;
            Method method;
            boolean isTransient;
            if (methods[i].getParameterTypes().length != 0 || (isTransient = BasicPropertyAccessor.isTransient(method = methods[i]))) continue;
            String methodName = methods[i].getName();
            if (methodName.startsWith("get")) {
                testStdMethod = Introspector.decapitalize(methodName.substring(3));
                testOldMethod = methodName.substring(3);
                if (testStdMethod.equals(propertyName) || testOldMethod.equals(propertyName)) {
                    return method;
                }
            }
            if (!methodName.startsWith("is")) continue;
            testStdMethod = Introspector.decapitalize(methodName.substring(2));
            testOldMethod = methodName.substring(2);
            if (!testStdMethod.equals(propertyName) && !testOldMethod.equals(propertyName)) continue;
            return method;
        }
        return null;
    }

    private static boolean isTransient(Method method) {
        Annotation[] methodAnnotations = method.getAnnotations();
        if (methodAnnotations != null) {
            for (Annotation methodAnnotation : methodAnnotations) {
                if (!methodAnnotation.annotationType().equals(Transient.class)) continue;
                return true;
            }
        }
        return false;
    }

    public static final class BasicGetter
    implements Getter {
        private static final long serialVersionUID = -5736635201315368096L;
        private Class<?> clazz;
        private final transient Method method;
        private final String propertyName;

        private BasicGetter(Class<?> clazz, Method method, String propertyName) {
            this.clazz = clazz;
            this.method = method;
            this.propertyName = propertyName;
        }

        @Override
        public Object get(Object target) throws BasePersistenceException {
            try {
                return this.method.invoke(target, (Object[])null);
            }
            catch (InvocationTargetException ite) {
                throw new PropertyAccessException(ite, "Exception occurred inside", false, this.clazz, this.propertyName);
            }
            catch (IllegalAccessException iae) {
                throw new PropertyAccessException(iae, "IllegalAccessException occurred while calling", false, this.clazz, this.propertyName);
            }
            catch (IllegalArgumentException iae) {
                LOG.error("IllegalArgumentException in class: " + this.clazz.getName() + ", getter method of property: " + this.propertyName);
                throw new PropertyAccessException(iae, "IllegalArgumentException occurred calling", false, this.clazz, this.propertyName);
            }
        }

        @Override
        public Class<?> getReturnType() {
            return this.method.getReturnType();
        }

        @Override
        public Method getMethod() {
            return this.method;
        }

        @Override
        public String getMethodName() {
            return this.method.getName();
        }

        public String toString() {
            return "BasicGetter(" + this.clazz.getName() + "." + this.propertyName + ")";
        }

        Object readResolve() {
            return BasicPropertyAccessor.createGetter(this.clazz, this.propertyName);
        }
    }

    public static final class BasicSetter
    implements Setter {
        private static final long serialVersionUID = 1660638549257218450L;
        private Class<?> clazz;
        private final transient Method method;
        private final String propertyName;

        private BasicSetter(Class<?> clazz, Method method, String propertyName) {
            this.clazz = clazz;
            this.method = method;
            this.propertyName = propertyName;
        }

        @Override
        public void set(Object target, Object value) throws BasePersistenceException {
            try {
                this.method.invoke(target, value);
            }
            catch (NullPointerException npe) {
                if (value == null && this.method.getParameterTypes()[0].isPrimitive()) {
                    throw new PropertyAccessException(npe, "Null value was assigned to a property of primitive type", true, this.clazz, this.propertyName);
                }
                throw new PropertyAccessException(npe, "NullPointerException occurred while calling", true, this.clazz, this.propertyName);
            }
            catch (InvocationTargetException ite) {
                throw new PropertyAccessException(ite, "Exception occurred inside", true, this.clazz, this.propertyName);
            }
            catch (IllegalAccessException iae) {
                throw new PropertyAccessException(iae, "IllegalAccessException occurred while calling", true, this.clazz, this.propertyName);
            }
            catch (IllegalArgumentException iae) {
                if (value == null && this.method.getParameterTypes()[0].isPrimitive()) {
                    throw new PropertyAccessException(iae, "Null value was assigned to a property of primitive type", true, this.clazz, this.propertyName);
                }
                LOG.error("IllegalArgumentException in class: " + this.clazz.getName() + ", setter method of property: " + this.propertyName);
                LOG.error("expected type: " + this.method.getParameterTypes()[0].getName() + ", actual value: " + (value == null ? null : value.getClass().getName()));
                throw new PropertyAccessException(iae, "IllegalArgumentException occurred while calling", true, this.clazz, this.propertyName);
            }
        }

        @Override
        public Method getMethod() {
            return this.method;
        }

        @Override
        public String getMethodName() {
            return this.method.getName();
        }

        Object readResolve() {
            return BasicPropertyAccessor.createSetter(this.clazz, this.propertyName);
        }

        public String toString() {
            return "BasicSetter(" + this.clazz.getName() + "." + this.propertyName + ")";
        }
    }
}

