/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.result;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.result.CoreReactiveSearchResult;
import com.couchbase.client.core.api.search.result.CoreSearchRow;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.search.SearchMetaData;
import com.couchbase.client.java.search.result.SearchFacetResult;
import com.couchbase.client.java.search.result.SearchRow;
import com.couchbase.client.java.search.util.SearchFacetUtil;
import java.util.HashMap;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveSearchResult {
    private final CoreReactiveSearchResult internal;
    private final JsonSerializer serializer;

    @Stability.Internal
    public ReactiveSearchResult(CoreReactiveSearchResult internal, JsonSerializer serializer) {
        this.internal = internal;
        this.serializer = serializer;
    }

    public Flux<SearchRow> rows() {
        return this.internal.rows().map(row -> new SearchRow((CoreSearchRow)row, this.serializer));
    }

    public Mono<SearchMetaData> metaData() {
        return this.internal.metaData().map(SearchMetaData::new);
    }

    public Mono<Map<String, SearchFacetResult>> facets() {
        return this.internal.facets().map(result -> {
            HashMap out = new HashMap();
            result.forEach((k, v) -> out.put(k, SearchFacetUtil.convert(v)));
            return out;
        });
    }
}

