/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.classic.manager;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.classic.manager.CoreBucketSettingsJson;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.config.BucketType;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.endpoint.http.CoreHttpClient;
import com.couchbase.client.core.endpoint.http.CoreHttpPath;
import com.couchbase.client.core.endpoint.http.CoreHttpResponse;
import com.couchbase.client.core.error.BucketExistsException;
import com.couchbase.client.core.error.BucketNotFlushableException;
import com.couchbase.client.core.error.BucketNotFoundException;
import com.couchbase.client.core.error.HttpStatusCodeException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.manager.CoreBucketManagerOps;
import com.couchbase.client.core.manager.bucket.CoreBucketSettings;
import com.couchbase.client.core.manager.bucket.CoreCreateBucketSettings;
import com.couchbase.client.core.msg.RequestTarget;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.CbThrowables;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class ClassicCoreBucketManager
implements CoreBucketManagerOps {
    private final Core core;
    private final CoreHttpClient httpClient;

    public ClassicCoreBucketManager(Core core) {
        this.core = core;
        this.httpClient = core.httpClient(RequestTarget.manager());
    }

    private static CoreHttpPath pathForBuckets() {
        return CoreHttpPath.path("/pools/default/buckets/");
    }

    private static CoreHttpPath pathForBucket(String bucketName) {
        return CoreHttpPath.path("/pools/default/buckets/{bucketName}", CbCollections.mapOf("bucketName", bucketName));
    }

    private static CoreHttpPath pathForBucketFlush(String bucketName) {
        return CoreHttpPath.path("/pools/default/buckets/{bucketName}/controller/doFlush", CbCollections.mapOf("bucketName", bucketName));
    }

    @Override
    public CompletableFuture<Void> createBucket(CoreBucketSettings settings, CoreCreateBucketSettings createSpecificSettings, CoreCommonOptions options) {
        String bucketName = settings.name();
        return ((CompletableFuture)this.httpClient.post(ClassicCoreBucketManager.pathForBuckets(), options).trace("manager_buckets_create_bucket").traceBucket(bucketName).form(this.convertSettingsToParams(settings, createSpecificSettings, false)).exec(this.core).exceptionally(t -> {
            throw HttpStatusCodeException.httpResponseBody(t).contains("Bucket with given name already exists") ? BucketExistsException.forBucket(bucketName) : CbThrowables.propagate(ClassicCoreBucketManager.wrap(t));
        })).thenApply(response -> null);
    }

    private static Throwable wrap(Throwable t) {
        HttpStatusCodeException err;
        if (t instanceof CompletionException) {
            return ClassicCoreBucketManager.wrap(t.getCause());
        }
        if (t instanceof HttpStatusCodeException && (err = (HttpStatusCodeException)t).httpStatusCode() == 400) {
            return new InvalidArgumentException(t.getMessage(), t, err.context());
        }
        return t;
    }

    @Override
    public CompletableFuture<Void> updateBucket(CoreBucketSettings settings, CoreCommonOptions options) {
        String bucketName = settings.name();
        RequestSpan span = CbTracing.newSpan(this.core.context(), "manager_buckets_update_bucket", (RequestSpan)options.parentSpan().orElse(null));
        span.attribute("db.name", bucketName);
        CoreCommonOptions getAllBucketOptions = options.withParentSpan(span);
        return Mono.fromFuture(() -> this.getAllBuckets(getAllBucketOptions)).map(buckets -> buckets.containsKey(bucketName)).flatMap(bucketExists -> {
            if (!bucketExists.booleanValue()) {
                return Mono.error((Throwable)BucketNotFoundException.forBucket(bucketName));
            }
            return Mono.fromFuture((CompletableFuture)((CompletableFuture)this.httpClient.post(ClassicCoreBucketManager.pathForBucket(bucketName), options).form(this.convertSettingsToParams(settings, null, true)).exec(this.core).exceptionally(t -> {
                throw CbThrowables.propagate(ClassicCoreBucketManager.wrap(t));
            })).thenApply(response -> null));
        }).then().doOnTerminate(span::end).toFuture();
    }

    @Override
    public CompletableFuture<Void> dropBucket(String bucketName, CoreCommonOptions options) {
        return ((CompletableFuture)this.httpClient.delete(ClassicCoreBucketManager.pathForBucket(bucketName), options).trace("manager_buckets_drop_bucket").traceBucket(bucketName).exec(this.core).exceptionally((Function)ClassicCoreBucketManager.translateBucketNotFound(bucketName))).thenApply(response -> null);
    }

    @Override
    public CompletableFuture<CoreBucketSettings> getBucket(String bucketName, CoreCommonOptions options) {
        return ((CompletableFuture)this.httpClient.get(ClassicCoreBucketManager.pathForBucket(bucketName), options).trace("manager_buckets_get_bucket").traceBucket(bucketName).exec(this.core).exceptionally((Function)ClassicCoreBucketManager.translateBucketNotFound(bucketName))).thenApply(v -> CoreBucketSettingsJson.create(v.content()));
    }

    private static Function<Throwable, CoreHttpResponse> translateBucketNotFound(String bucketName) {
        return t -> {
            throw HttpStatusCodeException.couchbaseResponseStatus(t) == ResponseStatus.NOT_FOUND ? BucketNotFoundException.forBucket(bucketName) : CbThrowables.propagate(ClassicCoreBucketManager.wrap(t));
        };
    }

    @Override
    public CompletableFuture<Map<String, CoreBucketSettings>> getAllBuckets(CoreCommonOptions options) {
        return this.httpClient.get(ClassicCoreBucketManager.pathForBuckets(), options).trace("manager_buckets_get_all_buckets").exec(this.core).thenApply(response -> {
            JsonNode tree = Mapper.decodeIntoTree(response.content());
            HashMap<String, CoreBucketSettings> out = new HashMap<String, CoreBucketSettings>();
            for (JsonNode bucket : tree) {
                String bucketName = Objects.requireNonNull(bucket.get("name").textValue(), "Bucket json is missing 'name' field: " + RedactableArgument.redactMeta(bucket));
                out.put(bucketName, CoreBucketSettingsJson.create(bucket));
            }
            return out;
        });
    }

    @Override
    public CompletableFuture<Void> flushBucket(String bucketName, CoreCommonOptions options) {
        return ((CompletableFuture)this.httpClient.post(ClassicCoreBucketManager.pathForBucketFlush(bucketName), options).trace("manager_buckets_flush_bucket").traceBucket(bucketName).exec(this.core).exceptionally(t -> {
            if (HttpStatusCodeException.couchbaseResponseStatus(t) == ResponseStatus.INVALID_ARGS && HttpStatusCodeException.httpResponseBody(t).contains("Flush is disabled")) {
                throw BucketNotFlushableException.forBucket(bucketName);
            }
            return ClassicCoreBucketManager.translateBucketNotFound(bucketName).apply((Throwable)t);
        })).thenApply(response -> null);
    }

    private UrlQueryStringBuilder convertSettingsToParams(CoreBucketSettings settings, @Nullable CoreCreateBucketSettings createSpecificSettings, boolean update) {
        long maxTTL;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ramQuotaMB", String.valueOf(settings.ramQuotaMB()));
        if (settings.bucketType() != BucketType.MEMCACHED && settings.numReplicas() != null) {
            params.put("replicaNumber", String.valueOf(settings.numReplicas()));
        }
        if (settings.flushEnabled() != null) {
            params.put("flushEnabled", String.valueOf(settings.flushEnabled() != false ? 1 : 0));
        }
        if (settings.maxExpiry() != null && (maxTTL = settings.maxExpiry().getSeconds()) != 0L) {
            params.put("maxTTL", String.valueOf(maxTTL));
        }
        if (settings.evictionPolicy() != null) {
            params.put("evictionPolicy", settings.evictionPolicy().alias());
        }
        if (settings.compressionMode() != null) {
            params.put("compressionMode", settings.compressionMode().alias());
        }
        if (settings.minimumDurabilityLevel() != null && settings.minimumDurabilityLevel() != DurabilityLevel.NONE) {
            params.put("durabilityMinLevel", settings.minimumDurabilityLevel().encodeForManagementApi());
        }
        if (settings.storageBackend() != null) {
            params.put("storageBackend", settings.storageBackend().alias());
        }
        params.put("name", settings.name());
        if (settings.bucketType() != null) {
            params.put("bucketType", settings.bucketType().getRaw());
        }
        if (createSpecificSettings != null && createSpecificSettings.conflictResolutionType() != null) {
            params.put("conflictResolutionType", createSpecificSettings.conflictResolutionType().alias());
        }
        if (settings.bucketType() != null && settings.bucketType() != BucketType.EPHEMERAL && settings.replicaIndexes() != null) {
            params.put("replicaIndex", String.valueOf(settings.replicaIndexes() != false ? 1 : 0));
        }
        if (settings.historyRetentionCollectionDefault() != null) {
            params.put("historyRetentionCollectionDefault", settings.historyRetentionCollectionDefault().toString());
        }
        if (settings.historyRetentionBytes() != null) {
            params.put("historyRetentionBytes", settings.historyRetentionBytes().toString());
        }
        if (settings.historyRetentionDuration() != null) {
            params.put("historyRetentionSeconds", String.valueOf(TimeUnit.MILLISECONDS.toSeconds(settings.historyRetentionDuration().toMillis())));
        }
        if (update) {
            params.remove("name");
            params.remove("bucketType");
            params.remove("conflictResolutionType");
            params.remove("replicaIndex");
            params.remove("storageBackend");
        }
        UrlQueryStringBuilder form = UrlQueryStringBuilder.createForUrlSafeNames();
        params.forEach(form::set);
        return form;
    }
}

