/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.events.io.DurabilityTimeoutCoercedEvent;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufUtil;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.core.deps.org.iq80.snappy.Snappy;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.DurabilityLevelNotAvailableException;
import com.couchbase.client.core.error.FeatureNotAvailableException;
import com.couchbase.client.core.error.context.KeyValueErrorContext;
import com.couchbase.client.core.error.context.SubDocumentErrorContext;
import com.couchbase.client.core.error.subdoc.DeltaInvalidException;
import com.couchbase.client.core.error.subdoc.DocumentNotJsonException;
import com.couchbase.client.core.error.subdoc.DocumentTooDeepException;
import com.couchbase.client.core.error.subdoc.NumberTooBigException;
import com.couchbase.client.core.error.subdoc.PathExistsException;
import com.couchbase.client.core.error.subdoc.PathInvalidException;
import com.couchbase.client.core.error.subdoc.PathMismatchException;
import com.couchbase.client.core.error.subdoc.PathNotFoundException;
import com.couchbase.client.core.error.subdoc.PathTooDeepException;
import com.couchbase.client.core.error.subdoc.ValueInvalidException;
import com.couchbase.client.core.error.subdoc.ValueTooDeepException;
import com.couchbase.client.core.error.subdoc.XattrCannotModifyVirtualAttributeException;
import com.couchbase.client.core.error.subdoc.XattrInvalidKeyComboException;
import com.couchbase.client.core.error.subdoc.XattrNoAccessException;
import com.couchbase.client.core.error.subdoc.XattrUnknownMacroException;
import com.couchbase.client.core.error.subdoc.XattrUnknownVirtualAttributeException;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.msg.kv.MutationToken;
import com.couchbase.client.core.msg.kv.SubDocumentOpResponseStatus;
import com.couchbase.client.core.util.Bytes;
import com.couchbase.client.core.util.CbCollections;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import reactor.util.annotation.Nullable;

public final class MemcacheProtocol
extends Enum<MemcacheProtocol> {
    public static final int UNSIGNED_SHORT_MAX = 65535;
    static final int HEADER_SIZE = 24;
    static final int MAGIC_OFFSET = 0;
    static final int OPCODE_OFFSET = 1;
    static final int DATATYPE_OFFSET = 5;
    static final int STATUS_OFFSET = 6;
    static final int TOTAL_LENGTH_OFFSET = 8;
    static final int OPAQUE_OFFSET = 12;
    static final int CAS_OFFSET = 16;
    public static final byte SYNC_REPLICATION_FLEXIBLE_IDENT = 16;
    public static final byte PRESERVE_TTL_FLEXIBLE_IDENT = 80;
    public static final short SYNC_REPLICATION_TIMEOUT_FLOOR_MS = 1500;
    public static final byte FRAMING_EXTRAS_TRACING = 0;
    public static final byte FRAMING_EXTRAS_READ_UNITS_USED = 1;
    public static final byte FRAMING_EXTRAS_WRITE_UNITS_USED = 2;
    public static final int UNITS_NOT_PRESENT = -1;
    private static final /* synthetic */ MemcacheProtocol[] $VALUES;

    public static MemcacheProtocol[] values() {
        return (MemcacheProtocol[])$VALUES.clone();
    }

    public static MemcacheProtocol valueOf(String name) {
        return Enum.valueOf(MemcacheProtocol.class, name);
    }

    public static ByteBuf flexibleRequest(ByteBufAllocator alloc, Opcode opcode, byte datatype, short partition, int opaque, long cas, ByteBuf framingExtras, ByteBuf extras, ByteBuf key, ByteBuf body) {
        if (!framingExtras.isReadable()) {
            return MemcacheProtocol.request(alloc, opcode, datatype, partition, opaque, cas, extras, key, body);
        }
        int keySize = key.readableBytes();
        int extrasSize = extras.readableBytes();
        int framingExtrasSize = framingExtras.readableBytes();
        int totalBodySize = framingExtrasSize + extrasSize + keySize + body.readableBytes();
        return alloc.buffer(24 + totalBodySize).writeByte(Magic.FLEXIBLE_REQUEST.magic()).writeByte(opcode.opcode()).writeByte(framingExtrasSize).writeByte(keySize).writeByte(extrasSize).writeByte(datatype).writeShort(partition).writeInt(totalBodySize).writeInt(opaque).writeLong(cas).writeBytes(framingExtras).writeBytes(extras).writeBytes(key).writeBytes(body);
    }

    public static ByteBuf request(ByteBufAllocator alloc, Opcode opcode, byte datatype, short partition, int opaque, long cas, ByteBuf extras, ByteBuf key, ByteBuf body) {
        int keySize = key.readableBytes();
        int extrasSize = extras.readableBytes();
        int totalBodySize = extrasSize + keySize + body.readableBytes();
        return alloc.buffer(24 + totalBodySize).writeByte(Magic.REQUEST.magic()).writeByte(opcode.opcode()).writeShort(keySize).writeByte(extrasSize).writeByte(datatype).writeShort(partition).writeInt(totalBodySize).writeInt(opaque).writeLong(cas).writeBytes(extras).writeBytes(key).writeBytes(body);
    }

    public static ByteBuf response(ByteBufAllocator alloc, Opcode opcode, byte datatype, short status, int opaque, long cas, ByteBuf extras, ByteBuf key, ByteBuf body) {
        int keySize = key.readableBytes();
        int extrasSize = extras.readableBytes();
        int totalBodySize = extrasSize + keySize + body.readableBytes();
        return alloc.buffer(24 + totalBodySize).writeByte(Magic.RESPONSE.magic()).writeByte(opcode.opcode()).writeShort(keySize).writeByte(extrasSize).writeByte(datatype).writeShort(status).writeInt(totalBodySize).writeInt(opaque).writeLong(cas).writeBytes(extras).writeBytes(key).writeBytes(body);
    }

    public static short status(ByteBuf message) {
        return message.getShort(6);
    }

    public static short keyLength(ByteBuf message) {
        return MemcacheProtocol.isFlexible(message) ? (short)message.getByte(3) : message.getShort(2);
    }

    public static boolean isFlexible(ByteBuf message) {
        byte magic = MemcacheProtocol.magic(message);
        return magic == Magic.FLEXIBLE_REQUEST.magic() || magic == Magic.FLEXIBLE_RESPONSE.magic();
    }

    public static byte flexExtrasLength(ByteBuf message) {
        return MemcacheProtocol.isFlexible(message) ? message.getByte(2) : (byte)0;
    }

    public static byte extrasLength(ByteBuf message) {
        return message.getByte(4);
    }

    public static byte magic(ByteBuf message) {
        return message.getByte(0);
    }

    public static boolean isRequest(ByteBuf message) {
        byte magic = MemcacheProtocol.magic(message);
        return magic == Magic.FLEXIBLE_REQUEST.magic() || magic == Magic.REQUEST.magic();
    }

    public static int totalBodyLength(ByteBuf message) {
        return message.getInt(8);
    }

    public static boolean successful(ByteBuf message) {
        return MemcacheProtocol.status(message) == Status.SUCCESS.status();
    }

    public static byte opcode(ByteBuf message) {
        return message.getByte(1);
    }

    public static byte datatype(ByteBuf message) {
        return message.getByte(5);
    }

    public static int opaque(ByteBuf message) {
        return message.getInt(12);
    }

    public static long cas(ByteBuf message) {
        return message.getLong(16);
    }

    public static Optional<ByteBuf> body(ByteBuf message) {
        return Datatype.isSnappy(MemcacheProtocol.datatype(message)) ? Optional.of(Unpooled.wrappedBuffer(MemcacheProtocol.bodyAsBytes(message))) : MemcacheProtocol.rawBody(message);
    }

    public static Optional<ByteBuf> rawBody(ByteBuf message) {
        boolean flexible = message.getByte(0) == Magic.FLEXIBLE_RESPONSE.magic();
        int totalBodyLength = message.getInt(8);
        short keyLength = flexible ? message.getByte(3) : message.getShort(2);
        byte flexibleExtrasLength = flexible ? message.getByte(2) : (byte)0;
        byte extrasLength = message.getByte(4);
        int bodyLength = totalBodyLength - keyLength - extrasLength - flexibleExtrasLength;
        if (bodyLength > 0) {
            return Optional.of(message.slice(24 + flexibleExtrasLength + extrasLength + keyLength, bodyLength));
        }
        return Optional.empty();
    }

    public static Optional<ByteBuf> key(ByteBuf message) {
        short keyLength = MemcacheProtocol.keyLength(message);
        if (keyLength > 0) {
            return Optional.of(message.slice(24 + MemcacheProtocol.flexExtrasLength(message) + MemcacheProtocol.extrasLength(message), keyLength));
        }
        return Optional.empty();
    }

    public static byte[] bodyAsBytes(ByteBuf message) {
        boolean flexible = message.getByte(0) == Magic.FLEXIBLE_RESPONSE.magic();
        int totalBodyLength = message.getInt(8);
        short keyLength = flexible ? message.getByte(3) : message.getShort(2);
        byte flexibleExtrasLength = flexible ? message.getByte(2) : (byte)0;
        byte extrasLength = message.getByte(4);
        int bodyLength = totalBodyLength - keyLength - extrasLength - flexibleExtrasLength;
        if (bodyLength > 0) {
            byte[] bytes = ByteBufUtil.getBytes(message, 24 + flexibleExtrasLength + extrasLength + keyLength, bodyLength);
            return MemcacheProtocol.tryDecompression(bytes, MemcacheProtocol.datatype(message));
        }
        return Bytes.EMPTY_BYTE_ARRAY;
    }

    public static String bodyAsString(ByteBuf message) {
        return new String(MemcacheProtocol.bodyAsBytes(message), StandardCharsets.UTF_8);
    }

    public static Optional<ByteBuf> extras(ByteBuf message) {
        byte flexibleExtrasLength;
        boolean flexible = message.getByte(0) == Magic.FLEXIBLE_RESPONSE.magic();
        byte extrasLength = message.getByte(4);
        byte by = flexibleExtrasLength = flexible ? message.getByte(2) : (byte)0;
        if (extrasLength > 0) {
            return Optional.of(message.slice(24 + flexibleExtrasLength, extrasLength));
        }
        return Optional.empty();
    }

    public static int extrasAsInt(ByteBuf message, int offset, int defaultValue) {
        byte flexibleExtrasLength;
        boolean flexible = message.getByte(0) == Magic.FLEXIBLE_RESPONSE.magic();
        byte extrasLength = message.getByte(4);
        byte by = flexibleExtrasLength = flexible ? message.getByte(2) : (byte)0;
        if (extrasLength >= 4) {
            return message.getInt(24 + flexibleExtrasLength + offset);
        }
        return defaultValue;
    }

    @Nullable
    public static FlexibleExtras flexibleExtras(ByteBuf message) {
        int flexibleExtrasLength;
        int n = flexibleExtrasLength = message.getByte(0) == Magic.FLEXIBLE_RESPONSE.magic() ? message.getByte(2) : 0;
        if (flexibleExtrasLength > 0) {
            int readUnits = -1;
            int writeUnits = -1;
            long serverDuration = -1L;
            for (int offset = 0; offset < flexibleExtrasLength; ++offset) {
                byte control = message.getByte(24 + offset);
                byte id = (byte)((control & 0xF0) >> 4);
                byte len = (byte)(control & 0xF);
                if (id == 0) {
                    serverDuration = Math.round(Math.pow(message.getUnsignedShort(24 + offset + 1), 1.74) / 2.0);
                }
                if (id == 1) {
                    readUnits = message.getUnsignedShort(24 + offset + 1);
                } else if (id == 2) {
                    writeUnits = message.getUnsignedShort(24 + offset + 1);
                }
                offset += len;
            }
            return new FlexibleExtras(readUnits, writeUnits, serverDuration);
        }
        return null;
    }

    static boolean verifyRequest(ByteBuf request) {
        int readableBytes = request.readableBytes();
        if (readableBytes < 24) {
            return false;
        }
        byte magic = request.getByte(0);
        int bodyPlusHeader = request.getInt(8) + 24;
        return (magic == Magic.REQUEST.magic() || magic == Magic.FLEXIBLE_REQUEST.magic()) && readableBytes == bodyPlusHeader;
    }

    static boolean verifyResponse(ByteBuf response) {
        int readableBytes = response.readableBytes();
        if (readableBytes < 24) {
            return false;
        }
        byte magic = response.getByte(0);
        int bodyPlusHeader = response.getInt(8) + 24;
        return (magic == Magic.RESPONSE.magic() || magic == Magic.FLEXIBLE_RESPONSE.magic() || magic == Magic.SERVER_PUSH_REQUEST.magic) && readableBytes == bodyPlusHeader;
    }

    public static ByteBuf noKey() {
        return Unpooled.EMPTY_BUFFER;
    }

    public static ByteBuf noExtras() {
        return Unpooled.EMPTY_BUFFER;
    }

    public static ByteBuf noFramingExtras() {
        return Unpooled.EMPTY_BUFFER;
    }

    public static ByteBuf noBody() {
        return Unpooled.EMPTY_BUFFER;
    }

    public static byte noDatatype() {
        return 0;
    }

    public static short noPartition() {
        return 0;
    }

    public static int noOpaque() {
        return 0;
    }

    public static long noCas() {
        return 0L;
    }

    public static ResponseStatus decodeStatus(ByteBuf message) {
        return MemcacheProtocol.decodeStatus(MemcacheProtocol.status(message));
    }

    public static ByteBuf mutationFlexibleExtras(KeyValueRequest<?> request, KeyValueChannelContext ctx, ByteBufAllocator alloc, Optional<DurabilityLevel> durabilityLevel) {
        return MemcacheProtocol.mutationFlexibleExtras(request, ctx, alloc, durabilityLevel, false);
    }

    public static ByteBuf mutationFlexibleExtras(KeyValueRequest<?> request, KeyValueChannelContext ctx, ByteBufAllocator alloc, Optional<DurabilityLevel> durabilityLevel, boolean preserveExpiry) {
        if (!durabilityLevel.isPresent() && !preserveExpiry) {
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBuf result = alloc.buffer(5);
        try {
            if (preserveExpiry) {
                if (!ctx.preserveTtl()) {
                    throw new FeatureNotAvailableException("This version of Couchbase Server does not support preserving expiry when modifying documents.");
                }
                result.writeByte(80);
            }
            durabilityLevel.ifPresent(level -> {
                if (!ctx.syncReplicationEnabled()) {
                    throw new DurabilityLevelNotAvailableException(KeyValueErrorContext.incompleteRequest(request));
                }
                MemcacheProtocol.flexibleSyncReplication(result, level, request.timeout(), request.context());
            });
            return result;
        }
        catch (Throwable t) {
            ReferenceCountUtil.release(result);
            throw t;
        }
    }

    static ByteBuf flexibleSyncReplication(ByteBuf buffer, DurabilityLevel type, Duration timeout, CoreContext ctx) {
        int deadline;
        long userTimeout = timeout.toMillis();
        if (userTimeout >= 65535L) {
            deadline = 65534;
            ctx.environment().eventBus().publish(new DurabilityTimeoutCoercedEvent(ctx, userTimeout, deadline));
        } else {
            deadline = (int)((double)userTimeout * 0.9);
        }
        if (deadline < 1500) {
            deadline = 1500;
            ctx.environment().eventBus().publish(new DurabilityTimeoutCoercedEvent(ctx, userTimeout, deadline));
        }
        return buffer.writeByte(19).writeByte(type.code()).writeShort(deadline);
    }

    public static long parseServerDurationFromResponse(ByteBuf response) {
        int flexibleExtrasLength;
        int n = flexibleExtrasLength = response.getByte(0) == Magic.FLEXIBLE_RESPONSE.magic() ? response.getByte(2) : 0;
        if (flexibleExtrasLength > 0) {
            for (int offset = 0; offset < flexibleExtrasLength; ++offset) {
                byte control = response.getByte(24 + offset);
                byte id = (byte)(control & 0xF0);
                byte len = (byte)(control & 0xF);
                if (id == 0) {
                    return Math.round(Math.pow(response.getUnsignedShort(24 + offset + 1), 1.74) / 2.0);
                }
                offset += len;
            }
        }
        return 0L;
    }

    public static ResponseStatus decodeStatus(short status) {
        if (status == Status.SUCCESS.status) {
            return ResponseStatus.SUCCESS;
        }
        if (status == Status.NOT_FOUND.status) {
            return ResponseStatus.NOT_FOUND;
        }
        if (status == Status.EXISTS.status) {
            return ResponseStatus.EXISTS;
        }
        return MemcacheProtocol.decodeOtherStatus(status);
    }

    private static ResponseStatus decodeOtherStatus(short status) {
        if (status == Status.NOT_SUPPORTED.status) {
            return ResponseStatus.UNSUPPORTED;
        }
        if (status == Status.ACCESS_ERROR.status) {
            return ResponseStatus.NO_ACCESS;
        }
        if (status == Status.OUT_OF_MEMORY.status) {
            return ResponseStatus.OUT_OF_MEMORY;
        }
        if (status == Status.SERVER_BUSY.status) {
            return ResponseStatus.SERVER_BUSY;
        }
        if (status == Status.TEMPORARY_FAILURE.status) {
            return ResponseStatus.TEMPORARY_FAILURE;
        }
        if (status == Status.NOT_MY_VBUCKET.status) {
            return ResponseStatus.NOT_MY_VBUCKET;
        }
        if (status == Status.LOCKED.status) {
            return ResponseStatus.LOCKED;
        }
        if (status == Status.TOO_BIG.status) {
            return ResponseStatus.TOO_BIG;
        }
        if (status == Status.NOT_STORED.status) {
            return ResponseStatus.NOT_STORED;
        }
        if (status == Status.DURABILITY_INVALID_LEVEL.status) {
            return ResponseStatus.DURABILITY_INVALID_LEVEL;
        }
        if (status == Status.DURABILITY_IMPOSSIBLE.status) {
            return ResponseStatus.DURABILITY_IMPOSSIBLE;
        }
        if (status == Status.SYNC_WRITE_AMBIGUOUS.status) {
            return ResponseStatus.SYNC_WRITE_AMBIGUOUS;
        }
        if (status == Status.SYNC_WRITE_IN_PROGRESS.status) {
            return ResponseStatus.SYNC_WRITE_IN_PROGRESS;
        }
        if (status == Status.SYNC_WRITE_RE_COMMIT_IN_PROGRESS.status) {
            return ResponseStatus.SYNC_WRITE_RE_COMMIT_IN_PROGRESS;
        }
        if (status == Status.SUBDOC_MULTI_PATH_FAILURE.status || status == Status.SUBDOC_MULTI_PATH_FAILURE_DELETED.status || status == Status.SUBDOC_DOC_NOT_JSON.status || status == Status.SUBDOC_XATTR_INVALID_KEY_COMBO.status || status == Status.SUBDOC_DOC_TOO_DEEP.status || status == Status.SUBDOC_INVALID_COMBO.status || status == Status.SUBDOC_CAN_ONLY_REVIVE_DELETED_DOCUMENTS.status) {
            return ResponseStatus.SUBDOC_FAILURE;
        }
        if (status == Status.SUBDOC_SUCCESS_DELETED_DOCUMENT.status) {
            return ResponseStatus.SUCCESS;
        }
        if (status == Status.UNKNOWN_COLLECTION.status) {
            return ResponseStatus.UNKNOWN_COLLECTION;
        }
        if (status == Status.NO_COLLECTIONS_MANIFEST.status) {
            return ResponseStatus.NO_COLLECTIONS_MANIFEST;
        }
        if (status == Status.NO_BUCKET.status) {
            return ResponseStatus.NO_BUCKET;
        }
        if (status == Status.INTERNAL_SERVER_ERROR.status) {
            return ResponseStatus.INTERNAL_SERVER_ERROR;
        }
        if (status == Status.NOT_INITIALIZED.status) {
            return ResponseStatus.NOT_INITIALIZED;
        }
        if (status == Status.INVALID_REQUEST.status) {
            return ResponseStatus.INVALID_REQUEST;
        }
        if (status == Status.CANNOT_APPLY_COLLECTIONS_MANIFEST.status) {
            return ResponseStatus.CANNOT_APPLY_COLLECTIONS_MANIFEST;
        }
        if (status == Status.COLLECTIONS_MANIFEST_AHEAD.status) {
            return ResponseStatus.COLLECTIONS_MANIFEST_AHEAD;
        }
        if (status == Status.UNKNOWN_SCOPE.status) {
            return ResponseStatus.UNKNOWN_SCOPE;
        }
        if (status == Status.RATE_LIMITED_NETWORK_EGRESS.status || status == Status.RATE_LIMITED_NETWORK_INGRESS.status || status == Status.RATE_LIMITED_MAX_CONNECTIONS.status || status == Status.RATE_LIMITED_MAX_COMMANDS.status) {
            return ResponseStatus.RATE_LIMITED;
        }
        if (status == Status.SCOPE_SIZE_LIMIT_EXCEEDED.status) {
            return ResponseStatus.QUOTA_LIMITED;
        }
        if (status == Status.RANGE_SCAN_MORE.status) {
            return ResponseStatus.CONTINUE;
        }
        if (status == Status.RANGE_SCAN_COMPLETE.status) {
            return ResponseStatus.COMPLETE;
        }
        if (status == Status.RANGE_SCAN_CANCELLED.status) {
            return ResponseStatus.CANCELED;
        }
        if (status == Status.RANGE_ERROR.status) {
            return ResponseStatus.RANGE_ERROR;
        }
        if (status == Status.VBUUID_NOT_EQUAL.status) {
            return ResponseStatus.VBUUID_NOT_EQUAL;
        }
        return ResponseStatus.UNKNOWN;
    }

    public static SubDocumentOpResponseStatus decodeSubDocumentStatus(short status) {
        if (status == Status.SUCCESS.status) {
            return SubDocumentOpResponseStatus.SUCCESS;
        }
        if (status == Status.SUBDOC_PATH_NOT_FOUND.status) {
            return SubDocumentOpResponseStatus.PATH_NOT_FOUND;
        }
        if (status == Status.SUBDOC_PATH_MISMATCH.status) {
            return SubDocumentOpResponseStatus.PATH_MISMATCH;
        }
        if (status == Status.SUBDOC_PATH_INVALID.status) {
            return SubDocumentOpResponseStatus.PATH_INVALID;
        }
        if (status == Status.SUBDOC_PATH_TOO_BIG.status) {
            return SubDocumentOpResponseStatus.PATH_TOO_BIG;
        }
        if (status == Status.SUBDOC_DOC_TOO_DEEP.status) {
            return SubDocumentOpResponseStatus.DOC_TOO_DEEP;
        }
        if (status == Status.SUBDOC_VALUE_CANTINSERT.status) {
            return SubDocumentOpResponseStatus.VALUE_CANTINSERT;
        }
        if (status == Status.SUBDOC_DOC_NOT_JSON.status) {
            return SubDocumentOpResponseStatus.DOC_NOT_JSON;
        }
        if (status == Status.SUBDOC_NUM_RANGE.status) {
            return SubDocumentOpResponseStatus.NUM_RANGE;
        }
        if (status == Status.SUBDOC_DELTA_RANGE.status) {
            return SubDocumentOpResponseStatus.DELTA_RANGE;
        }
        if (status == Status.SUBDOC_PATH_EXISTS.status) {
            return SubDocumentOpResponseStatus.PATH_EXISTS;
        }
        if (status == Status.SUBDOC_VALUE_TOO_DEEP.status) {
            return SubDocumentOpResponseStatus.VALUE_TOO_DEEP;
        }
        if (status == Status.SUBDOC_INVALID_COMBO.status) {
            return SubDocumentOpResponseStatus.INVALID_COMBO;
        }
        if (status == Status.SUBDOC_MULTI_PATH_FAILURE.status) {
            return SubDocumentOpResponseStatus.MULTI_PATH_FAILURE;
        }
        if (status == Status.SUBDOC_MULTI_PATH_FAILURE_DELETED.status) {
            return SubDocumentOpResponseStatus.MULTI_PATH_FAILURE;
        }
        if (status == Status.SUBDOC_XATTR_INVALID_FLAG_COMBO.status) {
            return SubDocumentOpResponseStatus.XATTR_INVALID_FLAG_COMBO;
        }
        if (status == Status.SUBDOC_XATTR_INVALID_KEY_COMBO.status) {
            return SubDocumentOpResponseStatus.XATTR_INVALID_KEY_COMBO;
        }
        if (status == Status.SUBDOC_XATTR_UNKNOWN_MACRO.status) {
            return SubDocumentOpResponseStatus.XATTR_UNKNOWN_MACRO;
        }
        if (status == Status.SUBDOC_SUCCESS_DELETED_DOCUMENT.status) {
            return SubDocumentOpResponseStatus.SUCCESS_DELETED_DOCUMENT;
        }
        if (status == Status.SUBDOC_XATTR_UNKNOWN_VATTR.status) {
            return SubDocumentOpResponseStatus.XATTR_UNKNOWN_VATTR;
        }
        if (status == Status.SUBDOC_XATTR_CANNOT_MODIFY_VATTR.status) {
            return SubDocumentOpResponseStatus.XATTR_CANNOT_MODIFY_VATTR;
        }
        if (status == Status.SUBDOC_INVALID_XATTR_ORDER.status) {
            return SubDocumentOpResponseStatus.XATTR_INVALID_ORDER;
        }
        if (status == Status.ACCESS_ERROR.status) {
            return SubDocumentOpResponseStatus.XATTR_NO_ACCESS;
        }
        return SubDocumentOpResponseStatus.UNKNOWN;
    }

    public static CouchbaseException mapSubDocumentError(KeyValueRequest<?> request, SubDocumentOpResponseStatus status, String path, int index, @Nullable FlexibleExtras flexibleExtras) {
        SubDocumentErrorContext ctx = new SubDocumentErrorContext(KeyValueErrorContext.completedRequest(request, ResponseStatus.SUBDOC_FAILURE, flexibleExtras), index, path, status, null, null);
        switch (status) {
            case PATH_NOT_FOUND: {
                return new PathNotFoundException(ctx);
            }
            case PATH_MISMATCH: {
                return new PathMismatchException(ctx);
            }
            case PATH_TOO_BIG: {
                return new PathTooDeepException(ctx);
            }
            case PATH_INVALID: {
                return new PathInvalidException(ctx);
            }
            case DOC_TOO_DEEP: {
                return new DocumentTooDeepException(ctx);
            }
            case VALUE_CANTINSERT: {
                return new ValueInvalidException(ctx);
            }
            case DOC_NOT_JSON: {
                return new DocumentNotJsonException(ctx);
            }
            case NUM_RANGE: {
                return new NumberTooBigException(ctx);
            }
            case DELTA_RANGE: {
                return new DeltaInvalidException(ctx);
            }
            case PATH_EXISTS: {
                return new PathExistsException(ctx);
            }
            case VALUE_TOO_DEEP: {
                return new ValueTooDeepException(ctx);
            }
            case XATTR_UNKNOWN_MACRO: {
                return new XattrUnknownMacroException(ctx);
            }
            case XATTR_INVALID_KEY_COMBO: {
                return new XattrInvalidKeyComboException(ctx);
            }
            case XATTR_UNKNOWN_VATTR: {
                return new XattrUnknownVirtualAttributeException(ctx);
            }
            case XATTR_CANNOT_MODIFY_VATTR: {
                return new XattrCannotModifyVirtualAttributeException(ctx);
            }
            case XATTR_NO_ACCESS: {
                return new XattrNoAccessException(ctx);
            }
        }
        return new CouchbaseException("Unexpected SubDocument response code", ctx);
    }

    public static ByteBuf tryCompression(byte[] input, double minRatio) {
        byte[] compressed = Snappy.compress(input);
        if ((double)compressed.length / (double)input.length > minRatio) {
            return null;
        }
        return Unpooled.wrappedBuffer(compressed);
    }

    public static byte[] tryDecompression(byte[] input, byte datatype) {
        if (Datatype.isSnappy(datatype)) {
            return Snappy.uncompress(input, 0, input.length);
        }
        return input;
    }

    public static String messageToString(ByteBuf message) {
        StringBuilder sb = new StringBuilder();
        byte magic = message.getByte(0);
        sb.append(String.format("Magic: 0x%x (%s)\n", new Object[]{magic, Magic.of(magic)}));
        sb.append(String.format("Opcode: 0x%x\n", MemcacheProtocol.opcode(message)));
        if (Magic.of(magic).isFlexible()) {
            sb.append(String.format("Framing Extras Length: %d\n", message.getByte(2)));
            sb.append(String.format("Key Length: %d\n", message.getByte(3)));
        } else {
            sb.append(String.format("Key Length: %d\n", message.getShort(2)));
        }
        sb.append(String.format("Extras Length: %d\n", message.getByte(4)));
        sb.append(String.format("Datatype: 0x%x\n", MemcacheProtocol.datatype(message)));
        if (Magic.of(magic).isRequest()) {
            sb.append(String.format("VBucket ID: 0x%x\n", MemcacheProtocol.status(message)));
        } else {
            sb.append(String.format("Status: 0x%x\n", MemcacheProtocol.status(message)));
        }
        sb.append(String.format("Total Body Length: %d\n", message.getByte(8)));
        sb.append(String.format("Opaque: 0x%x\n", MemcacheProtocol.opaque(message)));
        sb.append(String.format("CAS: 0x%x\n", MemcacheProtocol.cas(message)));
        return sb.toString();
    }

    public static Optional<MutationToken> extractToken(boolean enabled, short partition, ByteBuf msg, String bucket) {
        if (!enabled || MemcacheProtocol.decodeStatus(msg) != ResponseStatus.SUCCESS) {
            return Optional.empty();
        }
        return MemcacheProtocol.extras(msg).map(e -> new MutationToken(partition, e.readLong(), e.readLong(), bucket));
    }

    private static /* synthetic */ MemcacheProtocol[] $values() {
        return new MemcacheProtocol[0];
    }

    static {
        $VALUES = MemcacheProtocol.$values();
    }

    public static enum Opcode {
        GET(0),
        SET(1),
        ADD(2),
        REPLACE(3),
        DELETE(4),
        INCREMENT(5),
        DECREMENT(6),
        NOOP(10),
        APPEND(14),
        PREPEND(15),
        HELLO(31),
        ERROR_MAP(-2),
        SELECT_BUCKET(-119),
        SASL_LIST_MECHS(32),
        SASL_AUTH(33),
        SASL_STEP(34),
        GET_CONFIG(-75),
        COLLECTIONS_GET_CID(-69),
        SUBDOC_MULTI_LOOKUP(-48),
        SUBDOC_MULTI_MUTATE(-47),
        GET_AND_TOUCH(29),
        GET_AND_LOCK(-108),
        OBSERVE_CAS(-110),
        OBSERVE_SEQ(-111),
        GET_REPLICA(-125),
        TOUCH(28),
        UNLOCK(-107),
        DELETE_WITH_META(-88),
        COLLECTIONS_GET_MANIFEST(-70),
        GET_META(-96),
        RANGE_SCAN_CREATE(-38),
        RANGE_SCAN_CONTINUE(-37),
        RANGE_SCAN_CANCEL(-36);

        private final byte opcode;

        private Opcode(byte opcode) {
            this.opcode = opcode;
        }

        public byte opcode() {
            return this.opcode;
        }

        @Nullable
        public static Opcode of(byte input) {
            switch (input) {
                case 0: {
                    return GET;
                }
                case 1: {
                    return SET;
                }
                case 2: {
                    return ADD;
                }
                case 3: {
                    return REPLACE;
                }
                case 4: {
                    return DELETE;
                }
                case 5: {
                    return INCREMENT;
                }
                case 6: {
                    return DECREMENT;
                }
                case 10: {
                    return NOOP;
                }
                case 14: {
                    return APPEND;
                }
                case 15: {
                    return PREPEND;
                }
                case 31: {
                    return HELLO;
                }
                case -2: {
                    return ERROR_MAP;
                }
                case -119: {
                    return SELECT_BUCKET;
                }
                case 32: {
                    return SASL_LIST_MECHS;
                }
                case 33: {
                    return SASL_AUTH;
                }
                case 34: {
                    return SASL_STEP;
                }
                case -75: {
                    return GET_CONFIG;
                }
                case -69: {
                    return COLLECTIONS_GET_CID;
                }
                case -48: {
                    return SUBDOC_MULTI_LOOKUP;
                }
                case -47: {
                    return SUBDOC_MULTI_MUTATE;
                }
                case 29: {
                    return GET_AND_TOUCH;
                }
                case -108: {
                    return GET_AND_LOCK;
                }
                case -110: {
                    return OBSERVE_CAS;
                }
                case -111: {
                    return OBSERVE_SEQ;
                }
                case -125: {
                    return GET_REPLICA;
                }
                case 28: {
                    return TOUCH;
                }
                case -107: {
                    return UNLOCK;
                }
                case -88: {
                    return DELETE_WITH_META;
                }
                case -70: {
                    return COLLECTIONS_GET_MANIFEST;
                }
                case -96: {
                    return GET_META;
                }
                case -38: {
                    return RANGE_SCAN_CREATE;
                }
                case -37: {
                    return RANGE_SCAN_CONTINUE;
                }
                case -36: {
                    return RANGE_SCAN_CANCEL;
                }
            }
            return null;
        }
    }

    public static enum Magic {
        REQUEST(-128),
        RESPONSE(-127),
        FLEXIBLE_REQUEST(8),
        FLEXIBLE_RESPONSE(24),
        SERVER_PUSH_REQUEST(-126),
        SERVER_PUSH_RESPONSE(-125);

        private final byte magic;

        private Magic(byte magic) {
            this.magic = magic;
        }

        public byte magic() {
            return this.magic;
        }

        public boolean isServerPush() {
            return this == SERVER_PUSH_REQUEST || this == SERVER_PUSH_RESPONSE;
        }

        @Nullable
        public static Magic of(byte input) {
            switch (input) {
                case -128: {
                    return REQUEST;
                }
                case -127: {
                    return RESPONSE;
                }
                case 8: {
                    return FLEXIBLE_REQUEST;
                }
                case 24: {
                    return FLEXIBLE_RESPONSE;
                }
                case -126: {
                    return SERVER_PUSH_REQUEST;
                }
                case -125: {
                    return SERVER_PUSH_RESPONSE;
                }
            }
            return null;
        }

        public boolean isFlexible() {
            return this == FLEXIBLE_REQUEST || this == FLEXIBLE_RESPONSE;
        }

        public boolean isRequest() {
            return this == REQUEST || this == FLEXIBLE_REQUEST;
        }
    }

    public static enum Status {
        SUCCESS(0),
        NOT_FOUND(1),
        EXISTS(2),
        TOO_BIG(3),
        INVALID_REQUEST(4),
        NOT_STORED(5),
        NOT_MY_VBUCKET(7),
        NO_BUCKET(8),
        LOCKED(9),
        AUTH_ERROR(32),
        RANGE_ERROR(34),
        ACCESS_ERROR(36),
        NOT_INITIALIZED(37),
        INTERNAL_SERVER_ERROR(132),
        TEMPORARY_FAILURE(134),
        SERVER_BUSY(133),
        UNKNOWN_COMMAND(129),
        OUT_OF_MEMORY(130),
        NOT_SUPPORTED(131),
        SUBDOC_PATH_NOT_FOUND(192),
        SUBDOC_PATH_MISMATCH(193),
        SUBDOC_PATH_INVALID(194),
        SUBDOC_PATH_TOO_BIG(195),
        SUBDOC_DOC_TOO_DEEP(196),
        SUBDOC_VALUE_CANTINSERT(197),
        SUBDOC_DOC_NOT_JSON(198),
        SUBDOC_NUM_RANGE(199),
        SUBDOC_DELTA_RANGE(200),
        SUBDOC_PATH_EXISTS(201),
        SUBDOC_VALUE_TOO_DEEP(202),
        SUBDOC_INVALID_COMBO(203),
        SUBDOC_MULTI_PATH_FAILURE(204),
        SUBDOC_XATTR_INVALID_FLAG_COMBO(206),
        SUBDOC_XATTR_INVALID_KEY_COMBO(207),
        SUBDOC_XATTR_UNKNOWN_MACRO(208),
        SUBDOC_XATTR_UNKNOWN_VATTR(209),
        SUBDOC_XATTR_CANNOT_MODIFY_VATTR(210),
        SUBDOC_SUCCESS_DELETED_DOCUMENT(205),
        SUBDOC_MULTI_PATH_FAILURE_DELETED(211),
        SUBDOC_INVALID_XATTR_ORDER(212),
        SUBDOC_CAN_ONLY_REVIVE_DELETED_DOCUMENTS(214),
        DURABILITY_INVALID_LEVEL(160),
        DURABILITY_IMPOSSIBLE(161),
        SYNC_WRITE_IN_PROGRESS(162),
        SYNC_WRITE_RE_COMMIT_IN_PROGRESS(164),
        SYNC_WRITE_AMBIGUOUS(163),
        RANGE_SCAN_CANCELLED(165),
        RANGE_SCAN_MORE(166),
        RANGE_SCAN_COMPLETE(167),
        VBUUID_NOT_EQUAL(168),
        UNKNOWN_COLLECTION(136),
        NO_COLLECTIONS_MANIFEST(137),
        CANNOT_APPLY_COLLECTIONS_MANIFEST(138),
        COLLECTIONS_MANIFEST_AHEAD(139),
        UNKNOWN_SCOPE(140),
        RATE_LIMITED_NETWORK_INGRESS(48),
        RATE_LIMITED_NETWORK_EGRESS(49),
        RATE_LIMITED_MAX_CONNECTIONS(50),
        RATE_LIMITED_MAX_COMMANDS(51),
        SCOPE_SIZE_LIMIT_EXCEEDED(52);

        private final short status;

        private Status(short status) {
            this.status = status;
        }

        public short status() {
            return this.status;
        }

        @Nullable
        public static Status of(short input) {
            switch (input) {
                case 0: {
                    return SUCCESS;
                }
                case 1: {
                    return NOT_FOUND;
                }
                case 2: {
                    return EXISTS;
                }
                case 3: {
                    return TOO_BIG;
                }
                case 4: {
                    return INVALID_REQUEST;
                }
                case 5: {
                    return NOT_STORED;
                }
                case 7: {
                    return NOT_MY_VBUCKET;
                }
                case 8: {
                    return NO_BUCKET;
                }
                case 9: {
                    return LOCKED;
                }
                case 32: {
                    return AUTH_ERROR;
                }
                case 34: {
                    return RANGE_ERROR;
                }
                case 36: {
                    return ACCESS_ERROR;
                }
                case 37: {
                    return NOT_INITIALIZED;
                }
                case 132: {
                    return INTERNAL_SERVER_ERROR;
                }
                case 133: {
                    return SERVER_BUSY;
                }
                case 134: {
                    return TEMPORARY_FAILURE;
                }
                case 129: {
                    return UNKNOWN_COMMAND;
                }
                case 130: {
                    return OUT_OF_MEMORY;
                }
                case 131: {
                    return NOT_SUPPORTED;
                }
                case 192: {
                    return SUBDOC_PATH_NOT_FOUND;
                }
                case 193: {
                    return SUBDOC_PATH_MISMATCH;
                }
                case 194: {
                    return SUBDOC_PATH_INVALID;
                }
                case 195: {
                    return SUBDOC_PATH_TOO_BIG;
                }
                case 196: {
                    return SUBDOC_DOC_TOO_DEEP;
                }
                case 197: {
                    return SUBDOC_VALUE_CANTINSERT;
                }
                case 198: {
                    return SUBDOC_DOC_NOT_JSON;
                }
                case 199: {
                    return SUBDOC_NUM_RANGE;
                }
                case 200: {
                    return SUBDOC_DELTA_RANGE;
                }
                case 201: {
                    return SUBDOC_PATH_EXISTS;
                }
                case 202: {
                    return SUBDOC_VALUE_TOO_DEEP;
                }
                case 203: {
                    return SUBDOC_INVALID_COMBO;
                }
                case 204: {
                    return SUBDOC_MULTI_PATH_FAILURE;
                }
                case 206: {
                    return SUBDOC_XATTR_INVALID_FLAG_COMBO;
                }
                case 207: {
                    return SUBDOC_XATTR_INVALID_KEY_COMBO;
                }
                case 208: {
                    return SUBDOC_XATTR_UNKNOWN_MACRO;
                }
                case 209: {
                    return SUBDOC_XATTR_UNKNOWN_VATTR;
                }
                case 210: {
                    return SUBDOC_XATTR_CANNOT_MODIFY_VATTR;
                }
                case 205: {
                    return SUBDOC_SUCCESS_DELETED_DOCUMENT;
                }
                case 211: {
                    return SUBDOC_MULTI_PATH_FAILURE_DELETED;
                }
                case 212: {
                    return SUBDOC_INVALID_XATTR_ORDER;
                }
                case 214: {
                    return SUBDOC_CAN_ONLY_REVIVE_DELETED_DOCUMENTS;
                }
                case 160: {
                    return DURABILITY_INVALID_LEVEL;
                }
                case 161: {
                    return DURABILITY_IMPOSSIBLE;
                }
                case 162: {
                    return SYNC_WRITE_IN_PROGRESS;
                }
                case 164: {
                    return SYNC_WRITE_RE_COMMIT_IN_PROGRESS;
                }
                case 163: {
                    return SYNC_WRITE_AMBIGUOUS;
                }
                case 165: {
                    return RANGE_SCAN_CANCELLED;
                }
                case 166: {
                    return RANGE_SCAN_MORE;
                }
                case 167: {
                    return RANGE_SCAN_COMPLETE;
                }
                case 168: {
                    return VBUUID_NOT_EQUAL;
                }
                case 136: {
                    return UNKNOWN_COLLECTION;
                }
                case 137: {
                    return NO_COLLECTIONS_MANIFEST;
                }
                case 138: {
                    return CANNOT_APPLY_COLLECTIONS_MANIFEST;
                }
                case 139: {
                    return COLLECTIONS_MANIFEST_AHEAD;
                }
                case 140: {
                    return UNKNOWN_SCOPE;
                }
                case 48: {
                    return RATE_LIMITED_NETWORK_INGRESS;
                }
                case 49: {
                    return RATE_LIMITED_NETWORK_EGRESS;
                }
                case 50: {
                    return RATE_LIMITED_MAX_CONNECTIONS;
                }
                case 51: {
                    return RATE_LIMITED_MAX_COMMANDS;
                }
                case 52: {
                    return SCOPE_SIZE_LIMIT_EXCEEDED;
                }
            }
            return null;
        }
    }

    public static enum Datatype {
        JSON(1),
        SNAPPY(2),
        XATTR(4);

        private final byte bitmask;
        private static final List<Datatype> valueList;
        private static final int allBits;
        private static final List<Set<Datatype>> precomputed;

        private Datatype(int bitmask) {
            this.bitmask = (byte)Datatype.require8Bit(bitmask);
        }

        private static int require8Bit(int value) {
            if ((value & 0xFF) != value) {
                throw new IllegalArgumentException("Expected a value that fits in 8 bits, but got: 0x" + Integer.toHexString(value));
            }
            return value;
        }

        public byte datatype() {
            return this.bitmask;
        }

        public static Set<Datatype> decode(int bitfield) {
            return precomputed.get(bitfield & allBits);
        }

        public static int encode(Set<Datatype> type) {
            int bitfield = 0;
            for (Datatype it : type) {
                bitfield |= it.bitmask;
            }
            return bitfield;
        }

        private static Set<Datatype> doDecode(int bitfield) {
            EnumSet<Datatype> result = EnumSet.noneOf(Datatype.class);
            for (Datatype type : valueList) {
                if (!Datatype.contains(bitfield, type)) continue;
                result.add(type);
            }
            return result;
        }

        public static boolean isSnappy(int bitfield) {
            return Datatype.contains(bitfield, SNAPPY);
        }

        public static boolean contains(int bitfield, Datatype type) {
            return (bitfield & type.bitmask) != 0;
        }

        static {
            valueList = CbCollections.listCopyOf(Arrays.asList(Datatype.values()));
            allBits = Datatype.encode(EnumSet.allOf(Datatype.class));
            precomputed = new ArrayList<Set<Datatype>>(allBits + 1);
            for (int i = 0; i <= allBits; ++i) {
                precomputed.add(Collections.unmodifiableSet(Datatype.doDecode(i)));
            }
        }
    }

    public static class FlexibleExtras {
        public final int readUnits;
        public final int writeUnits;
        public final long serverDuration;

        public FlexibleExtras(int readUnits, int writeUnits, long serverDuration) {
            this.readUnits = readUnits;
            this.writeUnits = writeUnits;
            this.serverDuration = serverDuration;
        }

        public void injectExportableParams(Map<String, Object> input) {
            if (this.readUnits != -1) {
                input.put("readUnits", this.readUnits);
            }
            if (this.writeUnits != -1) {
                input.put("writeUnits", this.writeUnits);
            }
            if (this.serverDuration != -1L) {
                input.put("serverDuration", this.serverDuration);
            }
        }
    }

    public static enum ServerPushOpcode {
        CLUSTERMAP_CHANGE_NOTIFICATION(1),
        AUTHENTICATE(2),
        ACTIVE_EXTERNAL_USERS(3);

        private final byte opcode;

        private ServerPushOpcode(byte opcode) {
            this.opcode = opcode;
        }

        public byte opcode() {
            return this.opcode;
        }

        @Nullable
        public static ServerPushOpcode of(byte input) {
            switch (input) {
                case 1: {
                    return CLUSTERMAP_CHANGE_NOTIFICATION;
                }
                case 2: {
                    return AUTHENTICATE;
                }
                case 3: {
                    return ACTIVE_EXTERNAL_USERS;
                }
            }
            return null;
        }
    }
}

