/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.search;

import com.couchbase.client.core.endpoint.BaseEndpoint;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.QuotaLimitedException;
import com.couchbase.client.core.error.RateLimitedException;
import com.couchbase.client.core.error.context.SearchErrorContext;
import com.couchbase.client.core.io.netty.chunk.ChunkedMessageHandler;
import com.couchbase.client.core.io.netty.search.SearchChunkResponseParser;
import com.couchbase.client.core.msg.search.SearchChunkHeader;
import com.couchbase.client.core.msg.search.SearchChunkRow;
import com.couchbase.client.core.msg.search.SearchChunkTrailer;
import com.couchbase.client.core.msg.search.SearchRequest;
import com.couchbase.client.core.msg.search.SearchResponse;
import com.couchbase.client.core.retry.RetryReason;
import java.util.Optional;

class ChunkedSearchMessageHandler
extends ChunkedMessageHandler<SearchChunkHeader, SearchChunkRow, SearchChunkTrailer, SearchResponse, SearchRequest> {
    private static final int HTTP_TOO_MANY_REQUESTS = 429;

    ChunkedSearchMessageHandler(BaseEndpoint endpoint, EndpointContext endpointContext) {
        super(endpoint, endpointContext, new SearchChunkResponseParser());
    }

    @Override
    protected Optional<RetryReason> qualifiesForRetry(CouchbaseException exception) {
        if (exception instanceof RateLimitedException || exception instanceof QuotaLimitedException) {
            return Optional.empty();
        }
        if (exception.context() instanceof SearchErrorContext && ((SearchErrorContext)exception.context()).httpStatus() == 429) {
            return Optional.of(RetryReason.SEARCH_TOO_MANY_REQUESTS);
        }
        return Optional.empty();
    }
}

